/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.network.CrystallizeEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class LocationRitual
extends Ritual {
    TagKey<Structure> structureTagKey;
    public static final ResourceLocation SYMBOL = new ResourceLocation("eidolon", "particle/summon_ritual");

    public LocationRitual(TagKey<Structure> structureTagKey) {
        super(SYMBOL, ColorUtil.packColor(255, 121, 94, 255));
        this.structureTagKey = structureTagKey;
    }

    @Override
    public Component getName() {
        return Component.m_237110_((String)"eidolon.location", (Object[])new Object[]{this.structureTagKey.f_203868_().m_135815_()});
    }

    @Override
    public Ritual cloneRitual() {
        return new LocationRitual(this.structureTagKey);
    }

    @Override
    public Ritual.RitualResult start(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Networking.sendToTracking((Level)world, pos, new CrystallizeEffectPacket(pos));
            BlockPos structure = world.m_215011_(this.structureTagKey, pos, 100, true);
            if (structure != null) {
                ItemStack mapStack = MapItem.m_42886_((Level)world, (int)structure.m_123341_(), (int)structure.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)world, (ItemStack)mapStack);
                MapItemSavedData.m_77925_((ItemStack)mapStack, (BlockPos)structure, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
                mapStack.m_41714_((Component)Component.m_237113_((String)"Magic Map"));
                world.m_7967_((Entity)new ItemEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, mapStack));
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

