/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.gson.JsonElement;
import elucent.eidolon.Eidolon;
import elucent.eidolon.datagen.SimpleDataProvider;
import elucent.eidolon.recipe.ForagingRecipe;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.RegistryUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class EidForagingProvider
extends SimpleDataProvider {
    List<ForagingRecipe> recipes = new ArrayList<ForagingRecipe>();

    public EidForagingProvider(DataGenerator gen) {
        super(gen);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addRecipes();
        for (ForagingRecipe recipe : this.recipes) {
            Path path = EidForagingProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, (JsonElement)recipe.toJson(), path);
        }
    }

    private void addRecipes() {
        this.addForaging((ItemLike)Registry.SILDRIAN_SEED.get(), Blocks.f_50053_);
        this.addForaging((ItemLike)Registry.OANNA_BLOOM.get(), Blocks.f_50196_);
        this.addForaging((ItemLike)Registry.MERAMMER_ROOT.get(), Blocks.f_50120_, Blocks.f_50071_, Blocks.f_50118_);
        this.addForaging((ItemLike)Registry.AVENNIAN_SPRIG.get(), Blocks.f_50035_, Blocks.f_50360_);
        this.addForaging((ItemLike)Registry.MIRECAP.get(), Blocks.f_50700_, Blocks.f_50691_);
    }

    public void addForaging(ItemLike result, Block ... blocks) {
        this.recipes.add(new ForagingRecipe(Eidolon.prefix("forage_" + RegistryUtil.getRegistryName(result.m_5456_()).m_135815_()), new ItemStack(result), Ingredient.m_43929_((ItemLike[])blocks)));
    }

    public void addForaging(ItemLike result, TagKey<Item> blockItemTag) {
        this.recipes.add(new ForagingRecipe(Eidolon.prefix("forage_" + RegistryUtil.getRegistryName(result.m_5456_()).m_135815_()), new ItemStack(result), Ingredient.m_204132_(blockItemTag)));
    }

    @NotNull
    public String m_6055_() {
        return "Eidolon Foraging";
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon/recipes/" + str + ".json");
    }
}

