/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import elucent.eidolon.recipe.WorktableRegistry;
import elucent.eidolon.registries.EidolonRecipes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class WorktableRecipe
implements Recipe<Container> {
    final Ingredient[] core;
    final Ingredient[] extras;
    final ItemStack result;
    ResourceLocation registryName;

    public WorktableRecipe(Ingredient[] core, Ingredient[] extras, ItemStack result) {
        this.core = core;
        this.extras = extras;
        this.result = result;
    }

    @Deprecated
    public WorktableRecipe(ItemStack[] inputs, ItemStack result) {
        this.core = new Ingredient[9];
        this.extras = new Ingredient[4];
        for (int i = 0; i < inputs.length; ++i) {
            if (i < 9) {
                this.core[i] = Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputs[i]});
                continue;
            }
            this.extras[i - 9] = Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputs[i]});
        }
        this.result = result;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public WorktableRecipe setRegistryName(String domain, String path) {
        this.registryName = new ResourceLocation(domain, path);
        return this;
    }

    public WorktableRecipe setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    public Ingredient[] getCore() {
        return this.core;
    }

    public Ingredient[] getOuter() {
        return this.extras;
    }

    public boolean matches(Container coreInv, Container extraInv) {
        int i;
        if (coreInv.m_6643_() < 9 || extraInv.m_6643_() < 4 || this.core == null) {
            return false;
        }
        for (i = 0; i < this.core.length; ++i) {
            if (this.core[i] == null || this.core[i].test(coreInv.m_8020_(i))) continue;
            return false;
        }
        for (i = 0; i < this.extras.length; ++i) {
            if (this.extras[i] == null || this.extras[i].test(extraInv.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(Container coreInv, Container extraInv) {
        NonNullList items = NonNullList.m_122780_((int)13, (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            Container inv = i < 9 ? coreInv : extraInv;
            ItemStack item = inv.m_8020_(i < 9 ? i : i - 9);
            if (!item.hasCraftingRemainingItem()) continue;
            items.set(i, (Object)item.getCraftingRemainingItem());
        }
        return items;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        Collections.addAll(ingredients, this.core);
        Collections.addAll(ingredients, this.extras);
        return ingredients;
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public boolean m_5818_(@NotNull Container inv, @NotNull Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.registryName;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.WORKTABLE_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.WORKTABLE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<WorktableRecipe> {
        @NotNull
        public WorktableRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
            String key;
            HashMap<String, Ingredient> ingredientMap = new HashMap<String, Ingredient>();
            JsonObject keys = json.getAsJsonObject("key");
            for (Map.Entry e : keys.entrySet()) {
                if (((String)e.getKey()).length() != 1) {
                    throw new RuntimeException("Recipe ingredient key must be a single character");
                }
                ingredientMap.put((String)e.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)e.getValue()).getAsJsonObject()));
            }
            Ingredient[] core = new Ingredient[9];
            Ingredient[] extras = new Ingredient[4];
            JsonArray pattern = json.getAsJsonArray("pattern");
            if (pattern.size() != 3) {
                throw new JsonSyntaxException("All worktable recipes must have three rows.");
            }
            for (int i = 0; i < 3; ++i) {
                if (pattern.get(i).getAsString().length() != 3) {
                    throw new JsonSyntaxException("All worktable recipe rows must have three columns.");
                }
                for (int j = 0; j < 3; ++j) {
                    Ingredient item;
                    key = pattern.get(i).getAsString().substring(j, j + 1);
                    core[i * 3 + j] = item = key.equals(" ") ? Ingredient.f_43901_ : (Ingredient)ingredientMap.get(key);
                }
            }
            String reagents = json.get("reagents").getAsString();
            if (reagents.length() != 4) {
                throw new JsonSyntaxException("All worktable recipes must have reagent strings of length 4.");
            }
            for (int i = 0; i < 4; ++i) {
                key = reagents.substring(i, i + 1);
                extras[i] = key.equals(" ") ? Ingredient.f_43901_ : (Ingredient)ingredientMap.get(key);
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (boolean)true);
            return WorktableRegistry.register(new WorktableRecipe(core, extras, result).setRegistryName(recipeId));
        }

        public WorktableRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            int i;
            Ingredient[] core = new Ingredient[9];
            Ingredient[] extras = new Ingredient[4];
            for (i = 0; i < 9; ++i) {
                core[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            for (i = 0; i < 4; ++i) {
                extras[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            ItemStack result = buffer.m_130267_();
            return WorktableRegistry.register(new WorktableRecipe(core, extras, result).setRegistryName(recipeId));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull WorktableRecipe recipe) {
            int i;
            for (i = 0; i < 9; ++i) {
                recipe.core[i].m_43923_(buffer);
            }
            for (i = 0; i < 4; ++i) {
                recipe.extras[i].m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

