/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.util.BlockApiCache;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.me.key.SourceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class SourceStorageExportStrategy
implements StackExportStrategy {
    private final BlockApiCache<IAdvancedSourceTile> apiCache;
    private final Direction fromSide;

    public SourceStorageExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockApiCache.create(ArsEngCapabilities.SOURCE_TILE, (ServerLevel)level, (BlockPos)fromPos);
        this.fromSide = fromSide;
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!(what instanceof SourceKey)) {
            return 0L;
        }
        IAdvancedSourceTile sourceTile = (IAdvancedSourceTile)this.apiCache.find(this.fromSide);
        if (sourceTile != null) {
            int insertable = (int)Math.min(amount, (long)(sourceTile.getMaxSource() - sourceTile.getSource()));
            int extracted = (int)StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)context.getInternalStorage().getInventory(), (AEKey)SourceKey.KEY, (long)insertable, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE);
            if (extracted > 0) {
                sourceTile.addSource(extracted);
            }
            return extracted;
        }
        return 0L;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof SourceKey)) {
            return 0L;
        }
        IAdvancedSourceTile sourceTile = (IAdvancedSourceTile)this.apiCache.find(this.fromSide);
        if (sourceTile != null) {
            int inserted = (int)Math.min(amount, (long)(sourceTile.getMaxSource() - sourceTile.getSource()));
            if (inserted > 0 && mode == Actionable.MODULATE) {
                sourceTile.addSource(inserted);
            }
            return inserted;
        }
        return 0L;
    }
}

