/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.event;

import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.item.EquipmentUtil;
import com.legacy.lost_aether.LostContentConfig;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.capability.entity.ILCMoa;
import com.legacy.lost_aether.capability.entity.LCMoa;
import com.legacy.lost_aether.capability.player.LCPlayer;
import com.legacy.lost_aether.client.audio.LCMusicTicker;
import com.legacy.lost_aether.client.render.SentryShieldRenderer;
import com.legacy.lost_aether.data.LCTags;
import com.legacy.lost_aether.registry.LCItems;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

public class LCClientEvents {
    private static final ResourceLocation MOA_BAR_TEXTURES = LostContentMod.locate("textures/gui/moa_bars.png");

    @SubscribeEvent
    public static void onRenderArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        PoseStack poseStack = event.getPoseStack();
        if (player != null) {
            Optional.ofNullable(EquipmentUtil.getCurio((LivingEntity)player, (Item)LCItems.sentry_shield)).ifPresent(slot -> {
                String identifier = slot.slotContext().identifier();
                ItemStack itemStack = slot.stack();
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(identifier).ifPresent(stacksHandler -> {
                    if (((Boolean)stacksHandler.getRenders().get(slot.slotContext().index())).booleanValue()) {
                        CuriosRendererRegistry.getRenderer((Item)itemStack.m_41720_()).ifPresent(renderer -> {
                            if (renderer instanceof SentryShieldRenderer) {
                                SentryShieldRenderer shieldRenderer = (SentryShieldRenderer)renderer;
                                shieldRenderer.renderFirstPerson(itemStack, poseStack, event.getMultiBufferSource(), event.getPackedLight(), player, event.getArm());
                            }
                        });
                    }
                }));
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && event.getFlags().m_257552_() && stack.m_204117_(LCTags.Items.PLATINUM_DUNGEON_LOOT)) {
            event.getToolTip().add(1, LCItems.PLATINUM_DUNGEON_TOOLTIP);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        LCPlayer.ifPresent(LCClientEvents.mc().f_91074_, p -> p.renderFog(event));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        LCPlayer.ifPresent(LCClientEvents.mc().f_91074_, p -> p.modifyFogColor(event));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.type.equals((Object)TickEvent.Type.CLIENT) && !LCClientEvents.mc().m_91104_()) {
            LCMusicTicker.INSTANCE.m_7673_();
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = LCClientEvents.mc().f_91074_;
        ClientLevel world = LCClientEvents.mc().f_91073_;
        if (world == null || world != null && !world.f_46443_) {
            return;
        }
        if (player != null) {
            LCPlayer.ifPresent(player, skyPlayer -> skyPlayer.clientTick());
        }
    }

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "moa_speed_modifier", (gui, graphics, partialTick, screenWidth, screenHeight) -> {
            Entity patt4296$temp = gui.getMinecraft().f_91074_.m_20202_();
            if (patt4296$temp instanceof Moa) {
                Moa moa = (Moa)patt4296$temp;
                if (!gui.getMinecraft().f_91066_.f_92062_) {
                    LCMoa.ifPresent(moa, lcm -> {
                        if (lcm.hasSpeedMultiplier()) {
                            gui.setupOverlayRenderState(true, false);
                            float f = lcm.lerpedSpeedMultiplier(partialTick);
                            int j = (int)(f * 182.0f);
                            int k = screenHeight - 32 + 3;
                            int x = screenWidth / 2 - 91;
                            int barOffset = 0;
                            graphics.m_280218_(MOA_BAR_TEXTURES, x, k, 0, barOffset, 182, 5);
                            if (j > 0) {
                                graphics.m_280218_(MOA_BAR_TEXTURES, x, k, 0, barOffset + 5, j, 5);
                            }
                        }
                    });
                }
            }
        });
    }

    @SubscribeEvent
    public static void renderOverlayPre(RenderGuiOverlayEvent.Pre event) {
        Moa moa;
        ILCMoa lcmoa;
        Entity entity;
        ResourceLocation id = event.getOverlay().id();
        if (id.equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) && (entity = LCClientEvents.mc().f_91074_.m_20202_()) instanceof Moa && (lcmoa = LCMoa.get(moa = (Moa)entity)) != null && lcmoa.hasSpeedMultiplier()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFovChange(ViewportEvent.ComputeFov event) {
        double scale = (Double)LostContentConfig.CLIENT.orangeMoaFovScale.get();
        Entity entity = LCClientEvents.mc().f_91074_.m_20202_();
        if (entity instanceof Moa) {
            ILCMoa lcmoa;
            Moa moa = (Moa)entity;
            if (scale > 0.0 && (lcmoa = LCMoa.get(moa)) != null && lcmoa.hasSpeedMultiplier()) {
                event.setFOV(event.getFOV() + scale * (double)lcmoa.lerpedSpeedMultiplier((float)event.getPartialTick()));
            }
        }
    }

    private static Minecraft mc() {
        return Minecraft.m_91087_();
    }
}

