/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.event;

import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.passive.FlyingCow;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.entity.passive.Phyg;
import com.aetherteam.aether.entity.passive.WingedAnimal;
import com.aetherteam.aether.event.EggLayEvent;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.miscellaneous.MoaEggItem;
import com.legacy.lost_aether.LostContentConfig;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.capability.CapabilityProvider;
import com.legacy.lost_aether.capability.entity.ILCMoa;
import com.legacy.lost_aether.capability.entity.LCMoa;
import com.legacy.lost_aether.capability.entity.WingedAnimalCap;
import com.legacy.lost_aether.capability.player.ILCPlayer;
import com.legacy.lost_aether.capability.player.LCPlayer;
import com.legacy.lost_aether.client.MountRotationType;
import com.legacy.lost_aether.data.LCTags;
import com.legacy.lost_aether.network.PacketHandler;
import com.legacy.lost_aether.network.SetWingTypePacket;
import com.legacy.lost_aether.registry.LCItems;
import com.legacy.lost_aether.registry.LCMoaTypes;
import com.legacy.lost_aether.registry.LCSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotResult;

public class LCEvents {
    @SubscribeEvent
    public static void onEggLay(EggLayEvent event) {
        Moa moa;
        Item item = event.getItem();
        Entity dropper = event.getEntity();
        if (item instanceof MoaEggItem && dropper instanceof Moa && (moa = (Moa)dropper).m_217043_().m_188501_() < 0.8f && (moa.getMoaType() == AetherMoaTypes.BLUE.get() || moa.getMoaType() == LCMoaTypes.ORANGE.get())) {
            boolean isBlue = moa.getMoaType() == AetherMoaTypes.BLUE.get();
            List list = moa.m_9236_().m_6443_(Moa.class, moa.m_20191_().m_82377_(7.0, 3.0, 7.0), EntitySelector.f_20403_.and(EntitySelector.f_20406_).and(e -> {
                Moa m2;
                return e instanceof Moa && (m2 = (Moa)e).getMoaType() != null;
            }));
            boolean hasOther = false;
            for (Moa moas : list) {
                if (isBlue && moas.getMoaType() == LCMoaTypes.ORANGE.get() || !isBlue && moas.getMoaType() == AetherMoaTypes.BLUE.get()) {
                    hasOther = true;
                }
                if (!hasOther) continue;
                event.setItem((Item)LCItems.brown_moa_egg);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LCPlayer.ifPresent(player, ILCPlayer::serverTick);
        }
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            LCMoa.ifPresent(moa, ILCMoa::serverTick);
        }
    }

    public static void onEntityTickLast(LivingEntity entity) {
        MountableAnimal mount;
        Entity entity2;
        if (entity instanceof MountableAnimal && (entity2 = (mount = (MountableAnimal)entity).m_146895_()) instanceof Player) {
            Player rider = (Player)entity2;
            if (mount.m_6109_()) {
                ((MountRotationType)((Object)LostContentConfig.CLIENT.mountRotationType.get())).applyRotations((LivingEntity)mount, (LivingEntity)rider);
            }
        }
    }

    @SubscribeEvent
    public static void onTrack(PlayerEvent.StartTracking event) {
        Player player;
        if ((event.getTarget() instanceof FlyingCow || event.getTarget() instanceof Phyg) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            WingedAnimalCap.ifPresent((Animal)event.getTarget(), winged -> PacketHandler.sendToClient(new SetWingTypePacket(event.getTarget().m_19879_(), winged.getWingType()), sp));
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttached(AttachCapabilitiesEvent<Entity> event) {
        Player p;
        Object object;
        if (event.getObject() instanceof FlyingCow || event.getObject() instanceof Phyg) {
            event.addCapability(LostContentMod.locate("winged_animal"), new CapabilityProvider<WingedAnimalCap>(new WingedAnimalCap((Animal)event.getObject())));
        }
        if ((object = event.getObject()) instanceof Player) {
            p = (Player)object;
            event.addCapability(LostContentMod.locate("player_capability"), new CapabilityProvider<LCPlayer>(new LCPlayer(p)));
        }
        if ((object = event.getObject()) instanceof Moa) {
            p = (Moa)object;
            event.addCapability(LostContentMod.locate("moa_capability"), new CapabilityProvider<LCMoa>(new LCMoa((Moa)p)));
        }
    }

    @SubscribeEvent
    public static void destroyBlock(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Player player = event.getPlayer();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        if (!player.m_7500_() && player.m_36298_(state) && player.m_21205_().m_204117_(LCTags.Items.PHOENIX_TOOLS)) {
            if (event.getExpToDrop() > 0) {
                state.m_60734_().m_49805_(level, pos, event.getExpToDrop());
            }
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_());
            drops.forEach(itemStack -> Block.m_49840_((Level)level.m_6018_(), (BlockPos)pos, (ItemStack)LCEvents.getSmeltedResult(itemStack, (Level)level.m_6018_())));
            level.m_6018_().m_46597_(pos, Blocks.f_50016_.m_49966_());
            return;
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity blocker = event.getEntity();
        DamageSource source = event.getDamageSource();
        if (blocker.m_21211_().m_204117_(LCTags.Items.AETHER_SHIELDS)) {
            Entity entity;
            Entity entity2;
            blocker.m_9236_().m_5594_(null, blocker.m_20183_(), SoundEvents.f_12600_, blocker.m_5720_(), 0.4f, 0.8f + blocker.m_9236_().m_213780_().m_188501_() * 0.4f);
            if (blocker.m_21211_().m_41720_() == LCItems.gravitite_shield && (entity2 = source.m_7640_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                attacker.m_147240_(1.5, blocker.m_20185_() - attacker.m_20185_(), blocker.m_20189_() - attacker.m_20189_());
                attacker.m_6034_(attacker.m_20185_(), attacker.m_20186_() + 1.0, attacker.m_20189_());
                attacker.f_19812_ = true;
            } else if (blocker.m_21211_().m_150930_((Item)LCItems.shield_of_emile) && (entity = source.m_7640_()) instanceof Projectile) {
                Projectile proj = (Projectile)entity;
                Projectile newProj = (Projectile)proj.m_6095_().m_20615_(proj.m_9236_());
                newProj.m_146884_(proj.m_20182_());
                CompoundTag tag = new CompoundTag();
                proj.m_20223_(tag);
                newProj.m_20258_(tag);
                proj.m_146870_();
                Vec3 vec3d = blocker.m_20252_(1.0f);
                double x = -(blocker.m_20185_() - (blocker.m_20185_() + vec3d.f_82479_ * 16.0));
                double y = vec3d.f_82480_ * 8.0;
                double z = -(blocker.m_20189_() - (blocker.m_20189_() + vec3d.f_82481_ * 16.0));
                newProj.m_6686_(x, y, z, 1.25f, 0.0f);
                blocker.m_9236_().m_7967_((Entity)newProj);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && !player.m_7500_()) {
                DamageSource source = event.getSource();
                boolean isShielding = !player.m_21211_().m_41619_() && player.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK);
                LCEvents.getAccessory(player, LCItems.sentry_shield).ifPresent(slot -> {
                    if (source.m_269533_(DamageTypeTags.f_268415_)) {
                        slot.stack().m_41622_(1, (LivingEntity)player, p -> {});
                        event.setCanceled(true);
                    } else if (event.getAmount() > 0.0f && player.m_217043_().m_188499_() && !isShielding && source != player.m_9236_().m_269111_().m_269549_() && player.f_20916_ <= 0 && !player.m_20159_()) {
                        player.m_9236_().m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
                        slot.stack().m_41622_(1, (LivingEntity)player, p -> {});
                    }
                });
                LCEvents.getAccessory(player, LCItems.flaming_gemstone).ifPresent(slot -> {
                    LivingEntity attacker;
                    Entity patt10642$temp;
                    if (event.getAmount() > 0.0f && (patt10642$temp = source.m_7640_()) instanceof LivingEntity && !(attacker = (LivingEntity)patt10642$temp).m_6060_() && !attacker.m_5825_() && (player.m_21211_() == null || player.m_21211_() != null && !player.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK))) {
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12609_, player.m_5720_(), 1.0f, 1.0f);
                        attacker.m_20254_(3);
                        Level patt11052$temp = player.m_9236_();
                        if (patt11052$temp instanceof ServerLevel) {
                            ServerLevel sl = (ServerLevel)patt11052$temp;
                            float width = player.m_20205_() / 2.0f;
                            float height = player.m_20206_() * 0.3f;
                            sl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), 60, (double)width, (double)height, (double)width, (double)0.3f);
                        }
                        slot.stack().m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
                    }
                });
                LCEvents.getAccessory(player, LCItems.invincibility_gem).ifPresent(slot -> {
                    if (!player.m_21023_(MobEffects.f_19609_) && !isShielding && player.m_217043_().m_188501_() < 0.1f) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 160, 0, true, true, true));
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12052_, player.m_5720_(), 1.0f, 1.0f);
                        Level patt11889$temp = player.m_9236_();
                        if (patt11889$temp instanceof ServerLevel) {
                            ServerLevel sl = (ServerLevel)patt11889$temp;
                            float width = player.m_20205_() / 2.0f;
                            float height = player.m_20206_() * 0.3f;
                            sl.m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), 40, (double)width, (double)height, (double)width, (double)0.1f);
                        }
                        slot.stack().m_41622_(1, (LivingEntity)player, p -> {});
                        event.setCanceled(true);
                    }
                });
            }
        }
        if ((livingEntity = event.getSource().m_7640_()) instanceof Player) {
            player = (Player)livingEntity;
            LCEvents.getAccessory(player, LCItems.power_gloves).ifPresent(slot -> {
                if (player.m_21205_().m_41619_() && EquipmentUtil.isFullStrength((LivingEntity)player)) {
                    player.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                    player.m_5496_(SoundEvents.f_11928_, 1.0f, 0.7f + player.m_217043_().m_188501_() * 0.2f);
                    event.getEntity().m_147240_(1.5, player.m_20185_() - event.getEntity().m_20185_(), player.m_20189_() - event.getEntity().m_20189_());
                    LivingEntity patt12853$temp = event.getEntity();
                    if (patt12853$temp instanceof Player) {
                        Player p2 = (Player)patt12853$temp;
                        p2.f_19864_ = true;
                    }
                    slot.stack().m_41622_(1, (LivingEntity)player, p -> {});
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        DamageSource source = event.getSource();
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21205_().m_204117_(LCTags.Items.PHOENIX_TOOLS) && event.getEntity().m_6060_()) {
            event.setAmount(event.getAmount() * 1.2f);
        }
        if (source == event.getEntity().m_269291_().m_269515_() && event.getEntity().m_6844_(EquipmentSlot.HEAD).m_150930_(LCItems.swetty_mask)) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Moa moa;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Moa && (moa = (Moa)livingEntity).getMoaType() == LCMoaTypes.BROWN.get() && moa.m_20160_()) {
            moa.m_20256_(moa.m_20184_().m_193103_(Direction.Axis.Y, (double)1.2f));
        }
    }

    @SubscribeEvent
    public static void onPotionApply(MobEffectEvent.Applicable event) {
        Moa moa;
        LivingEntity livingEntity;
        if (event.getEffectInstance().m_19544_() == AetherEffects.INEBRIATION.get() && (livingEntity = event.getEntity()) instanceof Moa && (moa = (Moa)livingEntity).getMoaType() == LCMoaTypes.BROWN.get()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof WingedAnimal) {
            WingedAnimal a = (WingedAnimal)mob;
            if (event.getSpawnType() != MobSpawnType.BREEDING) {
                WingedAnimalCap.ifPresent(a, winged -> winged.setWingType((WingedAnimalCap.WingType)((Object)((Object)Util.m_214670_((Object[])WingedAnimalCap.WingType.values(), (RandomSource)RandomSource.m_216335_((long)a.m_146902_().m_45588_()))))));
            }
        }
    }

    @SubscribeEvent
    public static void onFinalizeSpawn(BabyEntitySpawnEvent event) {
        AgeableMob ageableMob = event.getChild();
        if (ageableMob instanceof WingedAnimal) {
            WingedAnimal child = (WingedAnimal)ageableMob;
            ageableMob = event.getParentA();
            if (ageableMob instanceof WingedAnimal) {
                WingedAnimal a = (WingedAnimal)ageableMob;
                ageableMob = event.getParentB();
                if (ageableMob instanceof WingedAnimal) {
                    WingedAnimal b = (WingedAnimal)ageableMob;
                    WingedAnimalCap.ifPresent(child, winged -> {
                        byte aType = (Byte)WingedAnimalCap.getIfPresent(a, parent -> parent.getWingType(), () -> 0);
                        byte bType = (Byte)WingedAnimalCap.getIfPresent(b, parent -> parent.getWingType(), () -> 0);
                        winged.setWingType(child.m_217043_().m_188499_() ? bType : aType);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlayLevelSoundEvent event) {
        if (((Boolean)LostContentConfig.WORLD.mutationAnimalSounds.get()).booleanValue() && event.getSound() != null) {
            Optional holder;
            SoundEvent sound = (SoundEvent)event.getSound().get();
            SoundEvent ns = null;
            if (sound == AetherSoundEvents.ENTITY_FLYING_COW_AMBIENT.get()) {
                ns = LCSounds.ENTITY_FLYING_COW_IDLE;
            }
            if (sound == AetherSoundEvents.ENTITY_FLYING_COW_HURT.get()) {
                ns = LCSounds.ENTITY_FLYING_COW_HURT;
            }
            if (sound == AetherSoundEvents.ENTITY_FLYING_COW_DEATH.get()) {
                ns = LCSounds.ENTITY_FLYING_COW_DEATH;
            }
            if (sound == AetherSoundEvents.ENTITY_PHYG_AMBIENT.get()) {
                ns = LCSounds.ENTITY_PHYG_IDLE;
            }
            if (sound == AetherSoundEvents.ENTITY_PHYG_HURT.get()) {
                ns = LCSounds.ENTITY_PHYG_HURT;
            }
            if (sound == AetherSoundEvents.ENTITY_PHYG_DEATH.get()) {
                ns = LCSounds.ENTITY_PHYG_DEATH;
            }
            if (sound == AetherSoundEvents.ENTITY_SHEEPUFF_AMBIENT.get()) {
                ns = LCSounds.ENTITY_SHEEPUFF_IDLE;
            }
            if (sound == AetherSoundEvents.ENTITY_SHEEPUFF_HURT.get()) {
                ns = LCSounds.ENTITY_SHEEPUFF_HURT;
            }
            if (sound == AetherSoundEvents.ENTITY_SHEEPUFF_DEATH.get()) {
                ns = LCSounds.ENTITY_SHEEPUFF_DEATH;
            }
            if (ns != null && (holder = ForgeRegistries.SOUND_EVENTS.getHolder((Object)ns)).isPresent()) {
                event.setSound((Holder)holder.get());
            }
        }
    }

    private static ItemStack getSmeltedResult(ItemStack stack, Level level) {
        ItemStack output = stack;
        SimpleContainer inventory = new SimpleContainer(new ItemStack[]{stack});
        output = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)inventory, level).map(arg_0 -> LCEvents.lambda$getSmeltedResult$18((Container)inventory, level, arg_0)).orElse(stack);
        output.m_41764_(stack.m_41613_());
        return output;
    }

    public static Optional<SlotResult> getAccessory(Player player, Item item) {
        return Optional.ofNullable(EquipmentUtil.getCurio((LivingEntity)player, (Item)item));
    }

    private static /* synthetic */ ItemStack lambda$getSmeltedResult$18(Container inventory, Level level, SmeltingRecipe furnaceRecipe) {
        return furnaceRecipe.m_5874_(inventory, level.m_9598_());
    }
}

