/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.world.feature;

import com.aetherteam.aether.block.AetherBlocks;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CrystalTreeFeature
extends TreeFeature {
    public static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Arrays.stream(Direction.values()).filter(d -> d.m_122434_() != Direction.Axis.Y).toArray(Direction[]::new);

    public CrystalTreeFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_225257_(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> pRootBlockSetter, BiConsumer<BlockPos, BlockState> pTrunkBlockSetter, FoliagePlacer.FoliageSetter pFoliageBlockSetter, TreeConfiguration pConfig) {
        int z;
        if (!this.isAreaOk(world, pos, 7, 1, 8, 3) || !world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        for (int i = 0; i < 7; ++i) {
            this.setBlock(pTrunkBlockSetter, world, pos.m_6630_(i), ((RotatedPillarBlock)AetherBlocks.SKYROOT_LOG.get()).m_49966_());
        }
        this.setBlock((arg_0, arg_1) -> ((FoliagePlacer.FoliageSetter)pFoliageBlockSetter).m_271838_(arg_0, arg_1), world, pos.m_6630_(7), this.getRandomLeaf(rand));
        int smallWidth = 1;
        for (int i = 0; i < 5; ++i) {
            Direction dir;
            int n;
            Direction[] directionArray = HORIZONTAL_DIRECTIONS;
            int n2 = directionArray.length;
            for (n = 0; n < n2; ++n) {
                dir = directionArray[n];
                this.setBlock((arg_0, arg_1) -> ((FoliagePlacer.FoliageSetter)pFoliageBlockSetter).m_271838_(arg_0, arg_1), world, pos.m_6630_(2 + i).m_121945_(dir), this.getRandomLeaf(rand));
            }
            if (i != 1 && i != 3) continue;
            for (int x = -smallWidth; x <= smallWidth; ++x) {
                for (z = -smallWidth; z <= smallWidth; ++z) {
                    this.setBlock((arg_0, arg_1) -> ((FoliagePlacer.FoliageSetter)pFoliageBlockSetter).m_271838_(arg_0, arg_1), world, pos.m_7918_(x, 2 + i, z), this.getRandomLeaf(rand));
                }
            }
            Direction[] x = HORIZONTAL_DIRECTIONS;
            z = x.length;
            for (n = 0; n < z; ++n) {
                dir = x[n];
                this.setBlock((arg_0, arg_1) -> ((FoliagePlacer.FoliageSetter)pFoliageBlockSetter).m_271838_(arg_0, arg_1), world, pos.m_6630_(2 + i).m_5484_(dir, 2), this.getRandomLeaf(rand));
            }
        }
        int width = 2;
        for (int x = -width; x <= width; ++x) {
            for (z = -width; z <= width; ++z) {
                if (Math.abs(x) == width) {
                    if (Math.abs(x) == Math.abs(z)) continue;
                }
                this.setBlock((arg_0, arg_1) -> ((FoliagePlacer.FoliageSetter)pFoliageBlockSetter).m_271838_(arg_0, arg_1), world, pos.m_7918_(x, 2, z), this.getRandomLeaf(rand));
            }
        }
        return true;
    }

    private BlockState getRandomLeaf(RandomSource rand) {
        return rand.m_188501_() < 0.05f ? ((Block)AetherBlocks.CRYSTAL_FRUIT_LEAVES.get()).m_49966_() : ((Block)AetherBlocks.CRYSTAL_LEAVES.get()).m_49966_();
    }

    public boolean isAreaOk(WorldGenLevel world, BlockPos pos, int trunkHeight, int trunkWidth, int leafStartHeight, int leafWidth) {
        if (pos.m_123342_() >= 1 && pos.m_123342_() + trunkHeight + 1 < world.m_151558_()) {
            if (trunkWidth == 1) {
                for (y = 0; y <= 1 + trunkHeight && pos.m_123342_() + y >= 1 && pos.m_123342_() + y < world.m_151558_(); ++y) {
                    if (this.isReplaceableByLogs(world, pos.m_6630_(y)) || this.isLeavesOrLog(world.m_8055_(pos.m_6630_(y)))) continue;
                    return false;
                }
            } else {
                for (y = 0; y <= 1 + trunkHeight && pos.m_123342_() + y >= 1 && pos.m_123342_() + y < world.m_151558_(); ++y) {
                    for (int x = 0; x < trunkWidth; ++x) {
                        for (int z = 0; z < trunkWidth; ++z) {
                            if (this.isReplaceableByLogs(world, pos.m_7918_(x, y, z)) || this.isLeavesOrLog(world.m_8055_(pos.m_7918_(x, y, z)))) continue;
                            return false;
                        }
                    }
                }
            }
            int width = Math.max((leafWidth - 1) / 2, 1);
            for (int y = leafStartHeight; y <= trunkHeight + 2 && pos.m_123342_() + y >= 0 && pos.m_123342_() + y < world.m_151558_(); ++y) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (this.isReplaceableByLeaves(world, pos.m_7918_(x, y, z)) || this.isLeavesOrLog(world.m_8055_(pos.m_7918_(x, y, z)))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean setBlockIfOk(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel level, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof RotatedPillarBlock) {
            if (this.isReplaceableByLogs(level, pos)) {
                this.setBlock(changedBlocks, level, pos, state);
                return true;
            }
            return false;
        }
        if (block instanceof LeavesBlock) {
            if (this.isReplaceableByLeaves(level, pos)) {
                this.setBlock(changedBlocks, level, pos, state);
                return true;
            }
            return false;
        }
        if (level.m_46859_(pos) && state.m_60710_((LevelReader)level, pos)) {
            BlockState lower;
            this.setBlock(changedBlocks, level, pos, state);
            if (block instanceof SnowLayerBlock && (lower = level.m_8055_(pos.m_7495_())).m_61138_((Property)BlockStateProperties.f_61451_)) {
                level.m_7731_(pos.m_7495_(), (BlockState)lower.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)), 2);
            }
            return true;
        }
        return false;
    }

    protected void setBlock(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel level, BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        TreeFeature.m_67256_((LevelWriter)level, (BlockPos)pos, (BlockState)state);
        if (changedBlocks != null) {
            changedBlocks.accept(pos, state);
        }
    }

    public boolean isReplaceableByLeaves(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_247087_() || state.m_204336_(BlockTags.f_278411_);
    }

    public boolean isReplaceableByLogs(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_247087_() || state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13106_);
    }

    public boolean isLeavesOrLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
    }
}

