/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.authlib.GameProfile;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.net.UpdateTabNameMessage;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FTBEPlayerData {
    private static final Map<UUID, FTBEPlayerData> MAP = new HashMap<UUID, FTBEPlayerData>();
    private final UUID uuid;
    private final String name;
    private boolean needSave;
    private boolean muted;
    private boolean canFly;
    private boolean god;
    private String nick;
    private TeleportPos lastSeenPos;
    private final SavedTeleportManager.HomeManager homes;
    private RecordingStatus recording;
    private final Map<String, Long> kitUseTimes;
    public final WarmupCooldownTeleporter backTeleporter;
    public final WarmupCooldownTeleporter spawnTeleporter;
    public final WarmupCooldownTeleporter warpTeleporter;
    public final WarmupCooldownTeleporter homeTeleporter;
    public final WarmupCooldownTeleporter tpaTeleporter;
    public final WarmupCooldownTeleporter rtpTeleporter;
    public final LinkedList<TeleportPos> teleportHistory;

    public FTBEPlayerData(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.needSave = false;
        this.muted = false;
        this.canFly = false;
        this.god = false;
        this.nick = "";
        this.lastSeenPos = new TeleportPos((ResourceKey<Level>)Level.f_46428_, BlockPos.f_121853_);
        this.recording = RecordingStatus.NONE;
        this.kitUseTimes = new HashMap<String, Long>();
        this.homes = new SavedTeleportManager.HomeManager(this);
        this.backTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.BACK::getCooldown, FTBEConfig.BACK::getWarmup, true);
        this.spawnTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.SPAWN::getCooldown, FTBEConfig.SPAWN::getWarmup);
        this.warpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.WARP::getCooldown, FTBEConfig.WARP::getWarmup);
        this.homeTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.HOME::getCooldown, FTBEConfig.HOME::getWarmup);
        this.tpaTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.TPA::getCooldown, FTBEConfig.TPA::getWarmup);
        this.rtpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.RTP::getCooldown, FTBEConfig.RTP::getWarmup);
        this.teleportHistory = new LinkedList();
    }

    public static void cleanupKitCooldowns(String kitName) {
        MAP.values().forEach(data -> data.setLastKitUseTime(kitName, 0L));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        if (muted != this.muted) {
            this.muted = muted;
            this.markDirty();
        }
    }

    public boolean canFly() {
        return this.canFly;
    }

    public void setCanFly(boolean canFly) {
        if (canFly != this.canFly) {
            this.canFly = canFly;
            this.markDirty();
        }
    }

    public boolean isGod() {
        return this.god;
    }

    public void setGod(boolean god) {
        if (god != this.god) {
            this.god = god;
            this.markDirty();
        }
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        if (!nick.equals(this.nick)) {
            this.nick = nick;
            this.markDirty();
        }
    }

    public TeleportPos getLastSeenPos() {
        return this.lastSeenPos;
    }

    public void setLastSeenPos(TeleportPos lastSeenPos) {
        this.lastSeenPos = lastSeenPos;
        this.markDirty();
    }

    public RecordingStatus getRecording() {
        return this.recording;
    }

    public void setRecording(RecordingStatus recording) {
        if (recording != this.recording) {
            this.recording = recording;
            this.markDirty();
        }
    }

    public SavedTeleportManager.HomeManager homeManager() {
        return this.homes;
    }

    public static Optional<FTBEPlayerData> getOrCreate(@Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null) {
            return Optional.empty();
        }
        return Optional.of(MAP.computeIfAbsent(profile.getId(), k -> {
            String profileName = profile.getName() != null && !profile.getName().isEmpty() ? profile.getName() : "Unknown";
            return new FTBEPlayerData(profile.getId(), profileName);
        }));
    }

    public static Optional<FTBEPlayerData> getOrCreate(Player player) {
        return player == null || PlayerHooks.isFake((Player)player) ? Optional.empty() : FTBEPlayerData.getOrCreate(player.m_36316_());
    }

    public static boolean playerExists(UUID playerId) {
        return MAP.containsKey(playerId);
    }

    public static void addTeleportHistory(ServerPlayer player, ResourceKey<Level> dimension, BlockPos pos) {
        FTBEPlayerData.getOrCreate((Player)player).ifPresent(data -> data.addTeleportHistory(player, new TeleportPos(dimension, pos)));
    }

    public static void addTeleportHistory(ServerPlayer player) {
        FTBEPlayerData.addTeleportHistory(player, (ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20183_());
    }

    public static void clear() {
        MAP.clear();
    }

    public static void saveAll() {
        MAP.values().forEach(FTBEPlayerData::saveIfChanged);
    }

    public static void sendPlayerTabs(ServerPlayer serverPlayer) {
        MAP.values().forEach(d -> d.sendTabName(serverPlayer));
    }

    public static void forEachPlayer(Consumer<FTBEPlayerData> consumer) {
        MAP.values().forEach(consumer);
    }

    public void markDirty() {
        this.needSave = true;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.m_128379_("muted", this.muted);
        nbt.m_128379_("fly", this.canFly);
        nbt.m_128379_("god", this.god);
        nbt.m_128359_("nick", this.nick);
        nbt.m_128365_("last_seen", (Tag)this.lastSeenPos.write());
        nbt.m_128359_("recording", this.recording.getId());
        ListTag tph = new ListTag();
        for (TeleportPos pos : this.teleportHistory) {
            tph.add((Object)pos.write());
        }
        nbt.m_128365_("teleport_history", (Tag)tph);
        nbt.m_128365_("homes", (Tag)this.homes.writeNBT());
        nbt.m_128365_("kit_use_times", (Tag)Util.m_137469_((Object)new CompoundTag(), tag -> this.kitUseTimes.forEach((arg_0, arg_1) -> ((CompoundTag)tag).m_128356_(arg_0, arg_1))));
        return nbt;
    }

    public void read(CompoundTag tag) {
        this.muted = tag.m_128471_("muted");
        this.canFly = tag.m_128471_("fly");
        this.god = tag.m_128471_("god");
        this.nick = tag.m_128461_("nick");
        this.recording = RecordingStatus.NAME_MAP.map.getOrDefault(tag.m_128461_("recording"), RecordingStatus.NONE);
        this.lastSeenPos = tag.m_128441_("last_seen") ? new TeleportPos(tag.m_128469_("last_seen")) : null;
        this.teleportHistory.clear();
        ListTag th = tag.m_128437_("teleport_history", 10);
        for (int i = 0; i < th.size(); ++i) {
            this.teleportHistory.add(new TeleportPos(th.m_128728_(i)));
        }
        this.kitUseTimes.clear();
        CompoundTag kitTag = tag.m_128469_("kit_use_times");
        for (String name : kitTag.m_128431_()) {
            this.kitUseTimes.put(name, kitTag.m_128454_(name));
        }
        this.homes.readNBT(tag.m_128469_("homes"));
    }

    public void addTeleportHistory(ServerPlayer player, TeleportPos pos) {
        this.teleportHistory.add(pos);
        while (this.teleportHistory.size() > FTBEConfig.MAX_BACK.get(player)) {
            this.teleportHistory.removeFirst();
        }
        this.markDirty();
    }

    public void popTeleportHistory() {
        if (!this.teleportHistory.isEmpty()) {
            this.teleportHistory.removeLast();
            this.markDirty();
        } else {
            FTBEssentials.LOGGER.warn("attempted to pop empty back history for {}", (Object)this.uuid);
        }
    }

    public void load() {
        SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(String.valueOf(this.uuid) + ".snbt"));
        if (tag != null) {
            this.read((CompoundTag)tag);
        }
    }

    public void saveIfChanged() {
        if (this.needSave && SNBT.write((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(String.valueOf(this.uuid) + ".snbt"), (CompoundTag)this.write())) {
            this.needSave = false;
        }
    }

    public void sendTabName(MinecraftServer server) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendToAll(server);
    }

    public void sendTabName(ServerPlayer to) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendTo(to);
    }

    public long getLastKitUseTime(String kitName) {
        return this.kitUseTimes.getOrDefault(kitName, 0L);
    }

    public void setLastKitUseTime(String kitName, long when) {
        if (when == 0L) {
            if (this.kitUseTimes.remove(kitName) != null) {
                this.markDirty();
            }
        } else {
            this.kitUseTimes.put(kitName, when);
            this.markDirty();
        }
    }

    public static enum RecordingStatus {
        NONE("none", Style.f_131099_),
        RECORDING("recording", FTBEssentials.RECORDING_STYLE),
        STREAMING("streaming", FTBEssentials.STREAMING_STYLE);

        public static final NameMap<RecordingStatus> NAME_MAP;
        private final String id;
        private final Style style;

        private RecordingStatus(String id, Style style) {
            this.id = id;
            this.style = style;
        }

        public String getId() {
            return this.id;
        }

        public Style getStyle() {
            return this.style;
        }

        static {
            NAME_MAP = NameMap.of((Object)((Object)NONE), (Object[])RecordingStatus.values()).create();
        }
    }
}

