/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.commands.CommandFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class OrechidRecipe
implements vazkii.botania.api.recipe.OrechidRecipe {
    private final ResourceLocation id;
    private final StateIngredient input;
    private final StateIngredient output;
    private final int weight;
    private final CommandFunction.CacheableFunction successFunction;

    public OrechidRecipe(ResourceLocation id, StateIngredient input, StateIngredient output, int weight, CommandFunction.CacheableFunction successFunction) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.weight = weight;
        this.successFunction = successFunction;
    }

    @Override
    public StateIngredient getInput() {
        return this.input;
    }

    @Override
    public StateIngredient getOutput() {
        return this.output;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public CommandFunction.CacheableFunction getSuccessFunction() {
        return this.successFunction;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeType<? extends OrechidRecipe> m_6671_() {
        return BotaniaRecipeTypes.ORECHID_TYPE;
    }

    public RecipeSerializer<?> m_7707_() {
        return BotaniaRecipeTypes.ORECHID_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<OrechidRecipe> {
        public OrechidRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            StateIngredient input = StateIngredientHelper.tryDeserialize(GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            if (input == null) {
                throw new JsonSyntaxException("Unknown input: " + String.valueOf(GsonHelper.m_13930_((JsonObject)json, (String)"input")));
            }
            StateIngredient output = StateIngredientHelper.tryDeserialize(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            if (output == null) {
                throw new JsonSyntaxException("Unknown output: " + String.valueOf(GsonHelper.m_13930_((JsonObject)json, (String)"output")));
            }
            int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
            String functionIdString = GsonHelper.m_13851_((JsonObject)json, (String)"success_function", null);
            ResourceLocation functionId = functionIdString == null ? null : new ResourceLocation(functionIdString);
            CommandFunction.CacheableFunction function = functionId == null ? CommandFunction.CacheableFunction.f_77990_ : new CommandFunction.CacheableFunction(functionId);
            return new OrechidRecipe(recipeId, input, output, weight, function);
        }

        public OrechidRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            StateIngredient input = StateIngredientHelper.read(buffer);
            StateIngredient output = StateIngredientHelper.read(buffer);
            int weight = buffer.m_130242_();
            return new OrechidRecipe(recipeId, input, output, weight, CommandFunction.CacheableFunction.f_77990_);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull OrechidRecipe recipe) {
            recipe.getInput().write(buffer);
            recipe.getOutput().write(buffer);
            buffer.m_130130_(recipe.getWeight());
        }
    }
}

