/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.ISpeedNotifiable;
import com.railwayteam.railways.content.smokestack.SmokeType;
import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticle;
import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticleData;
import com.railwayteam.railways.mixin.client.AccessorLevelRenderer;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SmokeStackMovementBehaviour
implements MovementBehaviour {
    private final boolean renderAsNormalBlockEntity;
    private final boolean createsSmoke;
    private final boolean spawnExtraSmoke;

    public SmokeStackMovementBehaviour() {
        this(true);
    }

    public SmokeStackMovementBehaviour(boolean spawnExtraSmoke) {
        this(false, true, spawnExtraSmoke);
    }

    public SmokeStackMovementBehaviour(boolean renderAsNormalBlockEntity, boolean createsSmoke, boolean spawnExtraSmoke) {
        this.renderAsNormalBlockEntity = renderAsNormalBlockEntity;
        this.createsSmoke = createsSmoke;
        this.spawnExtraSmoke = spawnExtraSmoke;
    }

    public boolean isRenderAsNormalBlockEntity() {
        return this.renderAsNormalBlockEntity;
    }

    public void startMoving(MovementContext context) {
        super.startMoving(context);
        context.temporaryData = new TemporaryData(context);
    }

    public void onSpeedChanged(MovementContext context, Vec3 oldMotion, Vec3 motion) {
        super.onSpeedChanged(context, oldMotion, motion);
        boolean isStopped = Mth.m_14082_((double)motion.m_82556_(), (double)0.0);
        Object object = context.temporaryData;
        if (object instanceof TemporaryData) {
            TemporaryData temporaryData = (TemporaryData)object;
            if (isStopped != temporaryData.wasStopped) {
                if (!isStopped) {
                    temporaryData.startMoving(context);
                }
                temporaryData.wasStopped = isStopped;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        Object object = context.temporaryData;
        if (!(object instanceof TemporaryData)) {
            return;
        }
        TemporaryData temporaryData = (TemporaryData)object;
        temporaryData.moveParticles(context);
    }

    public void tick(MovementContext context) {
        int i;
        TemporaryData data;
        if (context.world == null || !context.world.f_46443_ || context.position == null || !((Boolean)context.state.m_61143_((Property)SmokeStackBlock.ENABLED)).booleanValue()) {
            return;
        }
        Object object = context.temporaryData;
        if (object instanceof TemporaryData) {
            TemporaryData tempDat;
            data = tempDat = (TemporaryData)object;
        } else {
            data = new TemporaryData(context);
            context.temporaryData = data;
        }
        data.moveParticles(context);
        LerpedFloat chanceChaser = data.chanceChaser;
        LerpedFloat speedMultiplierChaser = data.speedMultiplierChaser;
        long movementTicks = data.getMovementTicks(context);
        float chanceModifierTarget = (Math.abs(context.getAnimationSpeed()) + 100.0f) / 800.0f;
        chanceModifierTarget *= chanceModifierTarget;
        Object v = context.contraption.presentBlockEntities.get(context.localPos);
        if (v instanceof ISpeedNotifiable) {
            ISpeedNotifiable notifiable = (ISpeedNotifiable)v;
            notifiable.notifySpeed(chanceModifierTarget);
        }
        if (!this.createsSmoke) {
            return;
        }
        chanceChaser.chase((double)chanceModifierTarget, chanceModifierTarget > chanceChaser.getChaseTarget() ? 0.1 : 0.01, LerpedFloat.Chaser.LINEAR);
        chanceChaser.tickChaser();
        float chanceModifier = chanceChaser.getValue() * (this.spawnExtraSmoke ? 1.0f : 0.5f);
        int maxModifier = 0;
        int minModifier = 0;
        if (chanceModifier > 2.0f) {
            maxModifier += (int)((double)chanceModifier + 0.5) - 1;
            minModifier = chanceModifier > 3.0f ? (int)((double)chanceModifier + 0.5) - 2 : 1;
        } else if (chanceModifier > 1.0f) {
            ++maxModifier;
        }
        SmokeType smokeType = (SmokeType)((Object)CRConfigs.client().smokeType.get());
        if (smokeType == SmokeType.CARTOON) {
            maxModifier += 2;
        } else {
            minModifier += 5;
            maxModifier += 15;
        }
        RandomSource random = context.world.f_46441_;
        SmokeStackBlock.SmokeStackType type = ((SmokeStackBlock)context.state.m_60734_()).type;
        double speedModifierTarget = 5.0 * (0.5 + (double)maxModifier);
        speedMultiplierChaser.chase(speedModifierTarget, 0.4, LerpedFloat.Chaser.LINEAR);
        speedMultiplierChaser.tickChaser();
        DyeColor color = null;
        boolean isSoul = false;
        if (context.blockEntityData != null) {
            if (context.blockEntityData.m_128425_("color", 3)) {
                int colorOrdinal = context.blockEntityData.m_128451_("color");
                color = DyeColor.m_41053_((int)colorOrdinal);
            }
            isSoul = context.blockEntityData.m_128471_("isSoul");
        }
        if (smokeType == SmokeType.CARTOON && color != DyeColor.WHITE) {
            if (movementTicks == 0L) {
                ChimneyPushParticleData<?> particleType = color != null ? ChimneyPushParticleData.create(random.m_188499_(), false, color) : ChimneyPushParticleData.create(random.m_188499_(), false);
                Vec3 pos = context.position.m_82492_(0.5, 0.0, 0.5).m_82549_(type.getParticleSpawnOffset());
                data.addAndTrackParticle(particleType, true, pos.f_82479_, pos.f_82480_, pos.f_82481_, context.motion.f_82479_, context.motion.f_82480_, context.motion.f_82481_);
            } else if (movementTicks == 8L) {
                for (i = 0; i < 3; ++i) {
                    SmokeStackBlock.makeParticles(context.world, context.position.m_82492_(0.5, 0.0, 0.5).m_82492_((random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5), random.m_188499_(), true, type.getParticleSpawnOffset(), type.getParticleSpawnDelta(), speedMultiplierChaser.getValue(), false, color, true, isSoul);
                }
            } else {
                if (movementTicks < 15L) {
                    return;
                }
                movementTicks -= 15L;
            }
        }
        if ((smokeType != SmokeType.CARTOON || color != DyeColor.WHITE) && (double)random.m_188501_() < type.particleSpawnChance * (double)chanceModifier * (Double)CRConfigs.client().smokePercentage.get()) {
            for (i = 0; i < random.m_188503_(type.maxParticles + maxModifier - (type.minParticles + minModifier)) + type.minParticles + minModifier; ++i) {
                boolean small;
                boolean bl = small = movementTicks < 50L;
                if (!small) {
                    double smallChance = 0.33;
                    if (movementTicks < 100L) {
                        smallChance = Mth.m_14139_((double)((float)(movementTicks - 50L) / 50.0f), (double)1.0, (double)0.33);
                    }
                    double speedFactor = 0.3 + 0.7 * (double)Math.max(0.0f, Math.min(chanceModifier / 2.0f, 1.0f));
                    small = random.m_188500_() * speedFactor < smallChance;
                }
                SmokeStackBlock.makeParticles(context.world, context.position.m_82492_(0.5, 0.0, 0.5).m_82492_((random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5), random.m_188499_(), true, type.getParticleSpawnOffset(), type.getParticleSpawnDelta(), speedMultiplierChaser.getValue(), false, color, small, isSoul);
            }
        }
        if (smokeType != SmokeType.CARTOON) {
            return;
        }
        if (!(context.contraption instanceof CarriageContraption) && !(context.contraption instanceof TranslatingContraption)) {
            return;
        }
        if ((double)chanceModifier >= 0.25 && ((Boolean)CRConfigs.client().spawnFasterPuffs.get()).booleanValue()) {
            int littleSmokeInterval = (int)Mth.m_14008_((double)(21.25 / (double)chanceModifier), (double)15.0, (double)85.0);
            long time = context.world.m_46467_() - (long)data.nextSmallPuffOffset;
            if (time % (long)littleSmokeInterval >= 0L && time % (long)littleSmokeInterval <= 2L) {
                for (int i2 = 0; i2 < random.m_188503_(type.maxParticles + maxModifier - (type.minParticles + minModifier)) + type.minParticles + minModifier; ++i2) {
                    boolean small = true;
                    SmokeStackBlock.makeParticles(context.world, context.position.m_82492_(0.5, 0.0, 0.5).m_82492_((random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5), random.m_188499_(), true, type.getParticleSpawnOffset(), type.getParticleSpawnDelta(), -1.0, false, color, small, isSoul);
                }
            }
            if (time % (long)littleSmokeInterval == 3L) {
                data.nextSmallPuffOffset = random.m_216332_(0, littleSmokeInterval / 2);
            }
        }
        int steamInterval = (int)Mth.m_14008_((double)(6.25 / (double)chanceModifier), (double)13.0, (double)50.0);
        if ((((Boolean)CRConfigs.client().spawnSteam.get()).booleanValue() || color == DyeColor.WHITE) && context.world.m_46467_() % (long)steamInterval >= 0L && context.world.m_46467_() % (long)steamInterval <= 3L) {
            DyeColor dyeColor = color = isSoul ? DyeColor.RED : DyeColor.WHITE;
            if (data.getPushParticles().isEmpty()) {
                ChimneyPushParticleData<?> particleType = ChimneyPushParticleData.create(false, false, color);
                Vec3 pos = context.position.m_82492_(0.5, 0.0, 0.5).m_82549_(type.getParticleSpawnOffset());
                data.addAndTrackParticle(particleType, true, pos.f_82479_, pos.f_82480_, pos.f_82481_, context.motion.f_82479_, context.motion.f_82480_, context.motion.f_82481_);
            }
            for (int i3 = 0; i3 < random.m_188503_(type.maxParticles + maxModifier - (type.minParticles + minModifier)) + type.minParticles + minModifier; ++i3) {
                boolean small;
                boolean bl = small = movementTicks < 50L;
                if (!small) {
                    double smallChance = 0.33;
                    if (movementTicks < 100L) {
                        smallChance = Mth.m_14139_((double)((float)(movementTicks - 50L) / 50.0f), (double)1.0, (double)0.33);
                    }
                    double speedFactor = 0.3 + 0.7 * (double)Math.max(0.0f, Math.min(chanceModifier / 2.0f, 1.0f));
                    small = random.m_188500_() * speedFactor < smallChance;
                }
                SmokeStackBlock.makeParticles(context.world, context.position.m_82492_(0.5, 0.0, 0.5).m_82492_((random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5), random.m_188499_(), true, type.getParticleSpawnOffset(), type.getParticleSpawnDelta(), speedMultiplierChaser.getValue(), false, color, small, false);
            }
        }
    }

    private static /* synthetic */ ShaderInstance lambda$renderInContraption$0(ShaderInstance oldShader) {
        return oldShader;
    }

    private static class TemporaryData {
        @NotNull
        final LerpedFloat chanceChaser = LerpedFloat.linear();
        @NotNull
        final LerpedFloat speedMultiplierChaser = LerpedFloat.linear();
        long movementStartTick = 0L;
        boolean wasStopped = true;
        int nextSmallPuffOffset = 0;
        @OnlyIn(value=Dist.CLIENT)
        private List<ChimneyPushParticle> pushParticles;

        public TemporaryData(MovementContext context) {
            this.startMoving(context);
        }

        public void startMoving(MovementContext context) {
            this.movementStartTick = context.world.m_46467_();
        }

        public long getMovementTicks(MovementContext context) {
            return context.world.m_46467_() - this.movementStartTick;
        }

        @OnlyIn(value=Dist.CLIENT)
        void moveParticles(MovementContext context) {
            if (this.pushParticles == null) {
                return;
            }
            SmokeStackBlock.SmokeStackType type = ((SmokeStackBlock)context.state.m_60734_()).type;
            Vec3 pos = context.position.m_82492_(0.5, 0.0, 0.5).m_82549_(type.getParticleSpawnOffset());
            Iterator<ChimneyPushParticle> iterator = this.pushParticles.iterator();
            while (iterator.hasNext()) {
                ChimneyPushParticle particle = iterator.next();
                particle.m_107264_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                particle.setOldPos();
                if (particle.m_107276_()) continue;
                iterator.remove();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        List<ChimneyPushParticle> getPushParticles() {
            return this.pushParticles == null ? Collections.emptyList() : this.pushParticles;
        }

        @OnlyIn(value=Dist.CLIENT)
        void addAndTrackParticle(ChimneyPushParticleData<?> particleType, boolean force, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Particle added;
            if (this.pushParticles == null) {
                this.pushParticles = new ArrayList<ChimneyPushParticle>();
            }
            if ((added = ((AccessorLevelRenderer)Minecraft.m_91087_().f_91060_).callAddParticleInternal(particleType, force, true, x, y, z, xSpeed, ySpeed, zSpeed)) instanceof ChimneyPushParticle) {
                ChimneyPushParticle chimneyPushParticle = (ChimneyPushParticle)added;
                this.pushParticles.add(chimneyPushParticle);
            }
        }
    }
}

