/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.PowerTile;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.SecureClassLoader;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.Nullable;

public final class TraceQuarryWork {
    public static final boolean enabled;
    private static final LoggerContext CONTEXT;
    private static final Logger LOGGER;
    private static final Marker WARNING_MARKER;
    private static final Marker MARKER_START_WORK;
    private static final Marker MARKER_CHANGE_TARGET;
    private static final Marker MARKER_CHANGE_STATE;
    private static final Marker MARKER_PROGRESS;
    private static final Marker MARKER_CAN_BREAK_CHECK;
    private static final Marker MARKER_BLOCK_REMOVE_FAILED;
    private static final Marker MARKER_BLOCK_REMOVE_SUCCEED;
    private static final Marker MARKER_UNEXPECTED;
    private static final Marker MARKER_FINISH_WORK;
    private static final Marker MARKER_CONVERT_ITEM;
    private static final Marker MARKER_TRANSFER_ITEM;
    private static final Marker MARKER_TRANSFER_FLUID;
    private static final Marker MARKER_NO_DROPS;
    private static final Cache<String, String> knownKeys;
    private static final Marker MARKER_INITIAL_LOG;

    public static void startWork(PowerTile tile, BlockPos pos, int energyInMachine) {
        LOGGER.info(MARKER_START_WORK, "{} Started work with {} FE", (Object)TraceQuarryWork.header(tile, pos), (Object)energyInMachine);
    }

    public static void changeTarget(PowerTile tile, BlockPos pos, String state, String target) {
        LOGGER.debug(MARKER_CHANGE_TARGET, "{} In {} to {}", (Object)TraceQuarryWork.header(tile, pos), (Object)state, (Object)target);
    }

    public static void changeState(PowerTile tile, BlockPos pos, String oldState, String newState) {
        LOGGER.debug(MARKER_CHANGE_STATE, "{} From {} to {}", (Object)TraceQuarryWork.header(tile, pos), (Object)oldState, (Object)newState);
    }

    public static void progress(PowerTile tile, BlockPos pos, BlockPos targetPos, String reason) {
        LOGGER.debug(MARKER_PROGRESS, "{} ({},{},{}) {}", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)reason);
    }

    public static void canBreakCheck(PowerTile tile, BlockPos pos, BlockPos targetPos, BlockState state, String detail) {
        LOGGER.info(MARKER_CAN_BREAK_CHECK, "{} ({},{},{}) {} State({})", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)detail, (Object)state);
    }

    public static void blockRemoveFailed(PowerTile tile, BlockPos pos, BlockPos targetPos, BlockState state, BreakResult breakResult, Object ... additional) {
        if (breakResult == BreakResult.NOT_ENOUGH_ENERGY && LOGGER == QuarryPlus.LOGGER) {
            String key = TraceQuarryWork.header(tile, pos);
            if (knownKeys.getIfPresent((Object)key) == null) {
                knownKeys.put((Object)key, (Object)key);
                LOGGER.info(MARKER_BLOCK_REMOVE_FAILED, "{} ({},{},{}) {} {} {}", (Object)key, (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)breakResult, (Object)state, (Object)additional);
            }
            return;
        }
        LOGGER.info(MARKER_BLOCK_REMOVE_FAILED, "{} ({},{},{}) {} {} {}", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)breakResult, (Object)state, (Object)additional);
    }

    public static void blockRemoveSucceed(PowerTile tile, BlockPos pos, BlockPos targetPos, BlockState state, List<ItemStack> drops, int exp, long consumedEnergy) {
        LOGGER.debug(MARKER_BLOCK_REMOVE_SUCCEED, "{} ({},{},{}) {} FE {} EXP={} ({})", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)(consumedEnergy / 1000000000L), (Object)state, (Object)exp, (Object)drops.stream().map(s -> "%dx %s".formatted(s.m_41613_(), ForgeRegistries.ITEMS.getKey((Object)s.m_41720_()))).collect(Collectors.joining(",")));
    }

    public static void blockRemoveSucceed(PowerTile tile, BlockPos pos, BlockPos targetPos, List<BlockState> state, Map<ItemKey, Long> drops, int exp, long consumedEnergy) {
        Map stateCount = state.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        LOGGER.debug(MARKER_BLOCK_REMOVE_SUCCEED, "{} ({},{},{}) {} FE {} EXP={} ({})", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)(consumedEnergy / 1000000000L), stateCount, (Object)exp, (Object)drops.entrySet().stream().map(s -> "%dx %s".formatted(s.getValue(), ((ItemKey)s.getKey()).getId())).collect(Collectors.joining(",")));
    }

    public static void unexpected(PowerTile tile, BlockPos pos, String reason) {
        LOGGER.warn(MARKER_UNEXPECTED, "{} {}", (Object)TraceQuarryWork.header(tile, pos), (Object)reason);
    }

    public static void finishWork(PowerTile tile, BlockPos pos, int energyInMachine) {
        LOGGER.info(MARKER_FINISH_WORK, "{} Finished work with {} FE", (Object)TraceQuarryWork.header(tile, pos), (Object)energyInMachine);
    }

    public static void convertItem(ItemKey before, ItemKey after) {
        LOGGER.debug(MARKER_CONVERT_ITEM, "Convert {} to {}", (Object)before, (Object)after);
    }

    public static void transferItem(@Nullable BlockEntity from, @Nullable IItemHandler dest, ItemKey itemKey, int count) {
        String header = from != null ? TraceQuarryWork.header(from, from.m_58899_()) : "ItemHandler Extraction";
        LOGGER.debug(MARKER_TRANSFER_ITEM, "{} Transfer {}x {} to {}", (Object)header, (Object)count, (Object)itemKey, (Object)dest);
    }

    public static void transferFluid(@Nullable BlockEntity from, @Nullable IFluidHandler dest, FluidKey fluidKey, int amount) {
        String header = from != null ? TraceQuarryWork.header(from, from.m_58899_()) : "FluidHandler Extraction";
        LOGGER.debug(MARKER_TRANSFER_FLUID, "{} Transfer {}mB of {} to {}", (Object)header, (Object)amount, (Object)fluidKey, (Object)dest);
    }

    public static void noDrops(BlockState state, BlockPos pos, ItemStack tool) {
        LOGGER.debug(MARKER_NO_DROPS, "{} at ({},{},{}) has no drops with {}", (Object)state, (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_(), (Object)tool);
    }

    private static String header(BlockEntity tile, BlockPos pos) {
        return "[%s(%d,%d,%d)]".formatted(tile.getClass().getSimpleName(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void logOnceIn10Minutes(String key, Supplier<String> message, @Nullable Supplier<? extends Throwable> error) {
        if (knownKeys.getIfPresent((Object)key) == null) {
            knownKeys.put((Object)key, (Object)key);
            String msg = "[" + key + "] " + message.get();
            if (error == null) {
                QuarryPlus.LOGGER.warn(msg);
                LOGGER.warn(WARNING_MARKER, msg);
            } else {
                QuarryPlus.LOGGER.error(msg, error.get());
                LOGGER.error(WARNING_MARKER, msg, error.get());
            }
        }
    }

    public static void initialLog(MinecraftServer server) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Map<String, Map<String, Object>> config = Map.of("common", QuarryPlus.config.getAll(), "server", QuarryPlus.serverConfig.getAll());
        LOGGER.warn(MARKER_INITIAL_LOG, "Config in '{}'{}{}", (Object)server.m_129916_(), (Object)System.lineSeparator(), (Object)gson.toJson(config));
    }

    static {
        Logger t;
        enabled = (Boolean)QuarryPlus.config.common.logAllQuarryWork.get();
        URI resource = URI.create(Objects.requireNonNull(TraceQuarryWork.class.getResource("/quarry-log4j2.xml")).toString());
        CONTEXT = Configurator.initialize((String)"quarryplus-config", (ClassLoader)new DummyLoader(), (URI)resource);
        if (CONTEXT != null) {
            org.apache.logging.log4j.core.Logger l = CONTEXT.getLogger("TQW");
            if (!enabled) {
                l.setLevel(Level.WARN);
            }
            t = l;
            QuarryPlus.LOGGER.info("Successfully initialized log context for QuarryPlus. resource: '{}'", (Object)resource);
        } else {
            t = QuarryPlus.LOGGER;
            try (InputStreamReader stream = new InputStreamReader(Objects.requireNonNull(TraceQuarryWork.class.getResourceAsStream("/quarry-log4j2.xml")));
                 BufferedReader reader = new BufferedReader(stream);){
                String text = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                QuarryPlus.LOGGER.error("Log context for QuarryPlus is not initialized. Quarry work tracing will not be available. resource: '{}', log-config: '{}'", (Object)resource, (Object)text);
            }
            catch (Exception e) {
                QuarryPlus.LOGGER.error("Log context for QuarryPlus is not initialized. Quarry work tracing will not be available. Failed to read quarry-log4j2.xml", (Throwable)e);
            }
        }
        LOGGER = t;
        WARNING_MARKER = MarkerManager.getMarker((String)"QUARRY_WARNING");
        MARKER_START_WORK = MarkerManager.getMarker((String)"startWork");
        MARKER_CHANGE_TARGET = MarkerManager.getMarker((String)"changeTarget");
        MARKER_CHANGE_STATE = MarkerManager.getMarker((String)"changeState");
        MARKER_PROGRESS = MarkerManager.getMarker((String)"progress");
        MARKER_CAN_BREAK_CHECK = MarkerManager.getMarker((String)"canBreakCheck");
        MARKER_BLOCK_REMOVE_FAILED = MarkerManager.getMarker((String)"blockRemoveFailed");
        MARKER_BLOCK_REMOVE_SUCCEED = MarkerManager.getMarker((String)"removeSuccess");
        MARKER_UNEXPECTED = MarkerManager.getMarker((String)"unexpected");
        MARKER_FINISH_WORK = MarkerManager.getMarker((String)"finishWork");
        MARKER_CONVERT_ITEM = MarkerManager.getMarker((String)"convertItem");
        MARKER_TRANSFER_ITEM = MarkerManager.getMarker((String)"transferItem");
        MARKER_TRANSFER_FLUID = MarkerManager.getMarker((String)"transferFluid");
        MARKER_NO_DROPS = MarkerManager.getMarker((String)"noDrops");
        knownKeys = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).build();
        MARKER_INITIAL_LOG = MarkerManager.getMarker((String)"initialLog");
    }

    private static class DummyLoader
    extends SecureClassLoader {
        private DummyLoader() {
        }
    }
}

