/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.movement;

import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MovementPluginAction {

    public record SetFallbackBranch(@NotNull ResourceLocation parent, @Nullable ResourceLocation fallback, double priority) implements MovementPluginAction
    {
    }

    public record ChangeDefaultStaminaDelta(@NotNull ResourceLocation id, int defaultStaminaDelta) implements MovementPluginAction
    {
        public ChangeDefaultStaminaDelta(@NotNull ResourceLocation id, int defaultStaminaDelta) {
            Objects.requireNonNull(id, "id == null");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface NewState
    extends MovementPluginAction {
        @NotNull
        public ResourceLocation id();

        public record Synthetic(@NotNull ResourceLocation id) implements NewState
        {
            public Synthetic(@NotNull ResourceLocation id) {
                Objects.requireNonNull(id, "id == null");
            }
        }

        public record Regular(@NotNull ResourceLocation id, int defaultStaminaDelta, @NotNull @NotNull @Unmodifiable Set<@NotNull ResourceLocation> flags) implements NewState
        {
            public Regular(@NotNull ResourceLocation id, int defaultStaminaDelta, @NotNull @Unmodifiable Set<ResourceLocation> flags) {
                Objects.requireNonNull(id, "id == null");
                Objects.requireNonNull(flags, "flags == null");
                for (ResourceLocation flag : flags) {
                    Objects.requireNonNull(flag);
                }
            }
        }
    }
}

