/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.render.StaminaWheelRenderer;

public class InGameStaminaWheelRenderer
extends StaminaWheelRenderer {
    private static final InGameStaminaWheelRenderer instance = new InGameStaminaWheelRenderer();
    private boolean full = true;
    private long fullDuration = 1100L;
    private long prevFullTime;

    public static InGameStaminaWheelRenderer get() {
        return instance;
    }

    @Override
    protected void makeWheel(@NotNull Player player, @NotNull StaminaWheelRenderer.Wheel wheel) {
        Stamina s = Stamina.get(player);
        int maxStamina = s.maxStamina();
        int stamina = Math.min(maxStamina, s.stamina());
        if (stamina >= maxStamina) {
            this.makeFullWheel(wheel, stamina);
            return;
        }
        this.full = false;
        boolean depleted = s.isDepleted();
        Movement movement = Movement.get(player);
        int staminaDelta = movement.getActualStaminaDelta();
        wheel.fill(0, maxStamina, StaminaWheelConstants.EMPTY);
        if (depleted) {
            wheel.fill(0, stamina, StaminaWheelConstants.getBlinkColor(ParagliderUtils.ms(), true));
        } else {
            wheel.fill(0, stamina, StaminaWheelConstants.IDLE);
            if (staminaDelta < 0) {
                wheel.fill(stamina + staminaDelta * 10, stamina, StaminaWheelConstants.getBlinkColor(ParagliderUtils.ms(), false));
            }
        }
    }

    private void makeFullWheel(@NotNull StaminaWheelRenderer.Wheel wheel, int stamina) {
        long timeDiff;
        long time = ParagliderUtils.ms();
        if (!this.full) {
            this.full = true;
            timeDiff = 0L;
            this.fullDuration = 0L;
        } else if (this.fullDuration < 1100L) {
            timeDiff = time - this.prevFullTime;
            this.fullDuration = Math.min(this.fullDuration + timeDiff, 1100L);
        } else {
            return;
        }
        int color = StaminaWheelConstants.getGlowAndFadeColor(timeDiff);
        if (FastColor.ARGB32.m_13655_((int)color) <= 0) {
            return;
        }
        wheel.fill(0, stamina, color);
        this.prevFullTime = time;
    }

    public void reset() {
        this.full = true;
        this.fullDuration = 1100L;
        this.prevFullTime = 0L;
    }
}

