/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.contents.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.FeatureCfg;
import tictim.paraglider.contents.Contents;

public class SpiritOrbLoot
extends LootModifier {
    public static final Codec<SpiritOrbLoot> CODEC = RecordCodecBuilder.create(b -> b.group((App)Codec.INT.fieldOf("count").forGetter(m -> m.count)).and(SpiritOrbLoot.codecStart((RecordCodecBuilder.Instance)b).t1()).apply((Applicative)b, SpiritOrbLoot::new));
    private final int count;

    public SpiritOrbLoot(int count, LootItemCondition ... conditions) {
        super(conditions);
        this.count = count;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (FeatureCfg.get().enableSpiritOrbGens()) {
            generatedLoot.add((Object)new ItemStack((ItemLike)Contents.get().spiritOrb(), this.count));
        }
        return generatedLoot;
    }

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

