/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app;

import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogsList;
import dev.kostromdan.mods.crash_assistant.app.utils.CrashReportsHelper;
import dev.kostromdan.mods.crash_assistant.app.utils.FileUtils;
import dev.kostromdan.mods.crash_assistant.app.utils.HsErrHelper;
import dev.kostromdan.mods.crash_assistant.app.utils.TerminatedProcessesFinder;
import dev.kostromdan.mods.crash_assistant.app.utils.WinEventCleaner;
import dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPU;
import dev.kostromdan.mods.crash_assistant.app.utils.gpu.RendererType;
import dev.kostromdan.mods.crash_assistant.common_config.communication.ProcessSignalIO;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashAssistantApp {
    public static final Logger LOGGER = LogManager.getLogger(CrashAssistantApp.class);
    public static long GUIStartTime = -1L;
    public static boolean GUIStartedLaunching = false;
    public static boolean GUIInitialisationFinished = false;
    public static long parentPID;
    public static long parentStarted;
    public static String parentXms;
    public static String parentXmx;
    public static String systemRAM;
    public static String processor;
    public static boolean crashed_with_report;
    public static String crashAssistantJarName;
    public static String renderer;
    public static boolean gameLaunchedSuccessfully;
    public static boolean joinedWorldSuccessfully;
    public static boolean stopFunctionFired;
    public static boolean closeFunctionFailed;
    public static boolean emergencySaveFired;
    public static long terminatedProcessesLocationEndTime;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> LOGGER.error("Uncaught exception in \"{}\" thread:", (Object)thread.getName(), (Object)throwable));
        LOGGER.info("CrashAssistantApp running: JVM args: {}", Boot.JVM_ARGS);
        LOGGER.info("CrashAssistantApp running: program args: {}", Boot.APP_ARGS);
        LOGGER.info("CrashAssistantApp running from: {}", (Object)Paths.get("", new String[0]).toAbsolutePath().toString());
        LOGGER.info("crashAssistantJarName: {}", (Object)crashAssistantJarName);
        parentPID = -1L;
        parentStarted = -1L;
        for (int i = 0; i < args.length; ++i) {
            if ("-parentPID".equals(args[i]) && i + 1 < args.length) {
                parentPID = Long.parseLong(args[i + 1]);
                LOGGER.info("Parent PID: {}", (Object)parentPID);
                continue;
            }
            if ("-parentStarted".equals(args[i]) && i + 1 < args.length) {
                parentStarted = Long.parseLong(args[i + 1]);
                LOGGER.info("Parent started: {}", (Object)parentStarted);
                continue;
            }
            if ("-parentXms".equals(args[i]) && i + 1 < args.length) {
                parentXms = args[i + 1];
                LOGGER.info("parentXms: {}", (Object)parentXms);
                continue;
            }
            if ("-parentXmx".equals(args[i]) && i + 1 < args.length) {
                parentXmx = args[i + 1];
                LOGGER.info("parentXmx: {}", (Object)parentXmx);
                continue;
            }
            if ("-systemRAM".equals(args[i]) && i + 1 < args.length) {
                systemRAM = args[i + 1];
                LOGGER.info("systemRAM: {}", (Object)systemRAM);
                continue;
            }
            if ("-processor".equals(args[i]) && i + 1 < args.length) {
                processor = new String(Base64.getDecoder().decode(args[i + 1]), StandardCharsets.UTF_8);
                LOGGER.info("processor: {}", (Object)processor);
                continue;
            }
            if ("-platform".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.platform = Enum.valueOf(PlatformHelp.class, args[i + 1]);
                LOGGER.info("Platform: {}", (Object)PlatformHelp.platform);
                continue;
            }
            if ("-loaderJarName".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.loaderJarName = args[i + 1];
                LOGGER.info("loaderJarName: {}", (Object)PlatformHelp.loaderJarName);
                continue;
            }
            if ("-minecraftVersion".equals(args[i]) && i + 1 < args.length) {
                PlatformHelp.minecraftVersion = args[i + 1];
                LOGGER.info("minecraftVersion: {}", (Object)PlatformHelp.minecraftVersion);
                continue;
            }
            if (!"-childProcessesPIDs".equals(args[i]) || i + 1 >= args.length) continue;
            PlatformHelp.childProcessesPIDs = new String(Base64.getDecoder().decode(args[i + 1]), StandardCharsets.UTF_8);
            LOGGER.info("childProcessesPIDs: {}", (Object)PlatformHelp.childProcessesPIDs);
        }
        LOGGER.info("Boot.serialisedGPUs:\n{}", (Object)Boot.serialisedGPUs);
        LOGGER.info("os.name: {}", (Object)PlatformHelp.OS);
        LOGGER.info("Java path: {}", (Object)JavaBinaryLocator.getJavaBinary());
        LOGGER.info("Java version: {}", (Object)PlatformHelp.javaVersion);
        String currentProcessData = Objects.toString(parentPID) + "_" + parentStarted;
        Path currentProcessDataPath = Paths.get("local", "crash_assistant", currentProcessData + ".info");
        try {
            Files.write(currentProcessDataPath, (ProcessHelper.getCurrentProcessId() + " : " + ProcessHelper.getCurrentProcessStartTime()).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.removeTmpFiles(Paths.get("local", "crash_assistant"));
        FileUtils.removeOldLogsFolder();
        WinEventCleaner.cleanOldWinEventFiles();
        HsErrHelper.removeHsErrLog(parentPID);
        LOGGER.info("CrashAssistantApp started successfully. Waiting for PID " + parentPID + " to stop.");
        try {
            while (true) {
                if (parentStarted == -1L || parentStarted != ProcessHelper.getProcessStartTime((long)parentPID)) {
                    LOGGER.info("PID \"{}\" is not alive or reused by another process. Minecraft JVM appears to have stopped.", (Object)parentPID);
                    CrashAssistantApp.onMinecraftFinished();
                    return;
                }
                if (CrashAssistantApp.checkLoadingErrorScreen()) {
                    return;
                }
                CrashAssistantApp.checkRendererFile();
                System.gc();
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while awaiting Minecraft stop:", (Throwable)e);
            return;
        }
    }

    private static boolean checkLoadingErrorScreen() {
        if (ProcessSignalIO.exists((String)"loading_error_fml", (long)parentPID)) {
            LOGGER.info("Detected FML error modloading screen.");
            if (CrashAssistantConfig.getBoolean((String)"general.show_on_fml_error_screen")) {
                CrashAssistantApp.onMinecraftFinished();
            }
            return true;
        }
        return false;
    }

    private static void checkRendererFile() {
        if (renderer != null) {
            return;
        }
        if (Boot.serialisedGPUs == null) {
            return;
        }
        Optional potentialRenderer = ProcessSignalIO.get((String)"renderer", (long)parentPID);
        if (potentialRenderer.isPresent()) {
            try {
                renderer = (String)potentialRenderer.get();
                String normalizedRenderer = CrashAssistantApp.removeSpacesAndLowerCase(renderer);
                LOGGER.info("Minecraft is running on renderer:\n{}", (Object)renderer);
                if (Boot.serialisedGPUs != null) {
                    List<GPU> gpus = GPU.deserializeGPUs(Boot.serialisedGPUs);
                    ArrayList<String> dedicatedGpus = new ArrayList<String>();
                    Optional<Object> foundGPU = Optional.empty();
                    for (GPU gpu : gpus) {
                        String normalizedGpuName;
                        if (gpu.getType() == RendererType.DEDICATED) {
                            dedicatedGpus.add(gpu.getName());
                        }
                        if (!(normalizedGpuName = CrashAssistantApp.removeSpacesAndLowerCase(gpu.getName())).contains(normalizedRenderer) && !normalizedRenderer.contains(normalizedGpuName)) continue;
                        foundGPU = Optional.of(gpu);
                    }
                    if (foundGPU.isPresent() && ((GPU)foundGPU.get()).getType() == RendererType.INTEGRATED && !dedicatedGpus.isEmpty()) {
                        LOGGER.warn("Detected Minecraft running on integrated GPU:\n{},\nwhile one or more dedicated exists:\n{}", (Object)((GPU)foundGPU.get()).getName(), (Object)String.join((CharSequence)"\n", dedicatedGpus));
                        if (Objects.equals(CrashAssistantLocalConfig.get((String)"integrated_gpu.dont_show_again"), true)) {
                            LOGGER.warn("integrated_gpu.dont_show_again is true. Prevented GUI warn.");
                            return;
                        }
                        try {
                            Class<?> clazz = Class.forName("dev.kostromdan.mods.crash_assistant.app.gui.IntegratedGPUWarning");
                            Method method = clazz.getMethod("showIfNotDisabled", String.class, List.class);
                            method.invoke(null, ((GPU)foundGPU.get()).getName(), dedicatedGpus);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception while showing IntegratedGPUWarning:", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while analysis of current GPUs:", (Throwable)e);
                renderer = "UNDEFINED";
            }
        }
    }

    private static String removeSpacesAndLowerCase(String s) {
        return s.toLowerCase().replace(" ", "");
    }

    private static void onMinecraftFinished() {
        String userHome;
        HashSet<Path> newCrashReports;
        GUIStartTime = Instant.now().toEpochMilli();
        new Thread(LanguageProvider::updateLang).start();
        boolean crashed = false;
        LogsList.addIfExistsAndModified(new Log(LogType.LOG, Paths.get("logs", "latest.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.DEBUG_LOG, Paths.get("logs", "debug.log")));
        Optional<Path> hsErrLog = HsErrHelper.locateHsErrLog(parentPID);
        if (hsErrLog.isPresent()) {
            crashed = true;
            crashed_with_report = true;
            LogsList.addIfExistsAndModified(new Log(LogType.HS_ERR, hsErrLog.get()));
        }
        if (!(newCrashReports = CrashReportsHelper.getRelevantFiles(Paths.get("crash-reports", new String[0]), path -> true)).isEmpty()) {
            crashed = true;
            crashed_with_report = true;
            for (Path path2 : newCrashReports) {
                LogsList.addIfExistsAndModified(new Log(LogType.CRASH_REPORT, path2));
            }
        }
        HashSet<Path> disconnectsClient = CrashReportsHelper.getRelevantFiles(Paths.get("minecraft", "debug"), path -> path.startsWith("disconnect-") && path.endsWith("-client.txt"));
        for (Path path3 : disconnectsClient) {
            LogsList.addIfExistsAndModified(new Log(LogType.DISCONNECT_CLIENT, path3));
        }
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "MinecraftLauncher: launcher_log.txt", Paths.get("launcher_log.txt", new String[0])));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("logs", "launcher_log.txt")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "CurseForge: launcher_log.txt", Paths.get("../../Install", "launcher_log.txt")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../logs", "ftb-app-electron.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../logs", "PrismLauncher-0.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "GDLauncher: main.log", Paths.get("../../../../", "main.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../", "MultiMC-0.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../../", "PolyMC-0.log")));
        FileUtils.getModifiedFiles(Paths.get("../../launcher_logs", new String[0]), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
        String string = System.getenv("APPDATA");
        LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get("../../logs", "atlauncher.log")));
        if (string != null) {
            LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, Paths.get(string, "AtLauncher", "logs", "atlauncher.log")));
            FileUtils.getModifiedFiles(Paths.get(string, ".tlauncher", "logs", "tlauncher"), ".log").forEach(path -> LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, (Path)path)));
        }
        if ((userHome = System.getProperty("user.home")) != null && !LogsList.isLauncherLogExist()) {
            LogsList.addIfExistsAndModified(new Log(LogType.LAUNCHER_LOG, "CurseForge: launcher_log.txt", Paths.get(userHome, "Library", "Application Support", "minecraft", "launcher_log.txt")));
        }
        LogsList.addIfExistsAndModified(new Log(LogType.MIXER_LOGGER, Paths.get("logs", "MixerLogger.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.KUBE_JS, "KubeJS: client.log", Paths.get("logs", "kubejs", "client.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.KUBE_JS, "KubeJS: server.log", Paths.get("logs", "kubejs", "server.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.KUBE_JS, "KubeJS: startup.log", Paths.get("logs", "kubejs", "startup.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.CRAFT_TWEAKER, Paths.get("logs", "crafttweaker.log")));
        LogsList.addIfExistsAndModified(new Log(LogType.REI, Paths.get("logs", "rei.log")));
        Path reiIssuesPath = Paths.get("logs", "rei-issues.log");
        try {
            if (reiIssuesPath.toFile().exists() && Files.size(reiIssuesPath) != 0L) {
                LogsList.addIfExistsAndModified(new Log(LogType.REI, reiIssuesPath));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LogsList.addIfExistsAndModified(new Log(LogType.CRASH_ASSISTANT, Paths.get("logs", "crash_assistant", "crash_assistant_app.log")));
        gameLaunchedSuccessfully = ProcessSignalIO.exists((String)"successful_launch", (long)parentPID);
        LOGGER.info("Reached first tick of TitleScreen: {}", (Object)gameLaunchedSuccessfully);
        joinedWorldSuccessfully = ProcessSignalIO.exists((String)"joined_world", (long)parentPID);
        LOGGER.info("Joined world successfully: {}", (Object)joinedWorldSuccessfully);
        stopFunctionFired = ProcessSignalIO.exists((String)"normal_stop", (long)parentPID);
        if (!stopFunctionFired) {
            crashed = true;
        }
        LOGGER.info("stop() function of Minecraft fired: {}", (Object)stopFunctionFired);
        closeFunctionFailed = ProcessSignalIO.exists((String)"close_failed", (long)parentPID);
        if (closeFunctionFailed) {
            crashed = true;
        }
        LOGGER.info("close() function of Minecraft failed: {}", (Object)closeFunctionFailed);
        emergencySaveFired = ProcessSignalIO.exists((String)"emergency_save", (long)parentPID);
        if (emergencySaveFired) {
            crashed = true;
        }
        LOGGER.info("emergencySave() function of Minecraft fired: {}", (Object)emergencySaveFired);
        LOGGER.info("isModpackCreator: {}", (Object)ModListDiff.isModpackCreator());
        LOGGER.info("isHelpLinkDefault: {}", (Object)PlatformHelp.isLinkDefault());
        LOGGER.info("helpLink: {}", (Object)PlatformHelp.getActualHelpLink());
        CrashAssistantApp.startLocatingTerminatedProcesses();
        if (crashed) {
            if (!crashed_with_report) {
                LOGGER.info("Seems like Minecraft crashed without any crash report. Starting Crash Assistant app.");
            } else {
                LOGGER.info("Seems like Minecraft crashed. Starting Crash Assistant app.");
            }
            CrashAssistantApp.onMinecraftCrashed();
        } else {
            LOGGER.info("Seems like Minecraft finished normally. Trying to locate terminated processes and Exiting Crash Assistant app.");
        }
    }

    private static void onMinecraftCrashed() {
        CrashAssistantApp.startApp();
    }

    public static void startApp() {
        GUIStartedLaunching = true;
        try {
            Class<?> clazz = Class.forName("dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Exception while starting gui:", (Throwable)e);
        }
    }

    public static void startLocatingTerminatedProcesses() {
        new Thread(() -> {
            long startTime = System.currentTimeMillis();
            terminatedProcessesLocationEndTime = System.currentTimeMillis() + 7000L;
            boolean firstIteration = true;
            while (System.currentTimeMillis() < terminatedProcessesLocationEndTime) {
                try {
                    Thread.sleep(firstIteration ? 3000L : 100L);
                    firstIteration = false;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Path terminatedProcessesPath = Paths.get(TerminatedProcessesFinder.getTerminatedByWinProcessLogs(), new String[0]);
                if (!terminatedProcessesPath.toFile().isFile()) continue;
                LOGGER.info("Time to locate terminated process: " + (System.currentTimeMillis() - startTime));
                Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
                synchronized (KnownCrashReasonMessage.class) {
                    LogsList.addIfExistsAndModified(new Log(LogType.WIN_EVENT, terminatedProcessesPath));
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    if (!GUIStartedLaunching) {
                        CrashAssistantApp.onMinecraftCrashed();
                        return;
                    }
                    startTime = System.currentTimeMillis();
                    while (true) {
                        if (System.currentTimeMillis() >= startTime + 7000L) {
                            System.exit(-1);
                        }
                        if (GUIInitialisationFinished) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        Class<?> clazz2 = Class.forName("dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI");
                        Method method = clazz2.getMethod("updateLogsListInGUI", new Class[0]);
                        method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception adding file to gui later:", (Throwable)e);
                    }
                    terminatedProcessesLocationEndTime = System.currentTimeMillis();
                    return;
                }
            }
        }).start();
    }

    static {
        parentXms = null;
        parentXmx = null;
        systemRAM = null;
        processor = null;
        crashed_with_report = false;
        crashAssistantJarName = Boot.crashAssistantModJarPath == null ? null : Paths.get(Boot.crashAssistantModJarPath, new String[0]).getFileName().toString();
        renderer = null;
        gameLaunchedSuccessfully = false;
        joinedWorldSuccessfully = false;
        stopFunctionFired = false;
        closeFunctionFailed = false;
        emergencySaveFired = false;
        terminatedProcessesLocationEndTime = 0L;
    }
}

