/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.class_loading;

import dev.kostromdan.mods.crash_assistant.app.class_loading.CrashAssistantAgent;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ErrorUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Boot {
    public static String log4jApi = null;
    public static String log4jCore = null;
    public static String googleGson = null;
    public static String commonIo = null;
    public static String jarPath = null;
    public static String crashAssistantModJarPath = null;
    public static boolean recursiveStart = false;
    public static boolean gpuDetect = false;
    public static boolean vulkanAddonLoaded = false;
    public static String serialisedGPUs = null;
    public static List<String> JVM_ARGS = ManagementFactory.getRuntimeMXBean().getInputArguments();
    public static List<String> APP_ARGS;

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        try {
            APP_ARGS = Arrays.asList(args);
            for (int i = 0; i < args.length; ++i) {
                if ("-log4jApi".equals(args[i]) && i + 1 < args.length) {
                    log4jApi = args[i + 1];
                    continue;
                }
                if ("-log4jCore".equals(args[i]) && i + 1 < args.length) {
                    log4jCore = args[i + 1];
                    continue;
                }
                if ("-googleGson".equals(args[i]) && i + 1 < args.length) {
                    googleGson = args[i + 1];
                    continue;
                }
                if ("-commonIo".equals(args[i]) && i + 1 < args.length) {
                    commonIo = args[i + 1];
                    continue;
                }
                if ("-jarPath".equals(args[i]) && i + 1 < args.length) {
                    jarPath = args[i + 1];
                    continue;
                }
                if ("-crashAssistantModJarPath".equals(args[i]) && i + 1 < args.length) {
                    crashAssistantModJarPath = args[i + 1];
                    continue;
                }
                if ("-serialisedGPUs".equals(args[i]) && i + 1 < args.length) {
                    serialisedGPUs = new String(Base64.getDecoder().decode(args[i + 1]), StandardCharsets.UTF_8);
                    continue;
                }
                if ("-recursiveStart".equals(args[i])) {
                    recursiveStart = true;
                    continue;
                }
                if (!"-gpuDetect".equals(args[i])) continue;
                gpuDetect = true;
            }
            List<String> missingParameters = Boot.getMissingParameters();
            if (!missingParameters.isEmpty()) {
                System.err.println("Missing required parameters: " + String.join((CharSequence)", ", missingParameters) + "\nIf you trying to run app from dev env, run CrashAssistantApp.");
                System.exit(-1);
            }
            CrashAssistantAgent.appendJarFile(log4jApi);
            CrashAssistantAgent.appendJarFile(log4jCore);
            CrashAssistantAgent.appendJarFile(googleGson);
            CrashAssistantAgent.appendJarFile(commonIo);
            CrashAssistantAgent.appendJarFile(crashAssistantModJarPath);
            if (gpuDetect) {
                Boot.loadVulkanAddon();
                try {
                    Class<?> GPUDetectorClass = Class.forName("dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPUDetector");
                    Method getSerialisedGPUsMethod = GPUDetectorClass.getMethod("getSerialisedGPUs", new Class[0]);
                    serialisedGPUs = (String)getSerialisedGPUsMethod.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    serialisedGPUs = ErrorUtils.getErrorMessageAndStackTrace((Throwable)e);
                }
                System.out.println(serialisedGPUs);
                System.exit(0);
            }
            if (!recursiveStart) {
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.add(JavaBinaryLocator.getJavaBinary());
                argsList.addAll(JVM_ARGS);
                argsList.add("-jar");
                argsList.add(jarPath);
                argsList.addAll(APP_ARGS);
                serialisedGPUs = Boot.getSerializedGPUsOnAnotherProcess(new ArrayList<String>(argsList));
                if (serialisedGPUs != null) {
                    String encodedGPUs = Base64.getEncoder().encodeToString(serialisedGPUs.getBytes(StandardCharsets.UTF_8));
                    argsList.add("-serialisedGPUs");
                    argsList.add(encodedGPUs);
                }
                argsList.add("-recursiveStart");
                ProcessBuilder pb = new ProcessBuilder(argsList);
                pb.start();
                System.exit(0);
            }
            Class<?> crashAssistantAppClass = Class.forName("dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp");
            Method mainMethod = crashAssistantAppClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Throwable e) {
            Path logsFolder = Paths.get("logs", "crash_assistant");
            Files.createDirectories(logsFolder, new FileAttribute[0]);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String errorDetails = "CrashAssistantApp process failed to start due to errors bellow:\nCrash Assistant won't work.\nThis won't cause any issues to the main game process, just Crash Assistant won't popup after crash.\nPlease report to https://github.com/KostromDan/Crash-Assistant/issues\n" + sw.toString();
            Path errorFile = logsFolder.resolve("app_start_error.txt");
            try {
                Files.write(errorFile, (errorDetails + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            }
            catch (IOException ioe) {
                System.err.println("Failed to write crash log: " + ioe.getMessage());
            }
        }
    }

    private static List<String> getMissingParameters() {
        ArrayList<String> missingParameters = new ArrayList<String>();
        if (log4jApi == null) {
            missingParameters.add("-log4jApi");
        }
        if (log4jCore == null) {
            missingParameters.add("-log4jCore");
        }
        if (googleGson == null) {
            missingParameters.add("-googleGson");
        }
        if (commonIo == null) {
            missingParameters.add("-commonIo");
        }
        if (jarPath == null) {
            missingParameters.add("-jarPath");
        }
        if (crashAssistantModJarPath == null) {
            missingParameters.add("-crashAssistantModJarPath");
        }
        return missingParameters;
    }

    private static void loadVulkanAddon() {
        List vulkanAddons = JarInJarHelper.getModsContainingPart((String[])new String[]{"CrashAssistantVulkanGPUDetectionAddon-"});
        Mod VulkanAddon = vulkanAddons.stream().findFirst().orElse(null);
        if (VulkanAddon == null) {
            return;
        }
        vulkanAddonLoaded = true;
        try {
            Path libsFolder = Paths.get("local", "crash_assistant", "libs");
            Files.createDirectories(libsFolder, new FileAttribute[0]);
            try (JarFile vulkanAddonJar = new JarFile(Paths.get("mods", VulkanAddon.getJarName()).toFile());){
                Enumeration<JarEntry> entries = vulkanAddonJar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith("META-INF/jarjar/") || !entryName.endsWith(".jar")) continue;
                    String jarFileName = entryName.substring(entryName.lastIndexOf(47) + 1);
                    Path extractedJarPath = libsFolder.resolve(jarFileName);
                    InputStream is = vulkanAddonJar.getInputStream(entry);
                    try {
                        Files.copy(is, extractedJarPath, StandardCopyOption.REPLACE_EXISTING);
                        CrashAssistantAgent.appendJarFile(extractedJarPath.toAbsolutePath().toString());
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to extract jar from VulkanAddon: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSerializedGPUsOnAnotherProcess(List<String> argsList) {
        try {
            argsList.add("-gpuDetect");
            ProcessBuilder pb = new ProcessBuilder(argsList);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            boolean finished = process.waitFor(5000L, TimeUnit.MILLISECONDS);
            if (!finished) {
                process.destroyForcibly();
                throw new RuntimeException("GPUDetector process reached timeout of 5 seconds and was killed.");
            }
            int exitCode = process.exitValue();
            try (InputStream is = process.getInputStream();){
                int bytesRead;
                StringBuilder output = new StringBuilder();
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer)) != -1) {
                    output.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                }
                String result = output.toString();
                if (exitCode == 0) {
                    String string2 = result;
                    return string2;
                }
                String string = "GPUDetector process exited with non zero exit code: " + exitCode + "\nSTDOUT:\n" + result;
                return string;
            }
        }
        catch (Throwable ignored) {
            return "Error while getting gpus with GPUDetector process: " + ErrorUtils.getErrorMessageAndStackTrace((Throwable)ignored);
        }
    }
}

