/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.gpu;

import dev.kostromdan.mods.crash_assistant.app.utils.gpu.RendererType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GPU {
    private final RendererType type;
    private final String name;

    public GPU(RendererType type, String name) {
        this.type = type;
        this.name = name;
    }

    public RendererType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GPU gpu = (GPU)o;
        return this.type == gpu.type && Objects.equals(this.name, gpu.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return "GPU{type=" + String.valueOf((Object)this.type) + ", name='" + this.name + "'}";
    }

    public static String serializeGPUs(List<GPU> gpus) {
        StringBuilder serializedGPUs = new StringBuilder();
        for (GPU gpu : gpus) {
            serializedGPUs.append((Object)gpu.getType()).append(" : ").append(gpu.getName()).append("\n");
        }
        return serializedGPUs.toString();
    }

    public static List<GPU> deserializeGPUs(String serialisedGPU) {
        ArrayList<GPU> gpus = new ArrayList<GPU>();
        if (serialisedGPU == null || serialisedGPU.isEmpty()) {
            System.out.println("No GPU information available");
            return gpus;
        }
        RendererType[] rendererTypes = RendererType.values();
        for (String line : serialisedGPU.split("\n")) {
            if (line.trim().isEmpty()) continue;
            boolean isValidGpuLine = false;
            for (RendererType type : rendererTypes) {
                if (!line.startsWith(type.name())) continue;
                isValidGpuLine = true;
                break;
            }
            if (!isValidGpuLine) continue;
            int index = line.indexOf(" : ");
            if (index == -1) {
                System.err.println("Invalid GPU info format: " + line);
                continue;
            }
            try {
                RendererType type = Enum.valueOf(RendererType.class, line.substring(0, index).toUpperCase());
                String name = line.substring(index + 3);
                gpus.add(new GPU(type, name));
            }
            catch (Exception e) {
                System.err.println("Error parsing GPU info: " + line + " - " + e.getMessage());
            }
        }
        return gpus;
    }
}

