/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;

public class LivingTrainerWhitelistPacket {
    private int slot;
    private boolean isWhitelist;

    public LivingTrainerWhitelistPacket() {
    }

    public LivingTrainerWhitelistPacket(int slot, boolean isWhitelist) {
        this.slot = slot;
        this.isWhitelist = isWhitelist;
    }

    public static void encode(LivingTrainerWhitelistPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.slot);
        buf.writeBoolean(pkt.isWhitelist);
    }

    public static LivingTrainerWhitelistPacket decode(FriendlyByteBuf buf) {
        LivingTrainerWhitelistPacket pkt = new LivingTrainerWhitelistPacket(buf.readInt(), buf.readBoolean());
        return pkt;
    }

    public static void handle(LivingTrainerWhitelistPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> LivingTrainerWhitelistPacket.sendKeyToServer(message, (Player)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(LivingTrainerWhitelistPacket msg, Player playerEntity) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.m_150109_().m_8020_(msg.slot);
        }
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof ItemLivingTrainer) {
            ((ItemLivingTrainer)itemStack.m_41720_()).setIsWhitelist(itemStack, msg.isWhitelist);
        }
    }
}

