/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.processing;

import com.smashingmods.alchemylib.api.blockentity.processing.AbstractProcessingBlockEntity;
import com.smashingmods.alchemylib.api.blockentity.processing.FluidBlockEntity;
import com.smashingmods.alchemylib.api.blockentity.processing.InventoryBlockEntity;
import com.smashingmods.alchemylib.api.storage.FluidStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.alchemylib.api.storage.SidedProcessingSlotWrapper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFluidBlockEntity
extends AbstractProcessingBlockEntity
implements FluidBlockEntity,
InventoryBlockEntity {
    private final FluidStorageHandler fluidStorage = this.initializeFluidStorage();
    private final LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.of(() -> this.fluidStorage);
    private final ProcessingSlotHandler inputHandler = this.initializeInputHandler();
    private final ProcessingSlotHandler outputHandler = this.initializeOutputHandler();
    private final SidedProcessingSlotWrapper combinedHandler = new SidedProcessingSlotWrapper(this.inputHandler, this.outputHandler);

    public AbstractFluidBlockEntity(String pModId, BlockEntityType<?> pBlockEntityType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pModId, pBlockEntityType, pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        if (!this.getFluidStorage().isEmpty()) {
            this.setCanProcess(this.canProcessRecipe());
        }
        super.tick();
    }

    @Override
    public FluidStorageHandler getFluidStorage() {
        return this.fluidStorage;
    }

    @Override
    public ProcessingSlotHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public ProcessingSlotHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Override
    public SidedProcessingSlotWrapper getCombinedSlotHandler() {
        return this.combinedHandler;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> pCapability, @Nullable Direction pDirection) {
        if (pCapability == ForgeCapabilities.ITEM_HANDLER) {
            return this.getCombinedSlotHandler().getViewLazily(pDirection).cast();
        }
        if (pCapability == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        return super.getCapability(pCapability, pDirection);
    }

    @Override
    public void invalidateCaps() {
        this.combinedHandler.invalidate();
        this.lazyFluidHandler.invalidate();
        super.invalidateCaps();
    }

    @Override
    public boolean isRecipeLocked() {
        return false;
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("input", (Tag)this.inputHandler.serializeNBT());
        pTag.m_128365_("output", (Tag)this.outputHandler.serializeNBT());
        pTag.m_128365_("fluid", (Tag)this.fluidStorage.writeToNBT(new CompoundTag()));
        pTag.m_128376_("sides", this.combinedHandler.sideModesToShort());
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inputHandler.deserializeNBT(pTag.m_128469_("input"));
        this.outputHandler.deserializeNBT(pTag.m_128469_("output"));
        this.fluidStorage.readFromNBT(pTag.m_128469_("fluid"));
        if (pTag.m_128441_("sides")) {
            this.combinedHandler.setSideModesFromShort(pTag.m_128448_("sides"));
        } else {
            this.combinedHandler.setSideModesFromShort(SidedProcessingSlotWrapper.LEGACY_SIDES_CONFIGURATION);
        }
    }

    public boolean onBlockActivated(Level pLevel, BlockPos pBlockPos, Player pPlayer, InteractionHand pHand) {
        return FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, (Level)pLevel, (BlockPos)pBlockPos, null);
    }
}

