/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.processing;

import com.smashingmods.alchemylib.api.blockentity.processing.AbstractProcessingBlockEntity;
import com.smashingmods.alchemylib.api.blockentity.processing.InventoryBlockEntity;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.alchemylib.api.storage.SidedProcessingSlotWrapper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInventoryBlockEntity
extends AbstractProcessingBlockEntity
implements InventoryBlockEntity {
    private final ProcessingSlotHandler inputHandler = this.initializeInputHandler();
    private final ProcessingSlotHandler outputHandler = this.initializeOutputHandler();
    private final SidedProcessingSlotWrapper combinedHandler = new SidedProcessingSlotWrapper(this.inputHandler, this.outputHandler);

    public AbstractInventoryBlockEntity(String pModId, BlockEntityType<?> pBlockEntityType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pModId, pBlockEntityType, pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        if (!this.inputHandler.isEmpty()) {
            this.setCanProcess(this.canProcessRecipe());
        }
        super.tick();
    }

    @Override
    public ProcessingSlotHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public ProcessingSlotHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Override
    public SidedProcessingSlotWrapper getCombinedSlotHandler() {
        return this.combinedHandler;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> pCapability, @Nullable Direction pDirection) {
        if (pCapability == ForgeCapabilities.ITEM_HANDLER) {
            return this.getCombinedSlotHandler().getViewLazily(pDirection).cast();
        }
        return super.getCapability(pCapability, pDirection);
    }

    @Override
    public void invalidateCaps() {
        this.combinedHandler.invalidate();
        super.invalidateCaps();
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("input", (Tag)this.inputHandler.serializeNBT());
        pTag.m_128365_("output", (Tag)this.outputHandler.serializeNBT());
        pTag.m_128376_("sides", this.combinedHandler.sideModesToShort());
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inputHandler.deserializeNBT(pTag.m_128469_("input"));
        this.outputHandler.deserializeNBT(pTag.m_128469_("output"));
        if (pTag.m_128441_("sides")) {
            this.combinedHandler.setSideModesFromShort(pTag.m_128448_("sides"));
        } else {
            this.combinedHandler.setSideModesFromShort(SidedProcessingSlotWrapper.LEGACY_SIDES_CONFIGURATION);
        }
    }
}

