/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.network.client;

import dev.murad.shipping.network.client.EntityPosition;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class VehicleTrackerClientPacket {
    public final CompoundTag tag;
    public final String dimension;

    public VehicleTrackerClientPacket(FriendlyByteBuf buffer) {
        this.tag = buffer.m_130260_();
        this.dimension = new String(buffer.m_130052_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.m_130087_(this.dimension.getBytes());
    }

    public static VehicleTrackerClientPacket of(List<EntityPosition> types, String dimension) {
        CompoundTag tag = new CompoundTag();
        int i = 0;
        for (EntityPosition position : types) {
            CompoundTag coords = new CompoundTag();
            coords.m_128347_("x", position.pos().f_82479_);
            coords.m_128347_("y", position.pos().f_82480_);
            coords.m_128347_("z", position.pos().f_82481_);
            coords.m_128347_("xo", position.oldPos().f_82479_);
            coords.m_128347_("yo", position.oldPos().f_82480_);
            coords.m_128347_("zo", position.oldPos().f_82481_);
            coords.m_128359_("type", position.type());
            coords.m_128405_("eid", position.id());
            tag.m_128365_(String.valueOf(i++), (Tag)coords);
        }
        return new VehicleTrackerClientPacket(tag, dimension);
    }

    public List<EntityPosition> parse() {
        return this.tag.m_128431_().stream().map(key -> {
            CompoundTag coords = this.tag.m_128469_(key);
            return new EntityPosition(coords.m_128461_("type"), coords.m_128451_("eid"), new Vec3(coords.m_128459_("x"), coords.m_128459_("y"), coords.m_128459_("z")), new Vec3(coords.m_128459_("xo"), coords.m_128459_("yo"), coords.m_128459_("zo")));
        }).collect(Collectors.toList());
    }

    public VehicleTrackerClientPacket(CompoundTag tag, String dimension) {
        this.tag = tag;
        this.dimension = dimension;
    }
}

