/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.language.ClientLanguageGetter;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class AmmoBarOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_ammo_bar";
    private static final ResourceLocation LINE = Mod.loc("textures/gun_icon/fire_mode/line.png");
    private static final ResourceLocation SEMI = Mod.loc("textures/gun_icon/fire_mode/semi.png");
    private static final ResourceLocation BURST = Mod.loc("textures/gun_icon/fire_mode/burst.png");
    private static final ResourceLocation AUTO = Mod.loc("textures/gun_icon/fire_mode/auto.png");
    private static final ResourceLocation TOP = Mod.loc("textures/gun_icon/fire_mode/top.png");
    private static final ResourceLocation DIR = Mod.loc("textures/gun_icon/fire_mode/dir.png");
    private static final ResourceLocation MOUSE = Mod.loc("textures/gun_icon/fire_mode/mouse.png");
    private static final ResourceLocation CHOSEN = Mod.loc("textures/gui/attachment/chosen.png");
    private static final ResourceLocation NOT_CHOSEN = Mod.loc("textures/gui/attachment/not_chosen.png");
    private static final ResourceLocation AMMO_STACK = Mod.loc("textures/gui/attachment/ammo_stack.png");
    private static final Pattern REPLACE_FORMAT_CODE = Pattern.compile("\u00a7.");

    private static ResourceLocation getFireMode(GunData data) {
        return switch (data.fireMode.get()) {
            default -> throw new IncompatibleClassChangeError();
            case FireMode.SEMI -> SEMI;
            case FireMode.BURST -> BURST;
            case FireMode.AUTO -> AUTO;
        };
    }

    private static String getGunAmmoString(GunData data, Player player) {
        if (data.meleeOnly() || data.useBackpackAmmo() && data.hasInfiniteBackupAmmo((Entity)player)) {
            return "\u221e";
        }
        return data.useBackpackAmmo() ? "" + (data.countBackupAmmo((Entity)player) - data.virtualAmmo.get()) : "" + data.ammo.get();
    }

    private static String getBackupAmmoString(GunData data, Player player) {
        if (data.meleeOnly() || data.useBackpackAmmo()) {
            return "";
        }
        return data.hasInfiniteBackupAmmo((Entity)player) ? "\u221e" : "" + (data.countBackupAmmo((Entity)player) - data.virtualAmmo.get());
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!((Boolean)DisplayConfig.AMMO_HUD.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            ArmedVehicleEntity vehicle;
            GunItem gunItem = (GunItem)item;
            item = player.m_20202_();
            if (!(item instanceof ArmedVehicleEntity) || !(vehicle = (ArmedVehicleEntity)item).banHand((Player)player)) {
                int x = screenWidth + (Integer)DisplayConfig.WEAPON_HUD_X_OFFSET.get();
                int y = screenHeight + (Integer)DisplayConfig.WEAPON_HUD_Y_OFFSET.get();
                PoseStack poseStack = guiGraphics.m_280168_();
                GunData data = GunData.from(stack);
                guiGraphics.m_280163_(gunItem.getGunIcon(stack), x - 135, y - 40, 0.0f, 0.0f, 64, 16, 64, 16);
                Font font = Minecraft.m_91087_().f_91062_;
                if (stack.m_41720_() != ModItems.MINIGUN.get()) {
                    guiGraphics.drawString(font, "[" + ModKeyMappings.FIRE_MODE.getKey().m_84875_().getString() + "]", (float)x - 111.5f, (float)(y - 20), 0xFFFFFF, false);
                }
                ResourceLocation fireMode = AmmoBarOverlay.getFireMode(data);
                if (stack.m_41720_() == ModItems.JAVELIN.get()) {
                    ResourceLocation resourceLocation = fireMode = stack.m_41784_().m_128471_("TopMode") ? TOP : DIR;
                }
                if (stack.m_41720_() == ModItems.MINIGUN.get()) {
                    fireMode = MOUSE;
                    guiGraphics.drawString(font, data.get(GunProp.RPM) + " RPM", (float)x - 111.0f, (float)(y - 20), 0xFFFFFF, false);
                    guiGraphics.m_280163_(fireMode, x - 126, y - 22, 0.0f, 0.0f, 12, 12, 12, 12);
                } else {
                    guiGraphics.m_280163_(fireMode, x - 95, y - 21, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                if (stack.m_41720_() != ModItems.MINIGUN.get()) {
                    guiGraphics.m_280163_(LINE, x - 95, y - 16, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                int size = data.ammoConsumers.size();
                if (((Boolean)DisplayConfig.ADVANCED_AMMO_HUD.get()).booleanValue() && (size > 1 || size == 1 && data.selectedAmmoConsumer().type != AmmoConsumer.AmmoConsumeType.PLAYER_AMMO)) {
                    boolean renderStackCount;
                    AmmoConsumer ammoConsumer = data.selectedAmmoConsumer();
                    RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, x - 62, (float)y - 20.5f, 0.0f, 0.0f, 24.0f, 8.5f, 24.0f, 24.0f);
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)(x - 57), (float)(y - 21), 0.0f);
                    poseStack.m_85841_(0.75f, 0.75f, 1.0f);
                    AmmoConsumer.AmmoConsumeType consumerType = ammoConsumer.type;
                    boolean bl = renderStackCount = consumerType == AmmoConsumer.AmmoConsumeType.ITEM || consumerType == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO;
                    if (renderStackCount) {
                        ItemStack ammoStack;
                        if (consumerType == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
                            Ammo ammoType = ammoConsumer.getPlayerAmmoType();
                            ammoStack = switch (ammoType) {
                                default -> throw new IncompatibleClassChangeError();
                                case Ammo.HANDGUN -> new ItemStack((ItemLike)ModItems.HANDGUN_AMMO.get());
                                case Ammo.RIFLE -> new ItemStack((ItemLike)ModItems.RIFLE_AMMO.get());
                                case Ammo.SHOTGUN -> new ItemStack((ItemLike)ModItems.SHOTGUN_AMMO.get());
                                case Ammo.SNIPER -> new ItemStack((ItemLike)ModItems.SNIPER_AMMO.get());
                                case Ammo.HEAVY -> new ItemStack((ItemLike)ModItems.HEAVY_AMMO.get());
                            };
                        } else {
                            ammoStack = ammoConsumer.stack();
                        }
                        poseStack.m_252880_(1.75f, 0.0f, 0.0f);
                        guiGraphics.m_280203_(ammoStack, 3, -1);
                        poseStack.m_252880_(-1.75f, 0.0f, 0.0f);
                        String text = "" + data.countBackupAmmoItem((Entity)player);
                        guiGraphics.m_280056_(font, text, 24, 8, 0xFFFFFF, true);
                    }
                    poseStack.m_85849_();
                    if (!renderStackCount) {
                        if (consumerType == AmmoConsumer.AmmoConsumeType.INVALID) {
                            RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, x - 50, y - 20, 12.0f, 8.5f, 4.0f, 8.0f, 24.0f, 24.0f);
                        } else {
                            RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, (float)x - 51.0f, y - 20, 0.0f, 8.5f, 7.0f, 8.0f, 24.0f, 24.0f);
                        }
                    }
                    if (size > 1) {
                        float offset = 47.0f;
                        int count = size / 2;
                        float posX = size % 2 == 0 ? (float)(x - count * 6 + 1) : (float)(x - count * 6 - 2);
                        float posY = y - 8;
                        for (int i = 0; i < size; ++i) {
                            RenderHelper.preciseBlit(guiGraphics, i == data.selectedAmmoType.get() ? CHOSEN : NOT_CHOSEN, posX - offset + (float)(6 * i), posY, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, 4.0f);
                        }
                    }
                }
                poseStack.m_85836_();
                poseStack.m_85841_(1.5f, 1.5f, 1.0f);
                int gunAmmoY = data.useBackpackAmmo() ? y - 35 : y + 5 - 48;
                guiGraphics.drawString(font, AmmoBarOverlay.getGunAmmoString(data, (Player)player), (float)x / 1.5f - 42.666668f, (float)gunAmmoY / 1.5f, 0xFFFFFF, true);
                poseStack.m_85849_();
                if (data.virtualAmmo.get() > 0 && !data.meleeOnly()) {
                    guiGraphics.drawString(font, "+" + data.virtualAmmo.get(), (float)(x - 62) + (float)font.m_92895_(AmmoBarOverlay.getGunAmmoString(data, (Player)player)) * 1.5f, (float)(y - 46), 0x55FFFF, true);
                }
                guiGraphics.m_280056_(font, AmmoBarOverlay.getBackupAmmoString(data, (Player)player), x - 64, y - 30, 0xCCCCCC, true);
                poseStack.m_85836_();
                poseStack.m_85841_(0.9f, 0.9f, 1.0f);
                String gunName = AmmoBarOverlay.getGunDisplayName(stack);
                guiGraphics.drawString(font, gunName, (float)x / 0.9f - (100.0f + (float)font.m_92895_(gunName) / 2.0f) / 0.9f, (float)y / 0.9f - 66.66667f, 0xFFFFFF, true);
                String ammoName = REPLACE_FORMAT_CODE.matcher(AmmoBarOverlay.getAmmoDisplayName(data)).replaceAll("");
                guiGraphics.drawString(font, ammoName, (float)x / 0.9f - (100.0f + (float)font.m_92895_(ammoName) / 2.0f) / 0.9f, (float)y / 0.9f - 56.666668f, 13149817, true);
                poseStack.m_85849_();
            }
        }
    }

    private static String getGunDisplayName(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ClientLanguageGetter.EN_US.m_6834_(stack.m_41778_());
        }
        return "";
    }

    private static String getAmmoDisplayName(GunData data) {
        AmmoConsumer consumer = data.selectedAmmoConsumer();
        if (consumer.type == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
            return consumer.getPlayerAmmoType().displayName;
        }
        if (consumer.type == AmmoConsumer.AmmoConsumeType.INFINITE) {
            return "Infinity";
        }
        if (data.meleeOnly()) {
            return "Melee";
        }
        if (!consumer.stack().m_41619_()) {
            Component nameComponent = consumer.stack().m_41786_();
            ComponentContents componentContents = nameComponent.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatableComponent = (TranslatableContents)componentContents;
                return ClientLanguageGetter.EN_US.m_6834_(translatableComponent.m_237508_());
            }
            return ClientLanguageGetter.EN_US.m_6834_(consumer.stack().m_41778_());
        }
        return "";
    }
}

