/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoSupplierItem;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.animation.AnimationCurves;
import com.atsuishio.superbwarfare.tools.animation.AnimationTimer;
import com.atsuishio.superbwarfare.tools.animation.ValueAnimator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class AmmoCountOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_ammo_count";
    private static final AnimationTimer ammoInfoTimer = new AnimationTimer(500L, 2000L).forwardAnimation(AnimationCurves.EASE_OUT_EXPO).backwardAnimation(AnimationCurves.EASE_IN_EXPO);
    private static final AnimationTimer ammoBoxTimer = new AnimationTimer(500L).forwardAnimation(AnimationCurves.EASE_OUT_EXPO).backwardAnimation(AnimationCurves.EASE_IN_EXPO);
    private static final ValueAnimator<Integer>[] ammoCountAnimators = ValueAnimator.create(Ammo.values().length, 800L, 0);
    private static final ValueAnimator<Integer>[] ammoBoxAnimators = ValueAnimator.create(Ammo.values().length, 800L, 0);

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ArmedVehicleEntity vehicle;
        Entity entity;
        boolean startRenderingAmmoInfo = false;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        boolean isAmmoBox = false;
        long currentTime = System.currentTimeMillis();
        ItemStack stack = player.m_21205_();
        if (!(!(stack.m_41720_() instanceof AmmoSupplierItem) && stack.m_41720_() != ModItems.AMMO_BOX.get() || (entity = player.m_20202_()) instanceof ArmedVehicleEntity && (vehicle = (ArmedVehicleEntity)entity).banHand((Player)player))) {
            startRenderingAmmoInfo = ammoInfoTimer.getProgress(currentTime) == 0.0f;
            ammoInfoTimer.forward(currentTime);
            if (stack.m_41720_() == ModItems.AMMO_BOX.get()) {
                isAmmoBox = true;
                ammoBoxTimer.forward(currentTime);
            } else {
                ammoBoxTimer.backward(currentTime);
            }
        } else {
            ammoInfoTimer.backward(currentTime);
            ammoBoxTimer.backward(currentTime);
        }
        if (!ammoInfoTimer.isForward() && ammoInfoTimer.finished(currentTime)) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float ammoX = ammoInfoTimer.lerp(screenWidth + 120, (float)screenWidth / 2.0f + 40.0f, currentTime);
        int fontHeight = 15;
        float yOffset = (float)(-screenHeight - Ammo.values().length * 15) / 2.0f;
        Font font = Minecraft.m_91087_().f_91062_;
        for (Ammo type : Ammo.values()) {
            int index = type.ordinal();
            int ammoCount = type.get((Player)player);
            ValueAnimator<Integer> animator = ammoCountAnimators[index];
            ValueAnimator<Integer> boxAnimator = ammoBoxAnimators[index];
            Integer boxAmmoCount = boxAnimator.newValue();
            boolean boxAmmoSelected = false;
            if (isAmmoBox) {
                String ammoBoxType = stack.m_41784_().m_128461_("Type");
                boxAmmoCount = type.get(stack);
                if (ammoBoxType.equals("All") || ammoBoxType.equals(type.serializationName)) {
                    boxAnimator.forward(currentTime);
                    boxAmmoSelected = true;
                } else {
                    boxAnimator.reset(boxAmmoCount);
                }
            }
            if (startRenderingAmmoInfo) {
                animator.reset(ammoCount);
                animator.endForward(currentTime);
                if (isAmmoBox) {
                    boxAnimator.reset(type.get(stack));
                    boxAnimator.endForward(currentTime);
                }
            }
            int ammoAdd = Integer.compare(ammoCount, animator.oldValue());
            animator.compareAndUpdate(ammoCount, () -> animator.beginForward(currentTime));
            float progress = animator.getProgress(currentTime);
            String ammoCountStr = Integer.toString(Math.round(animator.lerp(animator.oldValue().intValue(), ammoCount, currentTime)));
            int fontColor = FastColor.ARGB32.m_269105_((float)progress, (int)(switch (ammoAdd) {
                case 1 -> -16711936;
                case -1 -> -65536;
                default -> -1;
            }), (int)-1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)ammoInfoTimer.lerp(0.0f, 1.0f, currentTime));
            guiGraphics.drawString(font, ammoCountStr, ammoX + (float)(30 - font.m_92895_(ammoCountStr)), (float)screenHeight + yOffset, fontColor, true);
            guiGraphics.drawString(font, Component.m_237115_((String)type.translationKey).getString(), ammoX + 35.0f, (float)screenHeight + yOffset, fontColor, true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)ammoBoxTimer.lerp(0.0f, 1.0f, currentTime));
            float ammoBoxX = ammoBoxTimer.lerp(-30.0f, (float)screenWidth / 2.0f, currentTime);
            int ammoBoxAdd = Integer.compare(boxAmmoCount, boxAnimator.oldValue());
            boxAnimator.compareAndUpdate(boxAmmoCount, () -> boxAnimator.beginForward(currentTime));
            int targetColor = boxAmmoSelected ? -256 : -1;
            float f = boxAnimator.getProgress(currentTime);
            int boxFontColor = FastColor.ARGB32.m_269105_((float)f, (int)(switch (ammoBoxAdd) {
                case 1 -> -16711936;
                case -1 -> -65536;
                default -> targetColor;
            }), (int)targetColor);
            guiGraphics.drawString(Minecraft.m_91087_().f_91062_, Integer.toString(Math.round(boxAnimator.lerp(boxAnimator.oldValue().intValue(), boxAmmoCount.intValue(), currentTime))), ammoBoxX - 70.0f, (float)screenHeight + yOffset, boxFontColor, true);
            yOffset += 15.0f;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

