/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class BulletDecalOption
implements ParticleOptions {
    public static final Codec<BulletDecalOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("dir").forGetter(option -> option.direction.ordinal()), (App)Codec.LONG.fieldOf("pos").forGetter(option -> option.pos.m_121878_()), (App)Codec.FLOAT.fieldOf("r").forGetter(option -> Float.valueOf(option.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(option -> Float.valueOf(option.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(option -> Float.valueOf(option.blue))).apply((Applicative)builder, BulletDecalOption::new));
    public static final ParticleOptions.Deserializer<BulletDecalOption> DESERIALIZER = new ParticleOptions.Deserializer<BulletDecalOption>(){

        public BulletDecalOption fromCommand(ParticleType<BulletDecalOption> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int dir = reader.readInt();
            reader.expect(' ');
            long pos = reader.readLong();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return new BulletDecalOption(dir, pos, r, g, b);
        }

        public BulletDecalOption fromNetwork(ParticleType<BulletDecalOption> particleType, FriendlyByteBuf buffer) {
            return new BulletDecalOption(buffer.m_130242_(), buffer.readLong(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final Direction direction;
    private final BlockPos pos;
    private final float red;
    private final float green;
    private final float blue;

    public BulletDecalOption(int dir, long pos) {
        this(Direction.values()[dir], BlockPos.m_122022_((long)pos), 0.9f, 0.0f, 0.0f);
    }

    public BulletDecalOption(int dir, long pos, float r, float g, float b) {
        this(Direction.values()[dir], BlockPos.m_122022_((long)pos), r, g, b);
    }

    public BulletDecalOption(Direction dir, BlockPos pos) {
        this(dir, pos, 0.9f, 0.0f, 0.0f);
    }

    public BulletDecalOption(Direction dir, BlockPos pos, float r, float g, float b) {
        this.direction = dir;
        this.pos = pos;
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.BULLET_DECAL.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.direction);
        buffer.m_130064_(this.pos);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.direction.m_122433_();
    }
}

