/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomCloudOption
implements ParticleOptions {
    public static final Codec<CustomCloudOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(option -> option.color), (App)Codec.INT.fieldOf("life").forGetter(option -> option.life), (App)Codec.FLOAT.fieldOf("size").forGetter(option -> Float.valueOf(option.size)), (App)Codec.FLOAT.fieldOf("gravity").forGetter(option -> Float.valueOf(option.gravity)), (App)Codec.BOOL.fieldOf("cooldown").forGetter(option -> option.cooldown), (App)Codec.BOOL.fieldOf("light").forGetter(option -> option.light)).apply((Applicative)builder, CustomCloudOption::new));
    public static final ParticleOptions.Deserializer<CustomCloudOption> DESERIALIZER = new ParticleOptions.Deserializer<CustomCloudOption>(){

        public CustomCloudOption fromCommand(ParticleType<CustomCloudOption> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            int life = reader.readInt();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float gravity = reader.readFloat();
            reader.expect(' ');
            boolean cooldown = reader.readBoolean();
            reader.expect(' ');
            boolean light = reader.readBoolean();
            return new CustomCloudOption(color, life, size, gravity, cooldown, light);
        }

        public CustomCloudOption fromNetwork(ParticleType<CustomCloudOption> particleType, FriendlyByteBuf buffer) {
            return new CustomCloudOption(buffer.readInt(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), buffer.readBoolean());
        }
    };
    private final int color;
    private final int life;
    private final float size;
    private final float gravity;
    private final boolean cooldown;
    private final boolean light;

    public CustomCloudOption(float r, float g, float b, int life, float size, float gravity, boolean cooldown, boolean light) {
        this(Math.round(r * 255.0f) << 16 | Math.round(g * 255.0f) << 8 | Math.round(b * 255.0f), life, size, gravity, cooldown, light);
    }

    public CustomCloudOption(int color, int life, float size, float gravity, boolean cooldown, boolean light) {
        this.color = color;
        this.life = life;
        this.size = size;
        this.gravity = gravity;
        this.cooldown = cooldown;
        this.light = light;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    public int getLife() {
        return this.life;
    }

    public float getSize() {
        return this.size;
    }

    public float getGravity() {
        return this.gravity;
    }

    public boolean getCooldown() {
        return this.cooldown;
    }

    public boolean getLight() {
        return this.light;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.CUSTOM_CLOUD.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.size);
        buffer.writeFloat(this.gravity);
        buffer.writeBoolean(this.cooldown);
        buffer.writeBoolean(this.light);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " [" + this.color + ", " + this.life + ", " + this.size + ", " + this.gravity + ", " + this.cooldown + ", " + this.light + "]";
    }
}

