/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.compat.jei;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GunPerksCategory
implements IRecipeCategory<ItemStack> {
    public static final ResourceLocation TEXTURE = Mod.loc("textures/gui/jei_gun_perks.png");
    public static final RecipeType<ItemStack> TYPE = RecipeType.create((String)"superbwarfare", (String)"gun_perks", ItemStack.class);
    private final IDrawable background;
    private final IDrawable icon;

    public GunPerksCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 144, 128).setTextureSize(144, 128).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.AP_BULLET.get()));
    }

    public void draw(ItemStack recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Component name = recipe.m_41786_();
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, name, 80 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)name) / 2, 5, 0x555555, false);
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public RecipeType<ItemStack> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.superbwarfare.gun_perks");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 128;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ItemStack stack, IFocusGroup focuses) {
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        List<Perk> perks = data.availablePerks();
        ArrayList<Perk> sortedPerks = new ArrayList<Perk>(perks);
        sortedPerks.sort((a, b) -> {
            int bIndex;
            int aIndex = GunPerksCategory.getIndex(a);
            return aIndex == (bIndex = GunPerksCategory.getIndex(b)) ? a.name.compareTo(b.name) : aIndex - bIndex;
        });
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStack(stack);
        for (int i = 0; i < sortedPerks.size(); ++i) {
            Item perkItem = (Item)((Perk)sortedPerks.get(i)).getItem().get();
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + i % 8 * 18, 21 + i / 8 * 18).addItemStack(perkItem.m_7968_());
        }
    }

    private static int getIndex(Perk perk) {
        return switch (perk.type) {
            default -> throw new IncompatibleClassChangeError();
            case Perk.Type.AMMO -> 0;
            case Perk.Type.FUNCTIONAL -> 1;
            case Perk.Type.DAMAGE -> 2;
        };
    }
}

