/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.mob_guns;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.mob_guns.DefaultMobGunData;
import com.atsuishio.superbwarfare.data.mob_guns.GunSpawnData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.TagDataParser;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobGunData {
    public static final LoadingCache<Mob, MobGunData> dataCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Mob, MobGunData>(){

        @NotNull
        public MobGunData load(@NotNull Mob mob) {
            return new MobGunData(mob);
        }
    });
    public final DefaultMobGunData data;
    private final Mob mob;
    private GunData gunData;
    private GunSpawnData selectedData;

    private MobGunData(Mob mob) {
        this.mob = mob;
        this.data = (DefaultMobGunData)CustomData.MOB_GUNS.get(EntityType.m_20613_((EntityType)mob.m_6095_()).toString());
    }

    @Nullable
    public static MobGunData from(Mob mob) {
        String mobId = EntityType.m_20613_((EntityType)mob.m_6095_()).toString();
        if (!CustomData.MOB_GUNS.containsKey(mobId)) {
            return null;
        }
        return (MobGunData)dataCache.getUnchecked((Object)mob);
    }

    @Nullable
    public GunData getGunData() {
        if (this.gunData != null) {
            return this.gunData;
        }
        List<GunSpawnData> guns = this.data.guns.list.stream().map(d -> (GunSpawnData)d.value).toList();
        int totalWeight = guns.stream().mapToInt(g -> Math.max(0, g.weight)).sum();
        if (totalWeight <= 0) {
            return null;
        }
        int random = this.mob.m_9236_().f_46441_.m_188503_(totalWeight);
        int currentWeight = 0;
        for (GunSpawnData gun : guns) {
            if (random >= (currentWeight += gun.weight)) continue;
            this.selectedData = gun;
            break;
        }
        if (this.selectedData == null) {
            return null;
        }
        String gunID = this.selectedData.id;
        ResourceLocation location = ResourceLocation.m_135820_((String)gunID);
        if (location == null) {
            Mod.LOGGER.warn("invalid gun id: {}", (Object)gunID);
            return null;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
        if (item == Items.f_41852_ || !(item instanceof GunItem)) {
            Mod.LOGGER.warn("invalid gun item {} for id {}", (Object)item, (Object)gunID);
            return null;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (this.selectedData.data != null) {
            stack.m_41751_(TagDataParser.parse(this.selectedData.data));
        }
        GunData data = GunData.from(stack);
        if (this.selectedData.override != null) {
            data.propertyOverrideString.set(DataLoader.GSON.toJson((JsonElement)this.selectedData.override));
        }
        this.gunData = data;
        return data;
    }

    public int goalWeight() {
        return this.data.goalWeight;
    }

    public double probability() {
        return Mth.m_14008_((double)this.data.probability, (double)0.0, (double)1.0);
    }

    public boolean spawnWithLoadedAmmo() {
        return this.selectedData.spawnWithLoadedAmmo;
    }

    public double shootDistance() {
        return this.selectedData.shootDistance;
    }

    public int backupAmmoCount() {
        return this.selectedData.backupAmmo;
    }

    public int aimTime() {
        return Math.max(0, this.selectedData.aimTime);
    }

    public long semiFireInterval() {
        return Math.max(0L, this.selectedData.semiFireInterval);
    }

    public boolean clearAimTimeWhenLostSight() {
        return this.selectedData.clearAimTimeWhenLostSight;
    }

    public boolean zoom() {
        return this.selectedData.zoom;
    }

    public double spread() {
        return this.selectedData.spread;
    }
}

