/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.StringPropModifier;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleDataTool;
import com.atsuishio.superbwarfare.data.vehicle.VehicleProp;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class VehicleData
implements DefaultDataSupplier<DefaultVehicleData> {
    public final String id;
    public final VehicleEntity vehicle;
    private final Set<VehicleProp<?>> operatingProps = new HashSet();
    private final StringPropModifier<VehicleData, DefaultVehicleData> stringPropModifier = new StringPropModifier();
    public static final LoadingCache<VehicleEntity, VehicleData> dataCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<VehicleEntity, VehicleData>(){

        @NotNull
        public VehicleData load(@NotNull VehicleEntity entity) {
            return new VehicleData(entity);
        }
    });

    private VehicleData(VehicleEntity entity) {
        this.id = VehicleData.getRegistryId(entity.m_6095_());
        this.vehicle = entity;
    }

    public <T> T get(VehicleProp<T> prop) {
        Prop.PropModifier modifier = prop.asModifier(this);
        if (this.operatingProps.contains(prop)) {
            Mod.LOGGER.warn("recursive computation for property {}", (Object)prop.name);
            return (T)modifier.compute();
        }
        this.operatingProps.add(prop);
        if (this.vehicle.isInitialized()) {
            modifier.apply(this.vehicle.getModifier(prop));
            String propertyOverrideString = (String)this.vehicle.m_20088_().m_135370_(VehicleEntity.OVERRIDE);
            this.stringPropModifier.modifyPropertyByString(propertyOverrideString, prop);
            modifier.apply(this.stringPropModifier.getModifier(prop));
        }
        this.operatingProps.remove(prop);
        return (T)modifier.compute();
    }

    public static DefaultVehicleData getDefault(String id) {
        boolean isDefault = !VehicleDataTool.vehicleData.containsKey(id);
        DefaultVehicleData data = VehicleDataTool.vehicleData.getOrDefault(id, new DefaultVehicleData());
        data.isDefaultData = isDefault;
        return data;
    }

    @Override
    public DefaultVehicleData getDefault() {
        return VehicleData.getDefault(this.id);
    }

    public static DefaultVehicleData getDefault(VehicleEntity entity) {
        return VehicleData.getDefault(entity.m_6095_());
    }

    public static DefaultVehicleData getDefault(EntityType<?> type) {
        return VehicleData.getDefault(VehicleData.getRegistryId(type));
    }

    public static String getRegistryId(EntityType<?> type) {
        return EntityType.m_20613_(type).toString();
    }

    public static VehicleData from(VehicleEntity entity) {
        return (VehicleData)dataCache.getUnchecked((Object)entity);
    }

    public boolean canRepairManually() {
        String material = this.get(VehicleProp.REPAIR_MATERIAL);
        if (material == null) {
            return false;
        }
        if (material.startsWith("#")) {
            material = material.substring(1);
        }
        return ResourceLocation.m_135820_((String)material) != null;
    }

    public boolean isRepairMaterial(ItemStack stack) {
        String material = this.get(VehicleProp.REPAIR_MATERIAL);
        boolean useTag = false;
        if (material.startsWith("#")) {
            material = material.substring(1);
            useTag = true;
        }
        ResourceLocation location = Objects.requireNonNull(ResourceLocation.m_135820_((String)material));
        if (!useTag) {
            return stack.m_41720_() == ForgeRegistries.ITEMS.getValue(location);
        }
        return stack.m_204117_(ItemTags.create((ResourceLocation)location));
    }

    public DamageModifier damageModifier() {
        DamageModifier modifier = new DamageModifier();
        if (this.get(VehicleProp.APPLY_DEFAULT_DAMAGE_MODIFIERS).booleanValue()) {
            modifier.addAll(DamageModifier.createDefaultModifier().toList());
            modifier.reduce(5.0f, ModDamageTypes.VEHICLE_STRIKE);
        }
        return modifier.addAll(this.get(VehicleProp.DAMAGE_MODIFIERS));
    }
}

