/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.MineEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ClaymoreEntity
extends Entity
implements GeoEntity,
OwnableEntity,
MineEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().multiply(0.2f, ModDamageTypes.CUSTOM_EXPLOSION).multiply(0.2f, ModDamageTypes.MINE).multiply(0.2f, ModDamageTypes.PROJECTILE_EXPLOSION);

    public ClaymoreEntity(EntityType<ClaymoreEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public ClaymoreEntity(LivingEntity owner, Level level) {
        this((EntityType<ClaymoreEntity>)((EntityType)ModEntities.CLAYMORE.get()), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(10.0f));
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Level level;
        amount = DAMAGE_MODIFIER.compute(source, amount);
        if (source.m_7639_() != null) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)source.m_7639_().m_20149_());
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 2, 0.02, 0.02, 0.02, 0.1, false);
        }
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("LastAttacker")) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        }
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.CLAYMORE_MINE.get()));
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (this.f_19797_ >= 12000 && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        if (this.f_19797_ >= 40) {
            Vec3 center = new Vec3(x + 1.5 * this.m_20154_().f_82479_, y + 1.5 * this.m_20154_().f_82480_, z + 1.5 * this.m_20154_().f_82481_);
            for (Entity target : level.m_6443_(Entity.class, new AABB(center, center).m_82400_(1.25), e -> true)) {
                Player player;
                boolean condition = this.m_269323_() != target && (target instanceof LivingEntity || target instanceof VehicleEntity) && !(target instanceof TargetEntity) && (!(target instanceof Player) || !(player = (Player)target).m_7500_() && !player.m_5833_()) && (this.m_269323_() != null && !this.m_269323_().m_7307_(target) || target.m_5647_() == null || target.m_5647_().m_5758_().equals("TDM")) && !target.m_6144_();
                if (!condition) continue;
                if (!level.m_5776_()) {
                    if (!this.m_9236_().m_5776_()) {
                        ParticleTool.spawnMediumExplosionParticles(this.m_9236_(), this.m_20182_());
                    }
                    this.m_146870_();
                }
                Mod.queueServerWork(1, () -> {
                    if (!level.m_5776_()) {
                        this.triggerExplode();
                    }
                });
                break;
            }
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            f = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.98, (double)f));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            this.destroy();
        }
        this.m_6210_();
    }

    public void destroy() {
        if (this.m_9236_() instanceof ServerLevel) {
            Entity attacker = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
            new CustomExplosion.Builder(attacker == null ? this : attacker).damage(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_DAMAGE.get()).floatValue() / 5.0f).radius(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_RADIUS.get()).intValue()).position(this.m_20182_()).causeVanillaExplosion().withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
            this.m_146870_();
        }
    }

    private void triggerExplode() {
        new CustomExplosion.Builder(this).attacker((Entity)this.m_269323_()).damage(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_DAMAGE.get()).intValue()).radius(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_RADIUS.get()).intValue()).causeVanillaExplosion().withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(0.5f);
    }

    public boolean m_6094_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

