/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber(modid="superbwarfare")
public class DPSGeneratorEntity
extends LivingEntity
implements GeoEntity {
    public static final EntityDataAccessor<Integer> DOWN_TIME = SynchedEntityData.m_135353_(DPSGeneratorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.m_135353_(DPSGeneratorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(DPSGeneratorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final SyncedEntityEnergyStorage energyStorage = new SyncedEntityEnergyStorage(5120, 0, 2560, this.f_19804_, ENERGY);
    protected final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private float damageDealt = 0.0f;

    public DPSGeneratorEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DPSGeneratorEntity>)((EntityType)ModEntities.DPS_GENERATOR.get()), world);
    }

    public DPSGeneratorEntity(EntityType<DPSGeneratorEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DOWN_TIME, (Object)0);
        this.f_19804_.m_135372_(ENERGY, (Object)0);
        this.f_19804_.m_135372_(LEVEL, (Object)0);
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return 1.57f;
    }

    public boolean m_142535_(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Energy", this.energyStorage.serializeNBT());
        pCompound.m_128405_("Level", ((Integer)this.f_19804_.m_135370_(LEVEL)).intValue());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        Tag tag = pCompound.m_128423_("Energy");
        if (tag instanceof IntTag) {
            IntTag energyNBT = (IntTag)tag;
            this.energyStorage.deserializeNBT((Tag)energyNBT);
        }
        this.f_19804_.m_135381_(LEVEL, (Object)pCompound.m_128451_("Level"));
        this.energyStorage.setCapacity(this.getMaxEnergy());
        this.energyStorage.setMaxExtract(this.getMaxTransfer());
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_286979_)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return super.m_6469_(source, amount);
        }
        this.damageDealt += amount;
        if ((double)this.m_21223_() < 0.01) {
            amount = 0.0f;
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        return super.m_6469_(source, (float)((double)amount / Math.pow(2.0, this.getGeneratorLevel())));
    }

    @SubscribeEvent
    public static void onTargetDown(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
            return;
        }
        Entity sourceEntity = event.getSource().m_7639_();
        if (entity instanceof DPSGeneratorEntity) {
            DPSGeneratorEntity generatorEntity = (DPSGeneratorEntity)entity;
            event.setCanceled(true);
            generatorEntity.m_21153_(1.0E-5f);
            if (sourceEntity == null) {
                return;
            }
            if (sourceEntity instanceof Player) {
                Player player = (Player)sourceEntity;
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.TARGET_DOWN.get(), 1.0f, 1.0f);
                generatorEntity.f_19804_.m_135381_(DOWN_TIME, (Object)40);
            }
        }
    }

    public boolean m_6087_() {
        return (Integer)this.f_19804_.m_135370_(DOWN_TIME) == 0;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.m_21205_().m_41619_() && !player.m_21205_().m_204117_(ModTags.Items.CROWBAR)) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                player.m_36356_(new ItemStack((ItemLike)ModItems.DPS_GENERATOR_DEPLOYER.get()));
            }
        } else {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(player.m_20185_(), this.m_20186_(), player.m_20189_()));
            this.m_146926_(0.0f);
            this.f_19860_ = this.m_146909_();
            this.f_19804_.m_135381_(DOWN_TIME, (Object)0);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        if ((Integer)this.f_19804_.m_135370_(DOWN_TIME) > 0) {
            this.f_19804_.m_135381_(DOWN_TIME, (Object)((Integer)this.f_19804_.m_135370_(DOWN_TIME) - 1));
        }
        if (this.f_19797_ % 20 == 0) {
            float damage = this.m_21233_() - this.m_21223_();
            LazyOptional<IEnergyStorage> entityCap = this.getEnergy();
            if (damage > 0.0f && entityCap.isPresent()) {
                Entity attacker;
                if (this.m_21225_() != null && (attacker = this.m_21225_().m_7639_()) instanceof Player) {
                    Player player = (Player)attacker;
                    if (!this.m_9236_().f_46443_) {
                        float displayDamage = this.m_21225_().m_276093_(ModDamageTypes.BEAST) ? Float.POSITIVE_INFINITY : this.damageDealt;
                        player.m_5661_((Component)Component.m_237110_((String)"tips.superbwarfare.dps_generator.dps", (Object[])new Object[]{FormatTool.format1DZ(displayDamage)}), true);
                    }
                }
                entityCap.ifPresent(cap -> {
                    if (cap instanceof SyncedEntityEnergyStorage) {
                        SyncedEntityEnergyStorage storage = (SyncedEntityEnergyStorage)((Object)cap);
                        storage.setMaxReceive(this.getMaxEnergy());
                        storage.receiveEnergy((int)Math.round(128.0 * (double)Math.max(this.getGeneratorLevel(), 1) * Math.pow(2.0, this.getGeneratorLevel()) * (double)damage), false);
                        storage.setMaxReceive(0);
                    }
                });
            }
            this.chargeBlockBelow();
            if ((double)this.m_21223_() < 0.01) {
                this.f_19804_.m_135381_(LEVEL, (Object)Math.min((Integer)this.f_19804_.m_135370_(LEVEL) + 1, 7));
                entityCap.ifPresent(cap -> {
                    if (cap instanceof SyncedEntityEnergyStorage) {
                        SyncedEntityEnergyStorage storage = (SyncedEntityEnergyStorage)((Object)cap);
                        storage.setCapacity(this.getMaxEnergy());
                        storage.setMaxExtract(this.getMaxTransfer());
                    }
                });
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_5594_(null, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (SoundEvent)ModSounds.DPS_GENERATOR_EVOLVE.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                } else {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.DPS_GENERATOR_EVOLVE.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                }
            }
            this.m_21153_(this.m_21233_());
            this.damageDealt = 0.0f;
        }
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean m_6094_() {
        return false;
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected void m_7324_(@NotNull Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        this.m_20242_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 100) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.DPS_GENERATOR_DEPLOYER.get()));
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private PlayState movementPredicate(AnimationState<DPSGeneratorEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(DOWN_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.target.down"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.target.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void chargeBlockBelow() {
        LazyOptional<IEnergyStorage> entityCap = this.getEnergy();
        if (!entityCap.isPresent()) {
            return;
        }
        entityCap.ifPresent(cap -> {
            if (!cap.canExtract() || cap.getEnergyStored() <= 0) {
                return;
            }
            BlockPos blockPos = this.m_20183_().m_7495_();
            BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
            if (blockEntity == null) {
                return;
            }
            blockEntity.getCapability(ForgeCapabilities.ENERGY, Direction.UP).ifPresent(blockCap -> {
                if (!blockCap.canReceive()) {
                    return;
                }
                int extract = cap.extractEnergy(cap.getEnergyStored(), true);
                int extracted = blockCap.receiveEnergy(extract, false);
                if (extracted <= 0) {
                    return;
                }
                this.m_9236_().m_151543_(blockPos);
                cap.extractEnergy(extracted, false);
            });
        });
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return ForgeCapabilities.ENERGY.orEmpty(cap, this.getEnergy());
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energy.invalidate();
    }

    public int getGeneratorLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    public int getMaxEnergy() {
        return switch (this.getGeneratorLevel()) {
            case 1 -> 25600;
            case 2 -> 102400;
            case 3 -> 409600;
            case 4 -> 0x190000;
            case 5 -> 0x640000;
            case 6 -> 0x1900000;
            case 7 -> 0x6400000;
            default -> 5120;
        };
    }

    public int getMaxTransfer() {
        return this.getMaxEnergy() / 2;
    }

    public void beastCharge() {
        if ((Integer)this.f_19804_.m_135370_(LEVEL) < 7) {
            this.f_19804_.m_135381_(LEVEL, (Object)7);
            this.getEnergy().ifPresent(cap -> {
                if (cap instanceof SyncedEntityEnergyStorage) {
                    SyncedEntityEnergyStorage storage = (SyncedEntityEnergyStorage)((Object)cap);
                    storage.setCapacity(this.getMaxEnergy());
                    storage.setMaxExtract(this.getMaxTransfer());
                    storage.setEnergy(this.getMaxEnergy());
                }
            });
        }
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.DPS_GENERATOR_DEPLOYER.get());
    }
}

