/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Agm65Entity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Agm65Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(Agm65Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier();
    private float damage = ((Integer)ExplosionConfig.AGM_65_DAMAGE.get()).intValue();
    private float explosionDamage = ((Integer)ExplosionConfig.AGM_65_EXPLOSION_DAMAGE.get()).intValue();
    private float explosionRadius = ((Double)ExplosionConfig.AGM_65_EXPLOSION_RADIUS.get()).floatValue();
    private boolean distracted = false;
    private int durability;
    public float gravity = 0.15f;

    public Agm65Entity(EntityType<? extends Agm65Entity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
        this.durability = 25;
    }

    public Agm65Entity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.AGM_65.get()), (Entity)entity, level);
        this.f_19811_ = true;
        this.durability = 25;
    }

    public void setTargetUuid(String uuid) {
        this.f_19804_.m_135381_(TARGET_UUID, (Object)uuid);
    }

    public Agm65Entity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends Agm65Entity>)((EntityType)ModEntities.AGM_65.get()), level);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.AGM.get();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(30.0f));
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("Damage")) {
            this.damage = compound.m_128457_("Damage");
        }
        if (compound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = compound.m_128457_("ExplosionDamage");
        }
        if (compound.m_128441_("Radius")) {
            this.explosionRadius = compound.m_128457_("Radius");
        }
        if (compound.m_128441_("Durability")) {
            this.durability = compound.m_128451_("Durability");
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128350_("Damage", this.damage);
        compound.m_128350_("ExplosionDamage", this.explosionDamage);
        compound.m_128350_("Radius", this.explosionRadius);
        compound.m_128405_("Durability", this.durability);
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.causeExplode(result.m_82450_());
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((Agm65Entity)this).m_146870_());
                    }
                    this.m_9236_().m_46961_(resultPos, true);
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    @Override
    public void causeExplode(Vec3 vec3) {
        new CustomExplosion.Builder((Entity)this).attacker(this.m_19749_()).damage(this.explosionDamage).radius(this.explosionRadius).position(vec3).causeVanillaExplosion().withParticleType(ParticleTool.ParticleType.HUGE).explode();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1) {
                double l = this.m_20184_().m_82553_();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 startPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
                    Vec3 pos = startPos.m_82549_(this.m_20184_().m_82541_().m_82490_(-i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.001, true);
                }
            }
        }
        Entity entity = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, this.m_9236_(), 32.0, 90.0);
        for (Entity e : decoy) {
            if (!e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || this.distracted) continue;
            this.f_19804_.m_135381_(TARGET_UUID, (Object)e.m_20149_());
            this.distracted = true;
            break;
        }
        if (!((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none") && entity != null && entity.m_9236_() instanceof ServerLevel) {
            if ((!entity.m_20197_().isEmpty() || entity instanceof VehicleEntity) && entity.f_19797_ % (int)Math.max((double)(0.04 * (double)this.m_20270_(entity)), (double)2.0) == 0) {
                entity.m_9236_().m_5594_(null, entity.m_20097_(), entity instanceof Pig ? SoundEvents.f_12235_ : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            Vec3 targetPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)(entity instanceof EnderDragon ? -2 : 0) + 0.1 * (double)this.m_20270_(entity), entity.m_20189_());
            Vec3 toVec = this.m_146892_().m_82505_(targetPos).m_82541_();
            if (this.f_19797_ > 8) {
                boolean lostTarget;
                boolean bl = lostTarget = VectorTool.calculateAngle(this.m_20184_(), toVec) > 80.0;
                if (!lostTarget) {
                    this.m_20256_(this.m_20184_().m_82549_(toVec.m_82490_(4.0)).m_82490_(0.65).m_82549_(entity.m_20184_().m_82490_(0.2)));
                }
            }
        }
        if (this.f_19797_ == 8) {
            Level level2;
            this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_()), (SoundEvent)ModSounds.MISSILE_START.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && (level2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.f_19854_, this.f_19855_, this.f_19856_, 15, 0.8, 0.8, 0.8, 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.f_19854_, this.f_19855_, this.f_19856_, 10, 0.8, 0.8, 0.8, 0.01, true);
            }
        }
        if (this.f_19797_ > 8) {
            this.m_20256_(this.m_20184_().m_82542_(1.06, 1.06, 1.06));
        }
        if (this.f_19797_ > 600 || this.m_20069_() || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            if (this.m_9236_() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode(this, ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), (Entity)this, this.explosionDamage, this.explosionRadius, 1.0f);
            }
            this.m_146870_();
        }
        float f = (float)Mth.m_14008_((double)(1.0 - 0.005 * this.m_20184_().m_82553_()), (double)0.001, (double)1.0);
        this.m_20256_(this.m_20184_().m_82542_((double)f, (double)f, (double)f));
        this.destroyBlock();
    }

    public boolean m_20068_() {
        return true;
    }

    private PlayState movementPredicate(AnimationState<Agm65Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    public float m_7139_() {
        return this.f_19797_ > 8 ? 0.0f : this.gravity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSounds.ROCKET_ENGINE.get();
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

