/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.ChunkLoadManager;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class FastThrowableProjectile
extends ThrowableItemProjectile
implements CustomSyncMotionEntity,
IEntityAdditionalSpawnData {
    public static Consumer<FastThrowableProjectile> flySound = projectile -> {};
    public static Consumer<FastThrowableProjectile> nearFlySound = projectile -> {};
    private static final int CHUNK_RADIUS = 1;
    public int durability = 50;
    public boolean firstHit = true;
    private boolean isFastMoving = false;
    private final Set<ChunkPos> currentChunks = new HashSet<ChunkPos>();
    private ChunkPos lastChunkPos;

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable Entity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_5602_(pShooter);
        if (pShooter != null) {
            this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        }
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.isFastMoving && this.isFastMoving() && this.m_9236_().f_46443_) {
            flySound.accept(this);
            nearFlySound.accept(this);
        }
        this.isFastMoving = this.isFastMoving();
        Vec3 vec3 = this.m_20184_();
        float friction = this.m_20069_() ? 0.8f : 0.99f;
        vec3 = vec3.m_82520_(0.0, (double)this.m_7139_(), 0.0);
        this.m_20256_(vec3.m_82490_((double)(1.0f / friction)));
        Vec3 vec31 = this.m_20184_();
        this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)this.m_7139_(), vec31.f_82481_);
        this.syncMotion();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.forceLoadChunk()) {
                this.updateChunkLoading(serverLevel);
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        MinecraftForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitEntity(this.m_19749_(), (Projectile)this, pResult.m_82443_(), pResult.m_82450_()));
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        MinecraftForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitBlock(pResult.m_82425_(), this.m_9236_().m_8055_(pResult.m_82425_()), pResult.m_82434_(), this.m_19749_(), (Projectile)this, pResult.m_82450_()));
    }

    public void destroyBlock() {
        if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
            Vec3 posO = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
            List<BlockPos> blockList = TraceTool.getBlocksAlongRay(posO, this.m_20184_(), this.m_20184_().m_82553_());
            for (BlockPos pos : blockList) {
                BlockState blockState = this.m_9236_().m_8055_(pos);
                if (blockState.m_60713_(Blocks.f_50016_)) continue;
                float hardness = this.m_9236_().m_8055_(pos).m_60734_().m_155943_();
                double resistance = 1.0 - Mth.m_14008_((double)(hardness / 100.0f), (double)0.0, (double)0.8);
                this.m_20256_(this.m_20184_().m_82542_(resistance, resistance, resistance));
                if (blockState.m_60815_()) {
                    this.durability -= 10 + (int)(0.5 * (double)hardness);
                }
                if (hardness <= (float)this.durability && hardness != -1.0f) {
                    this.m_9236_().m_46961_(pos, true);
                }
                if (hardness != -1.0f && !(hardness > (float)this.durability) && this.durability > 0) continue;
                this.causeExplode(pos.m_252807_());
                this.m_146870_();
                break;
            }
        }
    }

    public void causeExplode(Vec3 vec3) {
    }

    private void updateChunkLoading(ServerLevel serverLevel) {
        ChunkPos currentPos = new ChunkPos(this.m_20183_());
        if (this.lastChunkPos != null && this.lastChunkPos.equals((Object)currentPos)) {
            return;
        }
        HashSet<ChunkPos> neededChunks = new HashSet<ChunkPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                neededChunks.add(new ChunkPos(currentPos.f_45578_ + x, currentPos.f_45579_ + z));
            }
        }
        HashSet<ChunkPos> toRelease = new HashSet<ChunkPos>(this.currentChunks);
        toRelease.removeAll(neededChunks);
        for (ChunkPos pos : toRelease) {
            ChunkLoadManager.releaseChunk(serverLevel, pos);
            this.currentChunks.remove(pos);
        }
        for (ChunkPos pos : neededChunks) {
            if (this.currentChunks.contains(pos)) continue;
            ChunkLoadManager.forceChunk(serverLevel, pos);
            this.currentChunks.add(pos);
        }
        this.lastChunkPos = currentPos;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Object object;
        if (!this.m_9236_().f_46443_ && (object = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (ChunkPos pos : this.currentChunks) {
                ChunkLoadManager.releaseChunk(serverLevel, pos);
            }
            this.currentChunks.clear();
        }
        super.m_142687_(reason);
    }

    @Override
    public void syncMotion() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.shouldSyncMotion()) {
            return;
        }
        if (this.f_19797_ % this.m_6095_().m_20682_() == 0) {
            Mod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new ClientMotionSyncMessage((Entity)this));
        }
    }

    public boolean isFastMoving() {
        return this.m_20184_().m_82553_() >= 0.5;
    }

    public boolean shouldSyncMotion() {
        return false;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Vec3 motion = this.m_20184_();
        buffer.writeFloat((float)motion.f_82479_);
        buffer.writeFloat((float)motion.f_82480_);
        buffer.writeFloat((float)motion.f_82481_);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_20334_(additionalData.readFloat(), additionalData.readFloat(), additionalData.readFloat());
    }

    @NotNull
    public SoundEvent getCloseSound() {
        return SoundEvents.f_271165_;
    }

    @NotNull
    public SoundEvent getSound() {
        return SoundEvents.f_271165_;
    }

    public float getVolume() {
        return 0.5f;
    }

    public boolean forceLoadChunk() {
        return false;
    }
}

