/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.MineEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PtkmProjectileEntity
extends FastThrowableProjectile
implements ExplosiveProjectile,
GeoEntity,
MineEntity {
    private float damage = 500.0f;
    private float explosionDamage = 80.0f;
    private float explosionRadius = 7.0f;
    private float gravity = 0.05f;
    private int shootTime = 3;
    private Entity target = null;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PtkmProjectileEntity(EntityType<? extends PtkmProjectileEntity> type, Level world) {
        super(type, world);
    }

    public PtkmProjectileEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.PTKM_PROJECTILE.get()), (Entity)entity, level);
    }

    public PtkmProjectileEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends PtkmProjectileEntity>)((EntityType)ModEntities.PTKM_PROJECTILE.get()), level);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.PTKM_1R.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity;
            Entity entity2 = entityHitResult.m_82443_();
            if (this.m_19749_() != null && entity2 == this.m_19749_().m_20202_()) {
                return;
            }
            if (this.target != null && this.f_19797_ > this.shootTime) {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            } else {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), 20.0f);
            }
            if (entity2 instanceof LivingEntity) {
                entity2.f_19802_ = 0;
            }
            if ((entity = this.m_19749_()) instanceof LivingEntity && !(living = (LivingEntity)entity).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            this.explode(entityHitResult.m_82450_());
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            this.explode(blockHitResult.m_82450_());
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 0) {
                double l = this.m_20184_().m_82553_();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82541_().m_82490_(-i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.001, true);
                }
            }
        }
        if (this.target != null) {
            if (this.f_19797_ == this.shootTime) {
                Vec3 targetVel = this.target.m_20184_();
                Vec3 targetVec = RangeTool.calculateFiringSolution(this.m_20182_(), this.target.m_20191_().m_82399_(), targetVel, 15.0, 0.05);
                this.m_20256_(targetVec.m_82490_(15.0));
                Level i = this.m_9236_();
                if (i instanceof ServerLevel) {
                    float i2;
                    ServerLevel serverLevel = (ServerLevel)i;
                    serverLevel.m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_()), (SoundEvent)ModSounds.EXPLOSION_AIR.get(), SoundSource.BLOCKS, 8.0f, 1.0f);
                    ParticleTool.spawnSmallExplosionParticles((Level)serverLevel, this.m_20182_());
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123755_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 40, 0.5, 0.25, 0.5, 0.01, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 30, 0.5, 0.25, 0.5, 0.005, true);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 55, 3.25, serverLevel, ParticleTypes.f_123777_);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 50, 3.0, serverLevel, ParticleTypes.f_123777_);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 45, 2.75, serverLevel, ParticleTypes.f_123777_);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 40, 2.5, serverLevel, ParticleTypes.f_123777_);
                    int count = 8;
                    for (i2 = 0.0f; i2 < this.m_20270_(this.target); i2 += 0.5f) {
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.m_20182_().f_82479_ + (double)i2 * this.m_20184_().m_82541_().f_82479_, this.m_20182_().f_82480_ + (double)i2 * this.m_20184_().m_82541_().f_82480_, this.m_20182_().f_82481_ + (double)i2 * this.m_20184_().m_82541_().f_82481_, Mth.m_14045_((int)count--, (int)2, (int)8), 0.25, 0.25, 0.25, 0.0025, true);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123744_, this.m_20182_().f_82479_ + (double)i2 * this.m_20184_().m_82541_().f_82479_, this.m_20182_().f_82480_ + (double)i2 * this.m_20184_().m_82541_().f_82480_, this.m_20182_().f_82481_ + (double)i2 * this.m_20184_().m_82541_().f_82481_, Mth.m_14045_((int)count--, (int)2, (int)8), 0.25, 0.25, 0.25, 0.0025, true);
                    }
                    for (i2 = 0.0f; i2 < 16.0f; i2 += 0.5f) {
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.m_20182_().f_82479_ + (double)i2 * this.m_20184_().m_82490_((double)-1.0).m_82541_().f_82479_, this.m_20182_().f_82480_ + (double)i2 * this.m_20184_().m_82490_((double)-1.0).m_82541_().f_82480_, this.m_20182_().f_82481_ + (double)i2 * this.m_20184_().m_82490_((double)-1.0).m_82541_().f_82481_, Mth.m_14045_((int)count--, (int)2, (int)8), 0.25, 0.25, 0.25, 0.0025, true);
                    }
                }
            }
        } else if (this.f_19797_ > 100) {
            this.explode(this.m_20182_());
        }
    }

    public void explode(Vec3 pos) {
        new CustomExplosion.Builder((Entity)this).damageSource(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_())).damage(this.explosionDamage).radius(this.explosionRadius).position(pos).withParticleType(ParticleTool.ParticleType.MEDIUM).particlePosition(pos).explode();
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public void setShootTime(int time) {
        this.shootTime = time;
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public float m_7139_() {
        return this.gravity;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void spawnDirectionalParticles(Entity projectile, int count, double radius, ServerLevel level, SimpleParticleType particle) {
        Vec3 deltaMovement = projectile.m_20184_();
        Vec3 direction = deltaMovement.m_82541_();
        Vec3 position = projectile.m_20182_();
        Vec3 randomPerp = PtkmProjectileEntity.getRandomPerpendicular(direction);
        Vec3 u = randomPerp.m_82541_();
        Vec3 v = direction.m_82537_(u).m_82541_();
        PtkmProjectileEntity.spawnCircularParticles(level, position, u, v, count, radius, particle);
    }

    private static Vec3 getRandomPerpendicular(Vec3 dir) {
        Vec3 candidate1 = new Vec3(dir.f_82480_, -dir.f_82479_, 0.0);
        if (candidate1.m_82556_() > 1.0E-4) {
            return candidate1;
        }
        return new Vec3(0.0, dir.f_82481_, -dir.f_82480_);
    }

    private static void spawnCircularParticles(ServerLevel level, Vec3 center, Vec3 u, Vec3 v, int count, double radius, SimpleParticleType particle) {
        for (int i = 0; i < count; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)count;
            double xOffset = radius * (Math.cos(theta) * u.f_82479_ + Math.sin(theta) * v.f_82479_);
            double yOffset = radius * (Math.cos(theta) * u.f_82480_ + Math.sin(theta) * v.f_82480_);
            double zOffset = radius * (Math.cos(theta) * u.f_82481_ + Math.sin(theta) * v.f_82481_);
            Vec3 pos = center.m_82520_(xOffset, yOffset, zOffset);
            PtkmProjectileEntity.spawnParticle(level, pos, particle);
        }
    }

    private static void spawnParticle(ServerLevel level, Vec3 pos, SimpleParticleType particle) {
        ParticleTool.sendParticle(level, particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.02, 0.02, 0.02, 1.0E-4, true);
    }
}

