/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RgoGrenadeEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private float explosionDamage = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_DAMAGE.get()).intValue();
    private float explosionRadius = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_RADIUS.get()).intValue();
    private int fuse = 80;
    private float gravity = 0.07f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RgoGrenadeEntity(EntityType<? extends RgoGrenadeEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public RgoGrenadeEntity(EntityType<? extends RgoGrenadeEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.f_19811_ = true;
    }

    public RgoGrenadeEntity(LivingEntity entity, Level level, int fuse) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.RGO_GRENADE.get()), (Entity)entity, level);
        this.f_19811_ = true;
        this.fuse = fuse;
    }

    public RgoGrenadeEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends RgoGrenadeEntity>)((EntityType)ModEntities.RGO_GRENADE.get()), level);
        this.f_19811_ = true;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExplosionDamage", this.explosionDamage);
        pCompound.m_128350_("Radius", this.explosionRadius);
        pCompound.m_128350_("Fuse", (float)this.fuse);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = pCompound.m_128457_("ExplosionDamage");
        }
        if (pCompound.m_128441_("Radius")) {
            this.explosionRadius = pCompound.m_128457_("Radius");
        }
        if (pCompound.m_128441_("Fuse")) {
            this.fuse = pCompound.m_128451_("Fuse");
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.RGO_GRENADE.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    protected void m_6532_(@NotNull HitResult result) {
        if (this.m_9236_() instanceof ServerLevel) {
            switch (result.m_6662_()) {
                case BLOCK: {
                    BlockHitResult blockResult = (BlockHitResult)result;
                    BlockPos resultPos = blockResult.m_82425_();
                    BlockState state = this.m_9236_().m_8055_(resultPos);
                    Block block = state.m_60734_();
                    if (block instanceof BellBlock) {
                        BellBlock bell = (BellBlock)block;
                        bell.m_49712_(this.m_9236_(), resultPos, blockResult.m_82434_());
                    }
                    ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
                    break;
                }
                case ENTITY: {
                    LivingEntity living;
                    EntityHitResult entityResult = (EntityHitResult)result;
                    Entity entity = entityResult.m_82443_();
                    if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
                        return;
                    }
                    Entity entity2 = this.m_19749_();
                    if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)living;
                        living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                        Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
                    }
                    if (entity instanceof DroneEntity) break;
                    ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
                    break;
                }
            }
        }
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        --this.fuse;
        if (this.fuse <= 0) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
            }
        }
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, this.f_19854_, this.f_19855_, this.f_19856_, 1, 0.0, 0.0, 0.0, 0.01, true);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void setDamage(float damage) {
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

