/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallRocketEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallRocketWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Ah6Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
HelicopterEntity,
WeaponVehicleEntity,
OBBEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Float> PROPELLER_ROT = SynchedEntityData.m_135353_(Ah6Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> LOADED_ROCKET = SynchedEntityData.m_135353_(Ah6Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean engineStart;
    public boolean engineStartOver;
    public double velocity;
    public int fireIndex;
    public int holdTick;
    public int holdPowerTick;
    public float destroyRot;
    public float delta_x;
    public float delta_y;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.0625f, 1.18125f, 1.625f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.875f, 0.6875f, 0.59375f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.3125f, 2.25f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.0625f, 1.15625f, 0.40625f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.0f, 0.25f, 0.21875f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb6 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.3125f, 0.40625f, 0.84375f), new Quaternionf(), OBB.Part.ENGINE1);
    public OBB obb7 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.3125f, 0.40625f, 0.40625f), new Quaternionf(), OBB.Part.ENGINE2);

    public Ah6Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Ah6Entity>)((EntityType)ModEntities.AH_6.get()), world);
    }

    public Ah6Entity(EntityType<Ah6Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().blockInteraction((Boolean)VehicleConfig.AH_6_CANNON_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).damage(((Double)VehicleConfig.AH_6_CANNON_DAMAGE.get()).floatValue()).explosionDamage(((Double)VehicleConfig.AH_6_CANNON_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Double)VehicleConfig.AH_6_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_20mm.png")).sound1p((SoundEvent)ModSounds.HELICOPTER_CANNON_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.HELICOPTER_CANNON_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.HELICOPTER_CANNON_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.HELICOPTER_CANNON_VERYFAR.get()), new SmallRocketWeapon().damage(((Double)VehicleConfig.AH_6_ROCKET_DAMAGE.get()).floatValue()).explosionDamage(((Double)VehicleConfig.AH_6_ROCKET_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Double)VehicleConfig.AH_6_ROCKET_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.SMALL_ROCKET_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.SMALL_ROCKET_FIRE_3P.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(7.0, 1.0, -2.7);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOADED_ROCKET, (Object)0);
        this.f_19804_.m_135372_(PROPELLER_ROT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedRocket", ((Integer)this.f_19804_.m_135370_(LOADED_ROCKET)).intValue());
        compound.m_128350_("PropellerRot", ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_ROCKET, (Object)compound.m_128451_("LoadedRocket"));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(compound.m_128457_("PropellerRot")));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> {
            Entity entity = source.m_7640_();
            if (entity != null && entity.m_6095_().m_204039_(ModTags.EntityTypes.AERIAL_BOMB)) {
                damage = Float.valueOf(damage.floatValue() * 2.0f);
            }
            damage = Float.valueOf(damage.floatValue() * (this.getHealth() > 0.1f ? 0.7f : 0.05f));
            return damage;
        });
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == ModItems.SMALL_ROCKET.get() && (Integer)this.f_19804_.m_135370_(LOADED_ROCKET) < 14) {
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.f_19804_.m_135370_(LOADED_ROCKET) + 1));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.updateOBB();
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.8, 1.0, 0.8));
        } else {
            this.setZRot(this.getRoll() * (this.backInputDown ? 0.9f : 0.99f));
            float f = (float)Mth.m_14008_((double)((double)0.95f - 0.015 * this.m_20184_().m_82553_() + (double)(0.02f * Mth.m_14154_((float)(90.0f - (float)Ah6Entity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((this.m_146909_() < 0.0f ? -0.035 : (this.m_146909_() > 0.0f ? 0.035 : 0.0)) * this.m_20184_().m_82553_())));
            this.m_20256_(this.m_20184_().m_82542_((double)f, 0.95, (double)f));
        }
        if (this.m_20069_() && this.f_19797_ % 4 == 0 && Ah6Entity.getSubmergedHeight(this) > 0.5 * (double)this.m_20206_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, this.m_146895_() == null ? this : this.m_146895_()), 6.0f + (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        this.releaseDecoy();
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 2.7f);
        this.m_6210_();
    }

    private void handleAmmo() {
        Entity entity = this.m_146895_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int ammoCount = this.m_18947_((Item)ModItems.SMALL_SHELL.get());
        if ((this.hasItem((Item)ModItems.SMALL_ROCKET.get()) || InventoryTool.hasCreativeAmmoBox((Entity)player)) && this.reloadCoolDown == 0 && (Integer)this.m_20088_().m_135370_(LOADED_ROCKET) < 14) {
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.m_20088_().m_135370_(LOADED_ROCKET) + 1));
            this.reloadCoolDown = 25;
            if (!InventoryTool.hasCreativeAmmoBox((Entity)player)) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_ROCKET.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)ammoCount);
        } else {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_ROCKET)));
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.m_146895_();
        Entity passenger2 = this.getNthEntity(1);
        Entity passenger3 = this.getNthEntity(2);
        Entity passenger4 = this.getNthEntity(3);
        if (this.getHealth() > 0.1f * this.getMaxHealth()) {
            if (passenger == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.upInputDown = false;
                this.downInputDown = false;
                this.setZRot(this.roll * 0.98f);
                this.m_146926_(this.m_146909_() * 0.98f);
                if (passenger2 == null && passenger3 == null && passenger4 == null) {
                    this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.99f));
                }
            } else if (passenger instanceof Player) {
                if (this.rightInputDown) {
                    ++this.holdTick;
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 2.0f * (float)Math.min((int)this.holdTick, (int)7) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
                } else if (this.leftInputDown) {
                    ++this.holdTick;
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 2.0f * (float)Math.min((int)this.holdTick, (int)7) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
                } else {
                    this.holdTick = 0;
                }
                this.delta_x = (this.m_20096_() ? 0.0f : 1.5f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue();
                this.delta_y = Mth.m_14036_((float)((this.m_20096_() ? 0.1f : 2.0f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() + (float)((Boolean)this.f_19804_.m_135370_(ENGINE2_DAMAGED) != false ? 25 : 0) * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue()), (float)-10.0f, (float)10.0f);
                this.m_146922_(this.m_146908_() + this.delta_y);
                this.m_146926_(this.m_146909_() + this.delta_x);
                this.setZRot(this.getRoll() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + (this.m_20096_() ? 0.0f : 0.25f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            }
            if (this.m_9236_() instanceof ServerLevel) {
                if (this.getEnergy() > 0) {
                    boolean up = this.upInputDown || this.forwardInputDown;
                    boolean down = this.downInputDown;
                    if (!this.engineStart && up) {
                        this.engineStart = true;
                        this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.HELICOPTER_ENGINE_START.get(), this.m_5720_(), 3.0f, 1.0f);
                    }
                    if (up && this.engineStartOver) {
                        ++this.holdPowerTick;
                        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 7.0E-4f * (float)Math.min((int)this.holdPowerTick, (int)10)), (float)0.12f)));
                    }
                    if (this.engineStartOver) {
                        if (down) {
                            ++this.holdPowerTick;
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.025f))));
                        } else if (this.backInputDown) {
                            ++this.holdPowerTick;
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.052f))));
                            if (passenger != null) {
                                passenger.m_146926_(0.8f * passenger.m_146909_());
                            }
                        }
                    }
                    if (this.engineStart && !this.engineStartOver) {
                        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.0012f), (float)0.045f)));
                    }
                    if (!up && !down && !this.backInputDown && this.engineStartOver) {
                        if (this.m_20184_().m_7098_() < 0.0) {
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 2.0E-4f), (float)0.12f)));
                        } else {
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (this.m_20096_() ? 5.0E-5f : 2.0E-4f)), (float)0.0f)));
                        }
                        this.holdPowerTick = 0;
                    }
                } else {
                    this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 1.0E-4f), (float)0.0f)));
                    this.forwardInputDown = false;
                    this.backInputDown = false;
                    this.engineStart = false;
                    this.engineStartOver = false;
                }
            }
        } else if (!this.m_20096_() && this.engineStartOver) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 3.0E-4f), (float)0.01f)));
            this.destroyRot += 0.08f;
            float diffX = 45.0f - this.m_146909_();
            float diffZ = -20.0f - this.getRoll();
            this.m_146926_(this.m_146909_() + diffX * 0.05f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            this.m_146922_(this.m_146908_() + this.destroyRot);
            this.setZRot(this.getRoll() + diffZ * 0.1f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-this.destroyRot) * 0.004, 0.0));
        }
        if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.98f));
        }
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.9f));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(Mth.m_14179_((float)0.18f, (float)((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue(), (float)((Float)this.f_19804_.m_135370_(POWER)).floatValue())));
        this.setPropellerRot(this.getPropellerRot() + 30.0f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * 0.9995f));
        if (this.engineStart) {
            this.consumeEnergy((int)((double)((Integer)VehicleConfig.AH_6_MIN_ENERGY_COST.get()).intValue() + (double)((Float)this.f_19804_.m_135370_(POWER)).floatValue() * ((double)((Integer)VehicleConfig.AH_6_MAX_ENERGY_COST.get() - (Integer)VehicleConfig.AH_6_MIN_ENERGY_COST.get()) / 0.12)));
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f force0 = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f force1 = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        Vec3 force = new Vec3((double)force0.x, (double)force0.y, (double)force0.z).m_82505_(new Vec3((double)force1.x, (double)force1.y, (double)force1.z));
        this.m_20256_(this.m_20184_().m_82549_(force.m_82490_((double)((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue())));
        if (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.04f) {
            this.engineStartOver = true;
        }
        if (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 4.0E-4f) {
            this.engineStart = false;
            this.engineStartOver = false;
        }
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.HELICOPTER_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * 2.0f;
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-80.0f, (float)80.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)-80.0f, (float)80.0f);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-80.0f, (float)80.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(2)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)10.0f, (float)170.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_() + 90.0f);
        } else if (entity == this.getNthEntity(3)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-170.0f, (float)-10.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_() - 90.0f);
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.45f;
        float y = -0.25f;
        float z = 1.0f;
        y += (float)passenger.m_6049_();
        int i = this.getOrderedPassengers().indexOf(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 1) {
            Vector4f worldPosition = this.transformPosition(transform, -x, y, z);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 2) {
            Vector4f worldPosition = this.transformPosition(transform, -1.4f, -1.05f, 0.0f);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 3) {
            Vector4f worldPosition = this.transformPosition(transform, 1.4f, -1.05f, 0.0f);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.m_146895_()) {
            passenger.m_146926_(passenger.m_146909_() + (this.m_146909_() - this.f_19860_));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5616_(entity.m_6080_() + this.delta_y);
            entity.m_146922_(entity.m_146908_() + this.delta_y);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
            entity.f_19859_ += g - f;
            entity.m_146922_(entity.m_146908_() + g - f + 0.9f * this.destroyRot);
            entity.m_5616_(entity.m_146908_());
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(2)) {
            float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float g = Mth.m_14036_((float)f, (float)10.0f, (float)170.0f);
            entity.f_19859_ += g - f;
            entity.m_146922_(entity.m_146908_() + g - f + 0.9f * this.destroyRot);
            entity.m_5616_(entity.m_146908_());
            entity.m_5618_(this.m_146908_() + 90.0f);
        } else if (entity == this.getNthEntity(3)) {
            float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float g = Mth.m_14036_((float)f, (float)-170.0f, (float)-10.0f);
            entity.f_19859_ += g - f;
            entity.m_146922_(entity.m_146908_() + g - f + 0.9f * this.destroyRot);
            entity.m_5616_(entity.m_146908_());
            entity.m_5618_(this.m_146908_() - 90.0f);
        }
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)1.45f), (double)(this.m_20186_() + (double)1.45f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public Vec3 shootPos(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, -0.83f, 0.8f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 shootVec(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.01f, 1.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).m_82505_(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).m_82541_();
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            Vector4f worldPosition2;
            Vector4f worldPosition;
            if (this.cannotFire) {
                return;
            }
            if (this.fireIndex == 0) {
                worldPosition = this.transformPosition(transform, 1.15f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, 1.157f, -0.81799996f, 1.8f);
                this.fireIndex = 1;
            } else {
                worldPosition = this.transformPosition(transform, -1.15f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, -1.139f, -0.81799996f, 1.8f);
                this.fireIndex = 0;
            }
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).m_82505_(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).m_82541_();
            if ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || hasCreativeAmmo) {
                SmallCannonShellEntity entityToSpawn = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
                entityToSpawn.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
                entityToSpawn.m_6686_(shootVec.f_82479_, shootVec.f_82480_, shootVec.f_82481_, 20.0f, 0.15f);
                this.m_9236_().m_7967_((Entity)entityToSpawn);
                ParticleTool.sendParticle((ServerLevel)this.m_9236_(), ParticleTypes.f_123755_, worldPosition.x, worldPosition.y, worldPosition.z, 1, 0.0, 0.0, 0.0, 0.0, false);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                        if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                            return Ammo.HEAVY.get((ItemStack)stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.f_41583_);
                    if (!ammoBox.m_41619_()) {
                        Ammo.HEAVY.add(ammoBox, -1);
                    } else {
                        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                    }
                }
            }
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 4));
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 4, 12, 24);
            }
        } else if (this.getWeaponIndex(0) == 1 && (Integer)this.m_20088_().m_135370_(LOADED_ROCKET) > 0) {
            Vector4f worldPosition2;
            Vector4f worldPosition;
            SmallRocketEntity heliRocketEntity = ((SmallRocketWeapon)this.getWeapon(0)).create((LivingEntity)player);
            if (this.fireIndex == 0) {
                worldPosition = this.transformPosition(transform, 1.7f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, 1.7064999f, -0.81799996f, 1.8f);
                this.fireIndex = 1;
            } else {
                worldPosition = this.transformPosition(transform, -1.7f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, -1.6885f, -0.81799996f, 1.8f);
                this.fireIndex = 0;
            }
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).m_82505_(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).m_82541_();
            heliRocketEntity.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
            heliRocketEntity.m_6686_(shootVec.f_82479_, shootVec.f_82480_, shootVec.f_82481_, 7.0f, 0.25f);
            player.m_9236_().m_7967_((Entity)heliRocketEntity);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 6, 6, 6);
            }
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.m_20088_().m_135370_(LOADED_ROCKET) - 1));
            this.reloadCoolDown = 30;
        }
    }

    @Override
    public int mainGunRpm(Player player) {
        return 500;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(AMMO) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.f_19804_.m_135370_(HEAT);
    }

    @Override
    public float getRotX(float tickDelta) {
        return this.getPitch(tickDelta);
    }

    @Override
    public float getRotY(float tickDelta) {
        return this.getYaw(tickDelta);
    }

    @Override
    public float getRotZ(float tickDelta) {
        return this.getRoll(tickDelta);
    }

    @Override
    public float getPower() {
        return ((Float)this.f_19804_.m_135370_(POWER)).floatValue();
    }

    @Override
    public int getDecoy() {
        return (Integer)this.f_19804_.m_135370_(DECOY_COUNT);
    }

    @Override
    public int getMaxPassengers() {
        return 4;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/ah_6_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return seatIndex == 0 ? 0.0 : original;
    }

    @Override
    public double getMouseSensitivity() {
        return 0.25;
    }

    @Override
    public double getMouseSpeedX() {
        return 0.4;
    }

    @Override
    public double getMouseSpeedY() {
        return 0.25;
    }

    @Override
    @NotNull
    public Vec3 getDismountLocationForIndex(LivingEntity passenger, int index) {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = index == 0 ? this.transformPosition(transform, 2.0f, -0.25f, 1.0f) : (index == 1 ? this.transformPosition(transform, -2.0f, -0.25f, 1.0f) : (index == 2 ? this.transformPosition(transform, -2.0f, -0.25f, 0.0f) : this.transformPosition(transform, 2.0f, -0.25f, 0.0f)));
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        if (this.getSeatIndex(entity) == 2) {
            return Pair.of((Object)Axis.f_252529_.m_252977_(-this.getRoll(tickDelta)), (Object)Axis.f_252403_.m_252977_(this.m_5686_(tickDelta)));
        }
        if (this.getSeatIndex(entity) == 3) {
            return Pair.of((Object)Axis.f_252529_.m_252977_(this.getRoll(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.m_5686_(tickDelta)));
        }
        return Pair.of((Object)Axis.f_252529_.m_252977_(-this.m_5686_(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.getRoll(tickDelta)));
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)1.45f), (double)(this.m_20186_() + (double)1.45f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)((double)(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)((double)Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)((double)this.getRotY(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getRotX(partialTicks) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            Matrix4f transform = this.getClientVehicleTransform(partialTicks);
            Vector4f maxCameraPosition = this.transformPosition(transform, -2.1f, 1.0f, -10.0f - (float)ClientMouseHandler.custom3pDistanceLerp);
            Vec3 finalPos = CameraTool.getMaxZoom(transform, maxCameraPosition);
            if (isFirstPerson) {
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return finalPos;
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/aircraft.png");
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obb6, this.obb7);
    }

    @Override
    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.41874993f, -0.15625f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.049999952f, 1.90625f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition3 = this.transformPosition(transform, 0.0f, 0.86249995f, -4.1875f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition4 = this.transformPosition(transform, -0.125f, 0.89374995f, -6.34375f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition5 = this.transformPosition(transform, -0.125f, 2.1125f, -6.65625f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition6 = this.transformPosition(transform, 0.0f, 1.83125f, -0.53125f);
        this.obb6.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obb6.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition7 = this.transformPosition(transform, 0.1875f, 0.64374995f, -6.15625f);
        this.obb7.center().set((Vector3fc)new Vector3f(worldPosition7.x, worldPosition7.y, worldPosition7.z));
        this.obb7.setRotation(VectorTool.combineRotations(1.0f, this));
    }
}

