/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimable;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.DefenseEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hpj11Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
CannonEntity,
OwnableEntity,
AutoAimable,
DefenseEntity {
    public static Consumer<MobileVehicleEntity> fireSound = vehicle -> {};
    public static final EntityDataAccessor<Integer> ANIM_TIME = SynchedEntityData.m_135353_(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> GUN_ROTATE = SynchedEntityData.m_135353_(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.m_135353_(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasFiring = false;
    public int changeTargetTimer = 60;
    public float gunRot;
    public float gunRotO;

    public Hpj11Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Hpj11Entity>)((EntityType)ModEntities.HPJ_11.get()), world);
    }

    public Hpj11Entity(EntityType<Hpj11Entity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_TIME, (Object)0);
        this.f_19804_.m_135372_(GUN_ROTATE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(FIRE_TIME, (Object)0);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage(((Double)VehicleConfig.HPJ11_DAMAGE.get()).floatValue()).explosionDamage(((Double)VehicleConfig.HPJ11_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Double)VehicleConfig.HPJ11_EXPLOSION_RADIUS.get()).floatValue()).aa(true).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_30mm.png"))}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(2.0 + 0.75 * ClientMouseHandler.custom3pDistanceLerp, 0.75, 0.0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AnimTime", ((Integer)this.f_19804_.m_135370_(ANIM_TIME)).intValue());
        compound.m_128379_("Active", ((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue());
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ANIM_TIME, (Object)compound.m_128451_("AnimTime"));
        this.f_19804_.m_135381_(ACTIVE, (Object)compound.m_128471_("Active"));
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (player.m_6047_()) {
            if (stack.m_204117_(ModTags.Items.CROWBAR) && (this.m_269323_() == null || player == this.m_269323_())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.m_36356_(container)) {
                    player.m_36176_(container, false);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            if (this.m_21805_() == null) {
                this.setOwnerUUID(player.m_20148_());
            }
            if (this.m_269323_() == player) {
                this.f_19804_.m_135381_(ACTIVE, (Object)((Boolean)this.f_19804_.m_135370_(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        }
        this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        return super.m_6096_(player, hand);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 1.0f) * damage.floatValue()));
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    @Override
    public void m_6075_() {
        if (!this.wasFiring && this.isFiring() && this.m_9236_().m_5776_()) {
            fireSound.accept(this);
        }
        this.wasFiring = this.isFiring();
        this.gunRotO = this.getGunRot();
        super.m_6075_();
        if ((Integer)this.f_19804_.m_135370_(ANIM_TIME) > 0) {
            this.f_19804_.m_135381_(ANIM_TIME, (Object)((Integer)this.f_19804_.m_135370_(ANIM_TIME) - 1));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.handleAmmo();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.fireInputDown && ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire) {
                this.vehicleShoot(player, 0);
            }
        }
        this.f_19804_.m_135381_(GUN_ROTATE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(GUN_ROTATE)).floatValue() * 0.8f));
        this.setGunRot(this.getGunRot() + ((Float)this.f_19804_.m_135370_(GUN_ROTATE)).floatValue());
        this.autoAim();
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(FIRE_TIME) - 1));
        }
        this.lowHealthWarning();
    }

    private void handleAmmo() {
        if (this.hasItem((Item)ModItems.CREATIVE_AMMO_BOX.get())) {
            this.f_19804_.m_135381_(AMMO, (Object)9999);
        } else {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
        }
    }

    public boolean isFiring() {
        return (Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void autoAim() {
        block16: {
            block15: {
                LivingEntity living;
                Player player1;
                LivingEntity livingEntity;
                Entity target;
                Entity naerestEntity;
                if (this.m_146895_() != null || !((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue()) {
                    return;
                }
                if (this.getEnergy() <= (Integer)VehicleConfig.HPJ11_SEEK_COST.get()) {
                    return;
                }
                Matrix4f transform = this.getBarrelTransform(1.0f);
                Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.4f, 0.0f);
                Vec3 barrelRootPos = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
                if (((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none") && this.f_19797_ % 2 == 0 && (naerestEntity = this.seekNearLivingEntity(this, barrelRootPos, -32.5, 90.0, 3.0, 160.0, 0.3)) != null) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)naerestEntity.m_20149_());
                    this.consumeEnergy((Integer)VehicleConfig.HPJ11_SEEK_COST.get());
                }
                if ((target = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID))) == null || !((livingEntity = this.m_269323_()) instanceof Player)) break block15;
                Player player = (Player)livingEntity;
                if (!SeekTool.smokeFilter(target)) break block15;
                if (target instanceof Player && ((player1 = (Player)target).m_5833_() || player1.m_7500_())) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    return;
                }
                if (VehicleEntity.getSubmergedHeight(target) >= (double)target.m_20206_()) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target.m_20270_((Entity)this) > 160.0f) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target instanceof LivingEntity && (living = (LivingEntity)target).m_21223_() <= 0.0f) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target == this || target instanceof TargetEntity) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target instanceof Projectile && (VectorTool.calculateAngle(target.m_20184_().m_82541_(), target.m_20182_().m_82505_(this.m_20182_()).m_82541_()) > 60.0 || target.m_20096_() || target.m_20184_().m_82556_() < 0.001)) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target.m_20202_() != null) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)target.m_20202_().m_20149_());
                }
                Vec3 targetPos = target.m_20191_().m_82399_();
                Vec3 targetVel = target.m_20184_();
                Vec3 targetVec = RangeTool.calculateFiringSolution(barrelRootPos, targetPos, targetVel, 20.0, 0.03);
                double d0 = targetVec.f_82479_;
                double d1 = targetVec.f_82480_;
                double d2 = targetVec.f_82481_;
                double d3 = Math.sqrt((double)(d0 * d0 + d2 * d2));
                float targetY = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
                float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(targetY - this.m_146908_())));
                this.turretTurnSound(0.0f, diffY, 1.1f);
                this.m_146926_(Mth.m_14036_((float)Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875)))), (float)-90.0f, (float)40.0f));
                this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.9f * diffY), (float)-20.0f, (float)20.0f));
                if (target.m_20270_((Entity)this) <= 144.0f && VectorTool.calculateAngle(this.m_20252_(1.0f), targetVec) < 10.0) {
                    if (this.checkNoClip(this, target, barrelRootPos) && (Integer)this.f_19804_.m_135370_(AMMO) > 0) {
                        this.vehicleShoot(player, 0);
                    } else {
                        ++this.changeTargetTimer;
                    }
                    if (!target.m_6084_()) {
                        this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    }
                }
                break block16;
            }
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > 60) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    @Override
    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.m_269323_() == null) {
            return false;
        }
        if (pEntity.m_5647_() == null) {
            return false;
        }
        return !pEntity.m_7307_((Entity)this.m_269323_()) || pEntity.m_5647_() != null && pEntity.m_5647_().m_5758_().equals("TDM");
    }

    @Override
    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.m_269323_() == null) {
            return false;
        }
        if (projectile.m_19749_() != null && projectile.m_19749_() == this.m_269323_()) {
            return false;
        }
        return projectile.m_19749_() != null && !projectile.m_19749_().m_7307_((Entity)this.m_269323_()) || projectile.m_19749_() != null && projectile.m_19749_().m_5647_() != null && projectile.m_19749_().m_5647_().m_5758_().equals("TDM") || projectile.m_19749_() == null;
    }

    public float getGunRot() {
        return this.gunRot;
    }

    public void setGunRot(float pGunRot) {
        this.gunRot = pGunRot;
    }

    @Override
    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    @Override
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        callback.m_20372_(passenger, this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-90.0f, (float)90.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
        entity.m_5618_(this.m_146908_());
    }

    public Vec3 driverPos(float ticks) {
        Matrix4f transform = this.getVehicleFlatTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, -1.0625f, 3.25f, -1.0625f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        Player pPlayer;
        if (this.cannotFire) {
            return;
        }
        if (this.getEnergy() < (Integer)VehicleConfig.HPJ11_SHOOT_COST.get()) {
            return;
        }
        Entity entity = this.m_146895_();
        boolean hasCreativeAmmo = entity instanceof Player && InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity)) || this.hasItem((Item)ModItems.CREATIVE_AMMO_BOX.get());
        this.f_19804_.m_135381_(FIRE_TIME, (Object)Math.min((int)((Integer)this.f_19804_.m_135370_(FIRE_TIME) + 3), (int)5));
        SmallCannonShellEntity entityToSpawn = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.4f, 0.0f);
        entityToSpawn.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
        entityToSpawn.m_6686_(this.m_20154_().f_82479_, this.m_20154_().f_82480_, this.m_20154_().f_82481_, 20.0f, 0.25f);
        this.m_9236_().m_7967_((Entity)entityToSpawn);
        this.f_19804_.m_135381_(GUN_ROTATE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(GUN_ROTATE)).floatValue() + 0.5f));
        this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 2));
        this.f_19804_.m_135381_(ANIM_TIME, (Object)1);
        this.consumeEnergy((Integer)VehicleConfig.HPJ11_SHOOT_COST.get());
        if (hasCreativeAmmo) {
            return;
        }
        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
    }

    public float shootingVolume() {
        return (float)((Integer)this.f_19804_.m_135370_(FIRE_TIME)).intValue() * 0.4f;
    }

    public float shootingPitch() {
        return 0.8f + (float)((Integer)this.f_19804_.m_135370_(FIRE_TIME)).intValue() * 0.1f;
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformV = this.getVehicleFlatTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.375f, 0.25f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        return transformV;
    }

    @Override
    public void travel() {
        if (this.getEnergy() <= 0) {
            return;
        }
        Entity passenger = this.m_146895_();
        if (passenger != null) {
            float diffY = Mth.m_14177_((float)(passenger.m_6080_() - this.m_146908_()));
            float diffX = Mth.m_14177_((float)(passenger.m_146909_() - this.m_146909_()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.9f * diffY), (float)-20.0f, (float)20.0f));
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + Mth.m_14036_((float)(0.9f * diffX), (float)-15.0f, (float)15.0f)), (float)-90.0f, (float)32.5f));
        }
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)-90.0f, (float)32.5f);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 0;
    }

    @Override
    public boolean canShoot(Player player) {
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    @Override
    public boolean hidePassenger(int index) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 2;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.f_19804_.m_135370_(HEAT);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        if (this.m_146895_() != null) {
            return this.m_146895_().m_20252_(pPartialTicks);
        }
        return super.getBarrelVector(pPartialTicks);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/hpj_11_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.25 : 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
            }
            return new Vec3(this.driverPos((float)partialTicks).f_82479_, this.driverPos((float)partialTicks).f_82480_, this.driverPos((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }
}

