/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.LaserWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PrismTankEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.m_135353_(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> LASER_LENGTH = SynchedEntityData.m_135353_(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_SCALE = SynchedEntityData.m_135353_(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_SCALE_O = SynchedEntityData.m_135353_(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public OBB obb;
    public OBB obb2;
    public OBB obb3;
    public OBB obb4;
    public OBB obb5;
    public OBB obb6;
    public OBB obbTurret;

    public PrismTankEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PrismTankEntity>)((EntityType)ModEntities.PRISM_TANK.get()), world);
    }

    public PrismTankEntity(EntityType<PrismTankEntity> type, Level world) {
        super(type, world);
        this.m_274367_(2.25f);
        this.f_19811_ = true;
        this.obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.4f, 0.8125f, 3.71875f), new Quaternionf(), OBB.Part.BODY);
        this.obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.4f, 0.5f, 0.375f), new Quaternionf(), OBB.Part.BODY);
        this.obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.46875f, 0.78125f, 3.3125f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
        this.obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.46875f, 0.78125f, 3.3125f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
        this.obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.375f, 0.28125f, 1.375f), new Quaternionf(), OBB.Part.BODY);
        this.obb6 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.0625f, 0.78125f, 0.8125f), new Quaternionf(), OBB.Part.ENGINE1);
        this.obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.4375f, 0.90625f, 1.21875f), new Quaternionf(), OBB.Part.TURRET);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new LaserWeapon().sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.PRISM_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.PRISM_FIRE_3P.get()), new LaserWeapon().sound((SoundEvent)ModSounds.INTO_CANNON.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(4.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CANNON_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_SCALE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_SCALE_O, (Object)Float.valueOf(0.0f));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    @Override
    public void m_6075_() {
        this.f_19804_.m_135381_(LASER_SCALE_O, (Object)((Float)this.f_19804_.m_135370_(LASER_SCALE)));
        super.m_6075_();
        this.updateOBB();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(100.0f);
        }
        if (this.getLeftTrack() > 100.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(100.0f);
        }
        if (this.getRightTrack() > 100.0f) {
            this.setRightTrack(0.0f);
        }
        if (((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() > 0.0f) {
            this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() - 0.1f), (float)0.0f)));
            this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() * 0.9f));
        }
        if (((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() == 0.0f) {
            this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        }
        this.turretAngle(10.0f, 12.5f);
        this.terrainCompact(4.6375f, 5.171875f);
        this.inertiaRotate(1.0f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.fireInputDown && this.getWeaponIndex(0) == 1 && this.getEnergy() > (Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_2.get() && !this.cannotFire) {
                this.vehicleShoot(player, 0);
            }
        }
        this.lowHealthWarning();
        this.m_6210_();
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.07 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.12;
    }

    @Override
    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.m_6478_(movementType, movement);
        if (this.m_20069_() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
        }
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.5f, 0.0f);
        Vec3 root = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        if (this.getWeaponIndex(0) == 0) {
            float dis;
            if (this.cannotFire) {
                return;
            }
            if (!this.canConsume((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_1.get())) {
                player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.annihilator.energy_not_enough").m_130940_(ChatFormatting.RED), true);
                return;
            }
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                if (!player.m_9236_().f_46443_) {
                    this.playShootSound3p(player, 0, 5, 5, 5);
                }
                this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 55));
                this.consumeEnergy((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_1.get());
                ShakeClientMessage.sendToNearbyPlayers(this, 5.0, 8.0, 4.0, 7.0);
            }
            if ((dis = this.laserLengthEntity(root)) < this.laserLength(root)) {
                this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(dis));
            } else {
                this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(this.laserLength(root)));
                this.hitBlock(root);
            }
            this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(3.0f));
        } else if (this.getWeaponIndex(0) == 1) {
            float dis;
            if (this.cannotFire) {
                return;
            }
            if (!this.canConsume((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_2.get())) {
                player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.annihilator.energy_not_enough").m_130940_(ChatFormatting.RED), true);
                return;
            }
            Level level = player.m_9236_();
            float pitch = (Integer)this.f_19804_.m_135370_(HEAT) <= 60 ? 1.1f : (float)((double)1.1f - 0.011 * (double)Math.abs((int)(60 - (Integer)this.f_19804_.m_135370_(HEAT))));
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.PRISM_FIRE_1P_2.get(), 1.0f, pitch);
            if (level instanceof ServerLevel) {
                if (!player.m_9236_().f_46443_) {
                    this.playShootSound3p(player, 0, 4, 4, 4);
                }
                this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 2));
                this.consumeEnergy((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_2.get());
            }
            if ((dis = this.laserLengthEntity(root)) < this.laserLength(root)) {
                this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(dis));
            } else {
                this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(this.laserLength(root)));
                this.hitBlock(root);
            }
            this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(1.0f));
        }
    }

    private void hitBlock(Vec3 pos) {
        if (this.m_9236_() instanceof ServerLevel) {
            Level level;
            BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(pos, pos.m_82549_(this.getBarrelVector(1.0f).m_82490_(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            Vec3 hitPos = result.m_82450_();
            if (this.m_146895_() != null && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getWeaponIndex(0) == 0) {
                    this.findNearEntity(hitPos);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 24, 0.0, 0.0, 0.0, 0.2, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 8, 0.0, 0.0, 0.0, 0.4, true);
                } else {
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 4, 0.0, 0.0, 0.0, 0.05, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.15, true);
                }
            }
        }
    }

    private float laserLength(Vec3 pos) {
        return (float)pos.m_82554_(Vec3.m_82528_((Vec3i)this.m_9236_().m_45547_(new ClipContext(pos, pos.m_82549_(this.getBarrelVector(1.0f).m_82490_(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_82425_()));
    }

    private float laserLengthEntity(Vec3 pos) {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB aabb;
            double blockReach;
            double distance = 262144.0;
            HitResult hitResult = this.pickNew(pos, 512.0);
            if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = hitResult.m_82450_().m_82557_(pos)) > (blockReach = 5.0) * blockReach) {
                Vec3 posB = hitResult.m_82450_();
                hitResult = BlockHitResult.m_82426_((Vec3)posB, (Direction)Direction.m_122366_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_), (BlockPos)BlockPos.m_274446_((Position)posB));
            }
            Vec3 viewVec = this.getBarrelVector(1.0f);
            Vec3 toVec = pos.m_82520_(viewVec.f_82479_ * 512.0, viewVec.f_82480_ * 512.0, viewVec.f_82481_ * 512.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)this, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = this.m_20191_().m_82369_(viewVec.m_82490_(512.0)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && p.m_6084_() && SeekTool.smokeFilter(p), (double)distance);
            if (entityhitresult != null) {
                Vec3 targetPos = entityhitresult.m_82450_();
                double distanceToTarget = pos.m_82557_(targetPos);
                if (distanceToTarget > distance || distanceToTarget > 262144.0) {
                    hitResult = BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)targetPos));
                } else if (distanceToTarget < distance) {
                    hitResult = entityhitresult;
                }
                if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                    Level level;
                    Entity passenger = this.m_146895_();
                    Entity target = ((EntityHitResult)hitResult).m_82443_();
                    if (passenger != null && (level = this.m_9236_()) instanceof ServerLevel) {
                        Entity entity;
                        ServerLevel serverLevel = (ServerLevel)level;
                        DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(this.m_9236_().m_9598_(), this, passenger), (this.getWeaponIndex(0) == 0 ? (Integer)VehicleConfig.PRISM_TANK_DAMAGE_MODE_1.get() : (Integer)VehicleConfig.PRISM_TANK_DAMAGE_MODE_2.get()).intValue());
                        Vec3 vec = pos.m_82490_(pos.m_82554_(target.m_20182_()));
                        if (this.getWeaponIndex(0) == 0) {
                            this.findNearEntity(target.m_146892_());
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 24, 0.0, 0.0, 0.0, 0.2, true);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 8, 0.0, 0.0, 0.0, 0.4, true);
                        } else {
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 4, 0.0, 0.0, 0.0, 0.05, true);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 2, 0.0, 0.0, 0.0, 0.15, true);
                        }
                        if (this.m_146895_() != null && !this.m_146895_().m_9236_().m_5776_() && (entity = this.m_146895_()) instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            Holder holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION.get()));
                            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
                            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
                        }
                    }
                    target.f_19802_ = 1;
                    return (float)pos.m_82554_(target.m_20182_());
                }
            }
        }
        return 512.0f;
    }

    public void findNearEntity(Vec3 vec) {
        int aoeDamage = (Integer)VehicleConfig.PRISM_TANK_AOE_DAMAGE.get();
        int range = (Integer)VehicleConfig.PRISM_TANK_AOE_RADIUS.get();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<Entity> entities = this.seekNearEntities(vec, this.m_9236_(), range);
            for (Entity e : entities) {
                Vec3 toVec;
                double dis = vec.m_82554_(e.m_146892_());
                float i = 0.0f;
                while ((double)i < dis) {
                    toVec = vec.m_82505_(e.m_146892_()).m_82541_();
                    Vec3 pos = vec.m_82549_(toVec.m_82490_((double)i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, true);
                    i += 0.2f;
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, e.m_20185_(), e.m_20188_(), e.m_20189_(), 4, 0.0, 0.0, 0.0, 0.15, true);
                DamageHandler.doDamage(e, ModDamageTypes.causeLaserDamage(this.m_9236_().m_9598_(), this, this.m_146895_()), (float)((double)aoeDamage - Mth.m_14008_((double)(dis / (double)range), (double)0.0, (double)0.75) * (double)aoeDamage));
                if (this.m_146895_() == null || this.m_146895_().m_9236_().m_5776_() || !((toVec = this.m_146895_()) instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)toVec;
                Holder holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION.get()));
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
        }
    }

    public List<Entity> seekNearEntities(Vec3 vec3, Level level, double seekRange) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> e.m_20182_().m_82554_(vec3) <= seekRange && e != this && e.m_20202_() != this && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.m_20202_() == null && (!e.m_7307_((Entity)this) || e.m_5647_() == null || e.m_5647_().m_5758_().equals("TDM"))).toList();
    }

    public HitResult pickNew(Vec3 pos, double pHitDistance) {
        Vec3 vec31 = this.getBarrelVector(1.0f);
        Vec3 vec32 = pos.m_82520_(vec31.f_82479_ * pHitDistance, vec31.f_82480_ * pHitDistance, vec31.f_82481_ * pHitDistance);
        return this.m_9236_().m_45547_(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    @Override
    public void travel() {
        this.trackEngine(false, 0.0, (Integer)VehicleConfig.PRISM_TANK_ENERGY_COST.get(), 1.25, 0.5, 1.9, 0.8, 0.26f, -0.2f, 0.0032f, 0.0024f, 0.12f);
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.PRISM_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.0f, -0.6f, 0.0f) : this.transformPosition(transformV, -0.59375f, 1.0f, 3.0625f);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
        if (entity == this.getNthEntity(1)) {
            entity.m_5618_(this.m_146908_());
        }
    }

    @Override
    public int getMaxPassengers() {
        return 2;
    }

    public Vec3 driverPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.5f, 1.2f, -0.1f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.95f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.484375f, -0.2375f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    @Override
    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.14375f, 0.7375f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    @Override
    public float rotateYOffset() {
        return 3.5f;
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -32.5f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 15.0f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
        if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)-80.0f, (float)10.0f);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-100.0f, (float)100.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return 30;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 0;
        }
        return 30;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return this.getEnergy() > (Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_1.get() && !this.cannotFire;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (int)((float)this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).intValue() * 100.0f / (float)this.getMaxEnergy());
    }

    @Override
    public boolean banHand(Player player) {
        return player == this.m_146895_();
    }

    @Override
    public boolean hidePassenger(int index) {
        return index == 0;
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.f_19804_.m_135370_(HEAT);
    }

    @Override
    public boolean hasTracks() {
        return true;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/prism_tank_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/lav_missile_cross.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
        double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
        guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("LASER   " + ((Integer)this.m_20088_().m_135370_(HEAT) + 25) + " \u2103")), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderThirdPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
        guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("LASER " + ((Integer)this.m_20088_().m_135370_(HEAT) + 25) + " \u2103")), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
    }

    @Override
    public boolean hasDecoy() {
        return true;
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.26 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.33 : 0.45);
    }

    @Override
    public boolean isEnclosed(int index) {
        return index == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if ((zoom || isFirstPerson) && this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)(-PrismTankEntity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-PrismTankEntity.getXRotFromVector(this.getBarrelVec(partialTicks))));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if ((zoom || isFirstPerson) && this.getSeatIndex((Entity)player) == 0) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
            }
            return new Vec3(this.driverPos((float)partialTicks).f_82479_, this.driverPos((float)partialTicks).f_82480_, this.driverPos((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return this.getSeatIndex(entity) == 0;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/land.png");
    }

    @Override
    public float getWheelMaxHealth() {
        return 100.0f;
    }

    @Override
    public float getEngineMaxHealth() {
        return 150.0f;
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obb6, this.obbTurret);
    }

    @Override
    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.4375f, 0.03125f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.4375f, 4.125f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition3 = this.transformPosition(transform, 2.09375f, 0.84375f, 0.0f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition4 = this.transformPosition(transform, -2.09375f, 0.84375f, 0.0f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition5 = this.transformPosition(transform, 0.0f, 2.53125f, 0.765625f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition6 = this.transformPosition(transform, 0.0f, 1.53125f, -3.125f);
        this.obb6.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obb6.setRotation(VectorTool.combineRotations(1.0f, this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 1.59375f, -0.390625f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
    }
}

