/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.BoatVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpeedboatEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
ArmedVehicleEntity,
WeaponVehicleEntity,
LandArmorEntity,
OBBEntity,
BoatVehicleEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.5625f, 0.75f, 3.1875f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.0625f, 0.5f, 1.90625f), new Quaternionf(), OBB.Part.BODY);

    public SpeedboatEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SpeedboatEntity>)((EntityType)ModEntities.SPEEDBOAT.get()), world);
    }

    public SpeedboatEntity(EntityType<SpeedboatEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new ProjectileWeapon().damage(((Integer)VehicleConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).icon(Mod.loc("textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M_2_HB_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_2_HB_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_2_HB_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_2_HB_VERYFAR.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public double m_6048_() {
        return super.m_6048_() - 0.8;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.updateOBB();
        double fluidFloat = 0.12 * SpeedboatEntity.getSubmergedHeight(this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.2, 0.99, 0.2));
        } else if (this.m_20069_()) {
            float f = (float)(0.75 - (double)0.04f * Math.min(SpeedboatEntity.getSubmergedHeight(this), (double)this.m_20206_()) + (double)(0.09f * Mth.m_14154_((float)(90.0f - (float)SpeedboatEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f, 0.85, (double)f));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.m_20185_() + 0.5 * this.m_20184_().f_82479_, this.m_20186_() + SpeedboatEntity.getSubmergedHeight(this) - 0.2, this.m_20189_() + 0.5 * this.m_20184_().f_82481_, (int)(2.0 + 4.0 * this.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, this.m_20185_() + 0.5 * this.m_20184_().f_82479_, this.m_20186_() + SpeedboatEntity.getSubmergedHeight(this) - 0.2, this.m_20189_() + 0.5 * this.m_20184_().f_82481_, (int)(2.0 + 10.0 * this.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, this.m_20185_() - 4.5 * this.m_20154_().f_82479_, this.m_20186_() - 0.25, this.m_20189_() - 4.5 * this.m_20154_().f_82481_, (int)(40.0f * Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue())), 0.15, 0.15, 0.15, 0.02, true);
            }
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.handleAmmo();
        }
        this.turretAngle(40.0f, 40.0f);
        this.lowHealthWarning();
        this.inertiaRotate(2.0f);
        this.terrainCompact(2.0f, 3.0f);
        this.m_6210_();
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.15;
    }

    private void handleAmmo() {
        if (!(this.m_146895_() instanceof Player)) {
            return;
        }
        int ammoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.HEAVY.get((ItemStack)stack) > 0;
            }
            return false;
        }).mapToInt(Ammo.HEAVY::get).sum() + this.m_18947_((Item)ModItems.HEAVY_AMMO.get());
        this.f_19804_.m_135381_(AMMO, (Object)ammoCount);
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        if (this.cannotFire) {
            return;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        float x = 0.0f;
        float y = 0.20106874f;
        float z = 0.0f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        ProjectileEntity projectile = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.m_6095_().m_20675_());
        projectile.bypassArmorRate(0.4f);
        projectile.m_6034_((double)worldPosition.x + 0.5 * this.m_20184_().f_82479_, worldPosition.y, (double)worldPosition.z + 0.5 * this.m_20184_().f_82481_);
        projectile.shoot(player, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 20.0f, 0.4f);
        this.m_9236_().m_7967_((Entity)projectile);
        if (!player.m_9236_().f_46443_) {
            this.playShootSound3p(player, 0, 4, 12, 24);
        }
        ShakeClientMessage.sendToNearbyPlayers(this, 5.0, 6.0, 5.0, 5.0);
        this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)30);
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
        this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 4));
        this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        if (!hasCreativeAmmo) {
            ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get((ItemStack)stack) > 0;
                }
                return false;
            }).findFirst().orElse(ItemStack.f_41583_);
            if (!ammoBox.m_41619_()) {
                Ammo.HEAVY.add(ammoBox, -1);
            } else {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.HEAVY_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() > 0) {
            if (passenger0 == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
            }
            if (this.forwardInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.005f));
            }
            if (this.backInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.005f));
                if (this.rightInputDown) {
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
                } else if (this.leftInputDown) {
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
                }
            } else if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
            }
            if (this.forwardInputDown || this.backInputDown) {
                this.consumeEnergy((Integer)VehicleConfig.SPEEDBOAT_ENERGY_COST.get());
            }
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.96f));
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.8f));
            this.setRotorRot(this.getRotorRot() + 30.0f * ((Float)this.f_19804_.m_135370_(POWER)).floatValue());
            this.setRudderRot(Mth.m_14036_((float)(this.getRudderRot() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-1.25f, (float)1.25f) * 0.7f * (float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 1 : -1));
            if (this.m_20069_() || this.m_5842_()) {
                this.m_146926_(this.m_146909_() * 0.85f);
                float direct = (90.0f - (float)SpeedboatEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f))) / 90.0f;
                this.m_146926_((float)((double)this.m_146909_() - (double)(direct * (float)(!this.m_20096_() ? 1 : 0) * 1.1f) * this.m_20184_().m_165924_()));
                this.m_146922_((float)((double)this.m_146908_() - org.joml.Math.max((double)(12.0 * this.m_20184_().m_82553_()), (double)0.8) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()));
                this.setZRot((float)((double)this.getRoll() - (double)(direct * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)(!this.m_20096_() ? 1 : 0) * 10.0f) * this.m_20184_().m_165924_()));
                this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 1.75f))));
            } else {
                this.m_146926_(this.m_146909_() * 0.99f);
            }
        }
        this.setZRot(this.roll * 0.85f);
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BOAT_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return (Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) - 0.01f) * 2.0f;
    }

    @ParametersAreNonnullByDefault
    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        Vector4f worldPosition;
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        float y = 0.35f;
        switch (i) {
            case 0: {
                Vector4f vector4f = this.transformPosition(transform, 0.0f, y + 0.25f, -0.2f);
                break;
            }
            case 1: {
                Vector4f vector4f = this.transformPosition(transform, -0.8f, y, -1.2f);
                break;
            }
            case 2: {
                Vector4f vector4f = this.transformPosition(transform, 0.8f, y, -1.2f);
                break;
            }
            case 3: {
                Vector4f vector4f = this.transformPosition(transform, -0.8f, y, -2.2f);
                break;
            }
            case 4: {
                Vector4f vector4f = this.transformPosition(transform, 0.8f, y, -2.2f);
                break;
            }
            default: {
                Vector4f vector4f = worldPosition = null;
            }
        }
        if (worldPosition != null) {
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.m_146895_()) {
            passenger.m_146926_(passenger.m_146909_() + (this.m_146909_() - this.f_19860_));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
        entity.m_5618_(this.m_146908_());
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -50.0f - r * this.m_146909_() - r2 * this.getRoll();
        float max = 25.0f - r * this.m_146909_() - r2 * this.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f3 = Mth.m_14036_((float)f2, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f3 - f2;
        entity.m_146922_(entity.m_146908_() + f3 - f2);
        entity.m_5618_(this.m_146908_());
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        float x = 0.0f;
        float y = 0.5f;
        float z = -0.25f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.5088375f, 0.04173125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    @Override
    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.5616624f, -0.565625f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    @Override
    public float rotateYOffset() {
        return 1.0f;
    }

    private PlayState firePredicate(AnimationState<SpeedboatEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.speedboat.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.speedboat.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int getMaxPassengers() {
        return 5;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 500;
    }

    @Override
    public boolean canShoot(Player player) {
        return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    @Override
    public int zoomFov() {
        return 1;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.f_19804_.m_135370_(HEAT);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/speedboat_icon.png");
    }

    @Override
    public Vec3 getGunVec(float ticks) {
        return this.getBarrelVector(ticks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0 && zoom) {
            return new Vec2((float)(-SpeedboatEntity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-SpeedboatEntity.getXRotFromVector(this.getBarrelVec(partialTicks))));
        }
        return super.getCameraRotation(partialTicks, player, zoom, isFirstPerson);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0 && zoom) {
            return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, zoom, isFirstPerson);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return this.getSeatIndex(entity) == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.f_252529_.m_252977_(-this.m_5686_(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.getRoll(tickDelta)));
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/water.png");
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2);
    }

    @Override
    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.875f, 0.375f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 2.0625f, -0.71875f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations(1.0f, this));
    }
}

