/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.advancement.CriteriaRegister;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WheelChairEntity
extends MobileVehicleEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int jumpCoolDown;
    public int handBusyTime;

    public WheelChairEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WheelChairEntity>)((EntityType)ModEntities.WHEEL_CHAIR.get()), world);
    }

    public WheelChairEntity(EntityType<WheelChairEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_6123_(Player pPlayer) {
        if (this.m_20182_().m_82554_(pPlayer.m_20182_()) > 1.4 || pPlayer == this.m_146895_()) {
            return;
        }
        if (!this.m_9236_().f_46443_ && pPlayer.m_20186_() < this.m_20186_() + (double)this.m_20206_() && pPlayer.m_20186_() + (double)pPlayer.m_20206_() > this.m_20186_()) {
            double entitySize = pPlayer.m_20205_() * pPlayer.m_20206_();
            double thisSize = this.m_20205_() * this.m_20206_();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            this.m_20256_(this.m_20184_().m_82549_(new Vec3(pPlayer.m_20182_().m_82505_(this.m_20182_()).m_252839_()).m_82490_(0.5 * f * pPlayer.m_20184_().m_82553_())));
            this.m_146922_(pPlayer.m_6080_());
        }
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(0.5 * ClientMouseHandler.custom3pDistanceLerp, 0.0, 0.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public boolean shouldSendHitParticles() {
        return false;
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.3), this.f_19796_.m_188501_() * 0.15f + 1.0f);
    }

    @Override
    public void m_6075_() {
        if (this.jumpCoolDown > 0 && this.m_20096_()) {
            --this.jumpCoolDown;
        }
        if (this.handBusyTime > 0) {
            --this.handBusyTime;
        }
        super.m_6075_();
        if (this.m_20096_()) {
            float f = (float)Mth.m_14008_((double)(0.85f + 0.05f * Mth.m_14154_((float)(90.0f - (float)WheelChairEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f), (double)0.01, (double)0.99);
            this.m_20256_(this.m_20184_().m_82542_((double)f, 0.99, (double)f));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        this.m_6858_(this.m_20184_().m_165924_() > 0.15);
        this.attractEntity();
        this.terrainCompact(0.9f, 1.2f);
        this.inertiaRotate(10.0f);
        this.m_6210_();
    }

    public boolean hasEnoughSpaceFor(Entity pEntity) {
        return pEntity.m_20205_() < this.m_20205_();
    }

    public void attractEntity() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f));
        if (!list.isEmpty()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this) || !flag || entity.m_20159_() || !this.hasEnoughSpaceFor(entity) || !(entity instanceof LivingEntity) && !(entity instanceof MortarEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                entity.m_20329_((Entity)this);
            }
        }
    }

    @Override
    protected void m_20348_(@NotNull Entity pPassenger) {
        ServerPlayer player;
        super.m_20348_(pPassenger);
        if (pPassenger instanceof ServerPlayer && ((player = (ServerPlayer)pPassenger).m_21205_().m_41720_() == ModItems.ELECTRIC_BATON.get() || player.m_21206_().m_41720_() == ModItems.ELECTRIC_BATON.get())) {
            CriteriaRegister.OTTO_SPRINT.trigger(player);
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.m_146895_();
        float diffY = 0.0f;
        if (passenger == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
        } else if (passenger instanceof Player) {
            diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(passenger.m_6080_() - this.m_146908_())));
            this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
            float direct = (90.0f - (float)WheelChairEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f))) / 90.0f;
            this.setZRot((float)((double)this.getRoll() + (double)(direct * diffY) * 0.2 * this.m_20184_().m_82553_()));
        }
        if (this.forwardInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (this.sprintInputDown ? 0.02f : 0.01f)));
            if (this.getEnergy() <= 0 && passenger instanceof Player) {
                Player player = (Player)passenger;
                this.moveWithOutPower(player, true);
            }
        }
        if (this.backInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.01f));
            if (this.getEnergy() <= 0 && passenger instanceof Player) {
                Player player = (Player)passenger;
                this.moveWithOutPower(player, false);
            }
        }
        if (this.upInputDown && this.m_20096_() && this.getEnergy() > 400 && this.jumpCoolDown == 0) {
            if (passenger instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger;
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.consumeEnergy((Integer)VehicleConfig.WHEELCHAIR_JUMP_ENERGY_COST.get());
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.6, 0.0));
            this.jumpCoolDown = 3;
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.WHEELCHAIR_MOVE_ENERGY_COST.get());
        }
        if (passenger instanceof Player) {
            LocalPlayer localPlayer;
            Player player = (Player)passenger;
            if (player.m_9236_().f_46443_ && this.handBusyTime > 0 && (localPlayer = Minecraft.m_91087_().f_91074_) != null && player.m_20148_().equals(localPlayer.m_20148_())) {
                localPlayer.f_108611_ = true;
            }
        }
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.87f));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0) - 0.015f * Mth.m_14036_((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0) + 0.015f * Mth.m_14036_((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        float power = ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * Mth.m_14036_((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.m_146909_() / 35.0f), (float)0.0f, (float)2.0f);
        this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((this.m_20096_() ? 1.0 : 0.1) * (double)power)));
    }

    public void moveWithOutPower(Player player, boolean forward) {
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (forward ? 0.015f : -0.015f)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11706_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.m_36399_(0.03f);
        this.handBusyTime = 4;
        this.forwardInputDown = false;
        this.backInputDown = false;
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.WHEEL_CHAIR_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return this.getEnergy() > 0 ? ((Float)this.f_19804_.m_135370_(POWER)).floatValue() : 0.0f;
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f3 = Mth.m_14036_((float)f2, (float)-90.0f, (float)90.0f);
        entity.f_19859_ += f3 - f2;
        entity.m_146922_(entity.m_146908_() + f3 - f2);
        entity.m_5618_(this.m_146908_());
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.0f;
        float y = 0.3f;
        float z = 0.0f;
        y += (float)passenger.m_6049_();
        int i = this.getSeatIndex(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.m_146895_()) {
            passenger.m_146926_(passenger.m_146909_() + (this.m_146909_() - this.f_19860_));
        }
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)0.4f), (double)(this.m_20186_() + (double)0.4f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/wheel_chair_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.f_252529_.m_252977_(-this.m_5686_(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.getRoll(tickDelta)));
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/otto.png");
    }
}

