/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.capability.energy.VehicleEnergyStorage;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleProp;
import com.atsuishio.superbwarfare.data.vehicle.VehiclePropertyModifier;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public abstract class VehicleEntity
extends Entity
implements Container,
VehiclePropertyModifier {
    public static final String TAG_SEAT_INDEX = "SBWSeatIndex";
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> OVERRIDE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> LAST_DRIVER_UUID = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> DELTA_ROT = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_X = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_Y = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<IntList> SELECTED_WEAPON = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Integer> HEAT = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> TURRET_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> L_WHEEL_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> R_WHEEL_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> ENGINE_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> L_ENGINE_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> TURRET_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> L_WHEEL_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> R_WHEEL_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ENGINE1_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ENGINE2_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public VehicleWeapon[][] availableWeapons;
    protected int interpolationSteps;
    protected double x;
    protected double y;
    protected double z;
    protected double serverYRot;
    protected double serverXRot;
    public float roll;
    public float prevRoll;
    public int lastHurtTick;
    public int repairCoolDown = this.maxRepairCoolDown();
    public boolean crash;
    public float turretYRot;
    public float turretXRot;
    public float turretYRotO;
    public float turretXRotO;
    public float turretYRotLock;
    public float gunYRot;
    public float gunXRot;
    public float gunYRotO;
    public float gunXRotO;
    public boolean cannotFire;
    public int noPassengerTime;
    @Nullable
    public Player damageDebugResultReceiver = null;
    protected final Map<VehicleProp<?>, Prop.PropModifyContext<VehicleData, ?>> propertyModifiers = new HashMap();
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    protected final NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private final List<Entity> orderedPassengers = this.generatePassengersList();
    public Function<Entity, Integer> entityIndexOverride = null;
    public static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected SyncedEntityEnergyStorage energyStorage = null;
    protected LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    protected boolean isInitialized = true;

    public VehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setHealth(this.getMaxHealth());
        if (this.hasEnergyStorage()) {
            this.energyStorage = new VehicleEnergyStorage(this);
        }
    }

    @Override
    @NotNull
    public Map<VehicleProp<?>, Prop.PropModifyContext<VehicleData, ?>> getPropModifiers() {
        return this.propertyModifiers;
    }

    public void mouseInput(double x, double y) {
        this.f_19804_.m_135381_(MOUSE_SPEED_X, (Object)Float.valueOf((float)x));
        this.f_19804_.m_135381_(MOUSE_SPEED_Y, (Object)Float.valueOf((float)y));
    }

    public int m_18947_(@Nullable Item item) {
        if (item == null || !this.hasContainer()) {
            return 0;
        }
        return InventoryTool.countItem(this.items, item);
    }

    public boolean hasItem(Item item) {
        if (!this.hasContainer()) {
            return false;
        }
        return this.m_18947_(item) > 0;
    }

    public int consumeItem(Item item, int count) {
        if (!this.hasContainer()) {
            return 0;
        }
        return InventoryTool.consumeItem(this.items, item, count);
    }

    public void insertItem(Item item, int count) {
        if (!this.hasContainer()) {
            return;
        }
        int rest = InventoryTool.insertItem(this.items, item, count, this.m_6893_());
        if (rest > 0) {
            ItemStack stackToDrop = new ItemStack((ItemLike)item, rest);
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stackToDrop));
        }
    }

    public int m_6643_() {
        return 0;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int pAmount) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)pAmount);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, @NotNull ItemStack pStack) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return;
        }
        int limit = org.joml.Math.min((int)this.m_6893_(), (int)pStack.m_41741_());
        if (!pStack.m_41619_() && pStack.m_41613_() > limit) {
            Mod.LOGGER.warn("try inserting ItemStack {} exceeding the maximum stack size: {}, clamped to {}", (Object)pStack.m_41720_(), (Object)limit, (Object)limit);
            pStack.m_41764_(limit);
        }
        this.items.set(slot, (Object)pStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return this.hasContainer() && !this.m_213877_() && this.m_20182_().m_82509_((Position)pPlayer.m_20182_(), 8.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean hasMenu() {
        return false;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public boolean hasContainer() {
        return this.m_6643_() > 0;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        int stackCount;
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return false;
        }
        ItemStack currentStack = (ItemStack)this.items.get(slot);
        if (!currentStack.m_41619_() && currentStack.m_41720_() != stack.m_41720_()) {
            return false;
        }
        int currentCount = currentStack.m_41613_();
        int combinedCount = currentCount + (stackCount = stack.m_41613_());
        if (combinedCount > this.m_6893_() || combinedCount > stack.m_41741_()) {
            return false;
        }
        return super.m_7013_(slot, stack);
    }

    public boolean m_271862_(@NotNull Container target, int slot, @NotNull ItemStack stack) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return false;
        }
        return super.m_271862_(target, slot, stack);
    }

    private ArrayList<Entity> generatePassengersList() {
        ArrayList<Entity> list = new ArrayList<Entity>(this.getMaxPassengers());
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            list.add(null);
        }
        return list;
    }

    public List<Entity> getOrderedPassengers() {
        return this.orderedPassengers;
    }

    protected void m_20348_(@NotNull Entity pPassenger) {
        int index;
        if (pPassenger.m_20202_() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.entityIndexOverride != null && this.entityIndexOverride.apply(pPassenger) != -1) {
            index = this.entityIndexOverride.apply(pPassenger);
        } else {
            index = 0;
            for (Entity passenger : this.orderedPassengers) {
                if (passenger == null) break;
                ++index;
            }
        }
        if (index >= this.getMaxPassengers() || index < 0) {
            return;
        }
        this.orderedPassengers.set(index, pPassenger);
        pPassenger.getPersistentData().m_128405_(TAG_SEAT_INDEX, index);
        this.f_19823_ = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        this.m_146852_(GameEvent.f_268500_, pPassenger);
    }

    protected void m_20351_(@NotNull Entity pPassenger) {
        if (pPassenger.m_20202_() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        int index = this.getSeatIndex(pPassenger);
        if (index == -1) {
            return;
        }
        this.orderedPassengers.set(index, null);
        this.f_19823_ = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        pPassenger.f_19851_ = 60;
        this.m_146852_(GameEvent.f_268533_, pPassenger);
    }

    public VehicleData data() {
        return VehicleData.from(this);
    }

    public float getStepHeight() {
        return this.data().get(VehicleProp.UP_STEP).floatValue();
    }

    @Nullable
    public Entity m_146895_() {
        if (this.orderedPassengers.isEmpty()) {
            return null;
        }
        return this.orderedPassengers.get(0);
    }

    @Nullable
    public Entity getNthEntity(int index) {
        if (index >= this.orderedPassengers.size() || index < 0) {
            return null;
        }
        return this.orderedPassengers.get(index);
    }

    public boolean changeSeat(Entity entity, int index) {
        Level level;
        if (index < 0 || index >= this.getMaxPassengers()) {
            return false;
        }
        if (this.orderedPassengers.get(index) != null) {
            return false;
        }
        if (!this.orderedPassengers.contains(entity)) {
            return false;
        }
        this.orderedPassengers.set(this.orderedPassengers.indexOf(entity), null);
        this.orderedPassengers.set(index, entity);
        entity.getPersistentData().m_128405_(TAG_SEAT_INDEX, index);
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8795_(s -> true).forEach(p -> p.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)this)));
        }
        return true;
    }

    public int getSeatIndex(Entity entity) {
        return this.orderedPassengers.indexOf(entity);
    }

    public int getTagSeatIndex(Entity entity) {
        return entity.getPersistentData().m_128451_(TAG_SEAT_INDEX);
    }

    @Nullable
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int seatIndex) {
        return null;
    }

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public float getYaw(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.f_19859_, (float)this.m_146908_());
    }

    public float getPitch(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.f_19860_, (float)this.m_146909_());
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void turretTurnSound(float diffX, float diffY, float pitch) {
        if (this.m_9236_().f_46443_ && ((double)Math.abs(diffY) > 0.5 || (double)Math.abs(diffX) > 0.5)) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), (SoundEvent)ModSounds.TURRET_TURN.get(), this.m_5720_(), (float)Math.min(0.15 * (double)Math.max(Mth.m_14154_((float)diffX), Mth.m_14154_((float)diffY)), 0.75), this.f_19796_.m_188501_() * 0.05f + pitch, false);
        }
    }

    public boolean shouldSendHitParticles() {
        return true;
    }

    public boolean shouldSendHitSounds() {
        return true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public EntityDataAccessor<Integer> getEnergyDataAccessor() {
        return ENERGY;
    }

    protected void m_8097_() {
        WeaponVehicleEntity weaponVehicle;
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
        this.f_19804_.m_135372_(OVERRIDE, (Object)"");
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(LAST_DRIVER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(DELTA_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MOUSE_SPEED_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MOUSE_SPEED_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HEAT, (Object)0);
        this.f_19804_.m_135372_(TURRET_HEALTH, (Object)Float.valueOf(this.getTurretMaxHealth()));
        this.f_19804_.m_135372_(L_WHEEL_HEALTH, (Object)Float.valueOf(this.getWheelMaxHealth()));
        this.f_19804_.m_135372_(R_WHEEL_HEALTH, (Object)Float.valueOf(this.getWheelMaxHealth()));
        this.f_19804_.m_135372_(ENGINE_HEALTH, (Object)Float.valueOf(this.getEngineMaxHealth()));
        this.f_19804_.m_135372_(L_ENGINE_HEALTH, (Object)Float.valueOf(this.getEngineMaxHealth()));
        this.f_19804_.m_135372_(TURRET_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(L_WHEEL_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(R_WHEEL_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(ENGINE1_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(ENGINE2_DAMAGED, (Object)false);
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity)).getAllWeapons().length > 0) {
            this.f_19804_.m_135372_(SELECTED_WEAPON, (Object)IntList.of((int[])this.initSelectedWeaponArray(weaponVehicle)));
        }
        this.f_19804_.m_135372_(ENERGY, (Object)0);
    }

    protected void consumeEnergy(int amount) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to consume energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return;
        }
        this.energyStorage.extractEnergy(amount, false);
    }

    protected boolean canConsume(int amount) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to check if can consume energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return false;
        }
        return this.getEnergy() >= amount;
    }

    public int getEnergy() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return Integer.MAX_VALUE;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Nullable
    public IEnergyStorage getEnergyStorage() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get energy storage of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
        }
        return this.energyStorage;
    }

    protected void setEnergy(int pEnergy) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to set energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return;
        }
        int targetEnergy = Mth.m_14045_((int)pEnergy, (int)0, (int)this.getMaxEnergy());
        if (targetEnergy > this.energyStorage.getEnergyStored()) {
            this.energyStorage.receiveEnergy(targetEnergy - this.energyStorage.getEnergyStored(), false);
        } else {
            this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored() - targetEnergy, false);
        }
    }

    public int getMaxEnergy() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get max energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return Integer.MAX_VALUE;
        }
        return this.data().get(VehicleProp.MAX_ENERGY);
    }

    public boolean hasEnergyStorage() {
        return false;
    }

    private int[] initSelectedWeaponArray(WeaponVehicleEntity weaponVehicle) {
        weaponVehicle.getAllWeapons();
        int[] selected = new int[this.getMaxPassengers()];
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            selected[i] = weaponVehicle.hasWeapon(i) ? 0 : -1;
        }
        return selected;
    }

    protected void m_7378_(CompoundTag compound) {
        WeaponVehicleEntity weaponVehicle;
        this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        this.f_19804_.m_135381_(LAST_DRIVER_UUID, (Object)compound.m_128461_("LastDriver"));
        this.f_19804_.m_135381_(OVERRIDE, (Object)compound.m_128461_("Override"));
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        } else {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
        }
        this.f_19804_.m_135381_(TURRET_HEALTH, (Object)Float.valueOf(compound.m_128457_("TurretHealth")));
        this.f_19804_.m_135381_(L_WHEEL_HEALTH, (Object)Float.valueOf(compound.m_128457_("LeftWheelHealth")));
        this.f_19804_.m_135381_(R_WHEEL_HEALTH, (Object)Float.valueOf(compound.m_128457_("RightWheelHealth")));
        this.f_19804_.m_135381_(ENGINE_HEALTH, (Object)Float.valueOf(compound.m_128457_("EngineHealth")));
        this.f_19804_.m_135381_(L_ENGINE_HEALTH, (Object)Float.valueOf(compound.m_128457_("LeftEngineHealth")));
        this.f_19804_.m_135381_(TURRET_DAMAGED, (Object)compound.m_128471_("TurretDamaged"));
        this.f_19804_.m_135381_(L_WHEEL_DAMAGED, (Object)compound.m_128471_("LeftDamaged"));
        this.f_19804_.m_135381_(R_WHEEL_DAMAGED, (Object)compound.m_128471_("RightDamaged"));
        this.f_19804_.m_135381_(ENGINE1_DAMAGED, (Object)compound.m_128471_("Engine1Damaged"));
        this.f_19804_.m_135381_(ENGINE2_DAMAGED, (Object)compound.m_128471_("Engine2Damaged"));
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity)).getAllWeapons().length > 0) {
            int[] selected = compound.m_128465_("SelectedWeapon");
            if (selected.length != this.getMaxPassengers()) {
                this.f_19804_.m_135381_(SELECTED_WEAPON, (Object)IntList.of((int[])this.initSelectedWeaponArray(weaponVehicle)));
            } else {
                this.f_19804_.m_135381_(SELECTED_WEAPON, (Object)IntList.of((int[])selected));
            }
        }
        if (this.hasEnergyStorage() && (vehicleEntity = compound.m_128423_("Energy")) instanceof IntTag) {
            IntTag energyNBT = (IntTag)vehicleEntity;
            this.energyStorage.deserializeNBT((Tag)energyNBT);
        }
    }

    public void m_7380_(CompoundTag compound) {
        WeaponVehicleEntity weaponVehicle;
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128359_("Override", (String)this.f_19804_.m_135370_(OVERRIDE));
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        compound.m_128359_("LastDriver", (String)this.f_19804_.m_135370_(LAST_DRIVER_UUID));
        compound.m_128350_("TurretHealth", ((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue());
        compound.m_128350_("LeftWheelHealth", ((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue());
        compound.m_128350_("RightWheelHealth", ((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue());
        compound.m_128350_("EngineHealth", ((Float)this.f_19804_.m_135370_(ENGINE_HEALTH)).floatValue());
        compound.m_128350_("LeftEngineHealth", ((Float)this.f_19804_.m_135370_(L_ENGINE_HEALTH)).floatValue());
        compound.m_128379_("TurretDamaged", ((Boolean)this.f_19804_.m_135370_(TURRET_DAMAGED)).booleanValue());
        compound.m_128379_("LeftWheelDamaged", ((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue());
        compound.m_128379_("RightWheelDamaged", ((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue());
        compound.m_128379_("Engine1Damaged", ((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue());
        compound.m_128379_("Engine2Damaged", ((Boolean)this.f_19804_.m_135370_(ENGINE2_DAMAGED)).booleanValue());
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity)).getAllWeapons().length > 0) {
            compound.m_128385_("SelectedWeapon", ((IntList)this.f_19804_.m_135370_(SELECTED_WEAPON)).toIntArray());
        }
        if (this.hasEnergyStorage()) {
            compound.m_128365_("Energy", this.energyStorage.serializeNBT());
        }
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_20202_() == this) {
            return InteractionResult.PASS;
        }
        VehicleData data = this.data();
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.VEHICLE_DAMAGE_ANALYZER.get())) {
            if (!this.m_9236_().f_46443_) {
                if (this.damageDebugResultReceiver != null) {
                    this.damageDebugResultReceiver = null;
                    player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.unbind", (Object[])new Object[]{this.m_5446_()}), true);
                } else {
                    this.damageDebugResultReceiver = player;
                    player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.bind", (Object[])new Object[]{this.m_5446_()}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && stack.m_204117_(ModTags.Items.CROWBAR) && this.m_20197_().isEmpty()) {
            for (ItemStack item : this.getRetrieveItems()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (this.getHealth() < this.getMaxHealth() && data.canRepairManually() && data.isRepairMaterial(stack)) {
            this.heal(org.joml.Math.min((float)data.get(VehicleProp.REPAIR_MATERIAL_HEAL_AMOUNT).floatValue(), (float)this.getMaxHealth()));
            stack.m_41774_(1);
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12009_, this.m_5720_(), 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_() && this.getMaxPassengers() > 0) {
            List entities = this.m_20197_();
            for (Entity passenger : entities) {
                if (passenger.m_5647_() == null || !passenger.m_5647_().m_5758_().equals("TDM") && passenger.m_5647_() == player.m_5647_()) continue;
                return InteractionResult.PASS;
            }
            Entity lastDriver = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_DRIVER_UUID));
            if (lastDriver != null && !SeekTool.teamFilter((Entity)player, lastDriver) && lastDriver.m_5647_() != null) {
                return InteractionResult.PASS;
            }
            if (this.m_146895_() == null) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                this.setDriverAngle(player);
                player.m_6858_(false);
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            if (!(this.m_146895_() instanceof Player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                this.m_146895_().m_8127_();
                this.setDriverAngle(player);
                player.m_6858_(false);
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            if (this.m_7310_((Entity)player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                player.m_6858_(false);
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setDriverAngle(Player player) {
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof LandArmorEntity) {
            LandArmorEntity landArmorEntity = (LandArmorEntity)((Object)vehicleEntity);
            player.f_19860_ = -((float)VehicleEntity.getXRotFromVector(landArmorEntity.getBarrelVec(1.0f)));
            player.m_146926_(-((float)VehicleEntity.getXRotFromVector(landArmorEntity.getBarrelVec(1.0f))));
            player.f_19859_ = -((float)VehicleEntity.getYRotFromVector(landArmorEntity.getBarrelVec(1.0f)));
            player.m_146922_(-((float)VehicleEntity.getYRotFromVector(landArmorEntity.getBarrelVec(1.0f))));
            player.m_5616_(-((float)VehicleEntity.getYRotFromVector(landArmorEntity.getBarrelVec(1.0f))));
        } else {
            player.f_19860_ = this.m_146909_();
            player.m_146926_(this.m_146909_());
            player.f_19859_ = this.m_146908_();
            player.m_146922_(this.m_146908_());
        }
    }

    public static double getYRotFromVector(Vec3 vec3) {
        return Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.29577951308232;
    }

    public static double getXRotFromVector(Vec3 vec3) {
        double d0 = vec3.m_165924_();
        return Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.29577951308232;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity entity;
        if (source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (this.damageDebugResultReceiver != null) {
            this.damageDebugResultReceiver.m_213846_((Component)DamageHandler.getDamageInfo(this, source, amount));
        }
        float computedAmount = this.getDamageModifier().compute(source, amount);
        this.crash = source.m_276093_(ModDamageTypes.VEHICLE_STRIKE);
        if (source.m_7639_() != null) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)source.m_7639_().m_20149_());
        }
        if (computedAmount > 0.0f) {
            this.lastHurtTick = 0;
            this.repairCoolDown = this.maxRepairCoolDown();
        }
        if ((entity = source.m_7640_()) instanceof Projectile) {
            OBBHitter accessor;
            OBB.Part part;
            Projectile projectile = (Projectile)entity;
            if (this instanceof OBBEntity && (part = (accessor = OBBHitter.getInstance((Entity)projectile)).sbw$getCurrentHitPart()) != null) {
                switch (part) {
                    case TURRET: {
                        this.f_19804_.m_135381_(TURRET_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() - computedAmount));
                        break;
                    }
                    case WHEEL_LEFT: {
                        this.f_19804_.m_135381_(L_WHEEL_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() - computedAmount));
                        break;
                    }
                    case WHEEL_RIGHT: {
                        this.f_19804_.m_135381_(R_WHEEL_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() - computedAmount));
                        break;
                    }
                    case ENGINE1: {
                        this.f_19804_.m_135381_(ENGINE_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(ENGINE_HEALTH)).floatValue() - computedAmount));
                        break;
                    }
                    case ENGINE2: {
                        this.f_19804_.m_135381_(L_ENGINE_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(L_ENGINE_HEALTH)).floatValue() - computedAmount));
                    }
                }
            }
        }
        this.onHurt(computedAmount, source.m_7639_(), true);
        return super.m_6469_(source, computedAmount);
    }

    public DamageModifier getDamageModifier() {
        return this.data().damageModifier();
    }

    public float getSourceAngle(DamageSource source, float multiply) {
        Entity attacker = source.m_7640_();
        if (attacker == null) {
            attacker = source.m_7639_();
        }
        if (attacker != null) {
            Vec3 toVec = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_()).m_82505_(attacker.m_20182_()).m_82541_();
            return (float)org.joml.Math.max((double)(1.0 - (double)multiply * toVec.m_82526_(this.m_20252_(1.0f))), (double)0.5);
        }
        return 1.0f;
    }

    public void heal(float pHealAmount) {
        if (this.m_9236_() instanceof ServerLevel) {
            this.setHealth(this.getHealth() + pHealAmount);
        }
    }

    public void onHurt(float pHealAmount, Entity attacker, boolean send) {
        if (this.m_9236_() instanceof ServerLevel) {
            Holder holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION_VEHICLE.get()));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send && !(this instanceof DroneEntity)) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20188_(), player.m_20189_(), 0.25f + 2.75f * pHealAmount / this.getMaxHealth(), this.f_19796_.m_188501_() * 0.1f + 0.9f, player.m_9236_().f_46441_.m_188505_()));
                    Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(3, 5));
                }
            }
            if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send) {
                List passengers = this.m_20197_();
                for (Entity entity : passengers) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player1 = (ServerPlayer)entity;
                    player1.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player1.m_20185_(), player1.m_20188_(), player1.m_20189_(), 0.25f + 4.75f * pHealAmount / this.getMaxHealth(), this.f_19796_.m_188501_() * 0.1f + 0.6f, player1.m_9236_().f_46441_.m_188505_()));
                }
            }
            this.setHealth(this.getHealth() - pHealAmount);
        }
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    public void setHealth(float pHealth) {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)pHealth, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getMaxHealth() {
        return this.data().get(VehicleProp.MAX_HEALTH).floatValue();
    }

    public float getTurretMaxHealth() {
        return 50.0f;
    }

    public float getWheelMaxHealth() {
        return 50.0f;
    }

    public float getEngineMaxHealth() {
        return 50.0f;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return super.m_6094_();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_7313_(@NotNull Entity attacker) {
        return this.m_20363_(attacker) || super.m_7313_(attacker);
    }

    protected boolean m_7310_(@NotNull Entity pPassenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return 1;
    }

    public static double getSubmergedHeight(Entity entity) {
        for (FluidType fluidType : ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getValues()) {
            if (entity.m_9236_().m_6425_(entity.m_20183_()).getFluidType() != fluidType) continue;
            return entity.getFluidTypeHeight(fluidType);
        }
        return 0.0;
    }

    public int maxRepairCoolDown() {
        return this.data().get(VehicleProp.REPAIR_COOLDOWN);
    }

    public float repairAmount() {
        return this.data().get(VehicleProp.REPAIR_AMOUNT).floatValue();
    }

    public void m_6075_() {
        super.m_6075_();
        ++this.lastHurtTick;
        if (this.repairCoolDown > 0) {
            --this.repairCoolDown;
        }
        if ((Integer)this.f_19804_.m_135370_(HEAT) > 0) {
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(HEAT) < 40) {
            this.cannotFire = false;
        }
        if ((Integer)this.f_19804_.m_135370_(HEAT) > 100 && !this.cannotFire) {
            this.cannotFire = true;
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.MINIGUN_OVERHEAT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.prevRoll = this.getRoll();
        float delta = org.joml.Math.abs((float)(this.m_146908_() - this.f_19859_));
        while (this.m_146908_() > 180.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
            this.f_19859_ = this.m_146908_() - delta;
        }
        while (this.m_146908_() <= -180.0f) {
            this.m_146922_(this.m_146908_() + 360.0f);
            this.f_19859_ = delta + this.m_146908_();
        }
        float deltaX = org.joml.Math.abs((float)(this.m_146909_() - this.f_19860_));
        while (this.m_146909_() > 180.0f) {
            this.m_146926_(this.m_146909_() - 360.0f);
            this.f_19860_ = this.m_146909_() - deltaX;
        }
        while (this.m_146909_() <= -180.0f) {
            this.m_146926_(this.m_146909_() + 360.0f);
            this.f_19860_ = deltaX + this.m_146909_();
        }
        float deltaZ = org.joml.Math.abs((float)(this.getRoll() - this.prevRoll));
        while (this.getRoll() > 180.0f) {
            this.setZRot(this.getRoll() - 360.0f);
            this.prevRoll = this.getRoll() - deltaZ;
        }
        while (this.getRoll() <= -180.0f) {
            this.setZRot(this.getRoll() + 360.0f);
            this.prevRoll = deltaZ + this.getRoll();
        }
        this.handleClientSync();
        if (this.m_9236_() instanceof ServerLevel && this.getHealth() <= 0.0f) {
            this.destroy();
        }
        this.travel();
        Entity attacker = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        VehicleData data = this.data();
        if (this.getHealth() <= data.get(VehicleProp.SELF_HURT_PERCENT).floatValue() * this.getMaxHealth()) {
            this.onHurt(data.get(VehicleProp.SELF_HURT_AMOUNT).floatValue(), attacker, false);
        } else if (this.repairCoolDown == 0) {
            this.heal(this.repairAmount());
        }
        if (this.getMaxPassengers() > 0 && this.m_146895_() != null) {
            this.f_19804_.m_135381_(LAST_DRIVER_UUID, (Object)this.m_146895_().m_20149_());
        }
        if (this.m_20197_().isEmpty()) {
            ++this.noPassengerTime;
            if (this.noPassengerTime > 200) {
                this.f_19804_.m_135381_(LAST_DRIVER_UUID, (Object)"undefined");
            }
        } else {
            this.noPassengerTime = 0;
        }
        this.clearArrow();
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof OBBEntity) {
            OBBEntity obbEntity = (OBBEntity)((Object)vehicleEntity);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.handlePartDamaged(obbEntity, serverLevel);
            }
            this.handlePartHealth();
        }
        this.f_19804_.m_135381_(MOUSE_SPEED_X, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * 0.95f));
        this.f_19804_.m_135381_(MOUSE_SPEED_Y, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue() * 0.95f));
        this.m_6210_();
    }

    public void handlePartDamaged(OBBEntity obbEntity, ServerLevel serverLevel) {
        List<OBB> obbList = obbEntity.getOBBs();
        for (OBB obb : obbList) {
            Vec3 pos = new Vec3(obb.center());
            switch (obb.part()) {
                case TURRET: {
                    if (!((Boolean)this.f_19804_.m_135370_(TURRET_DAMAGED)).booleanValue()) break;
                    this.onTurretDamaged(pos, serverLevel);
                    break;
                }
                case WHEEL_LEFT: {
                    if (!((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue()) break;
                    this.onLeftWheelDamaged(pos, serverLevel);
                    break;
                }
                case WHEEL_RIGHT: {
                    if (!((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) break;
                    this.onRightWheelDamaged(pos, serverLevel);
                    break;
                }
                case ENGINE1: {
                    if (!((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) break;
                    this.onEngine1Damaged(pos, serverLevel);
                    break;
                }
                case ENGINE2: {
                    if (!((Boolean)this.f_19804_.m_135370_(ENGINE2_DAMAGED)).booleanValue()) break;
                    this.onEngine2Damaged(pos, serverLevel);
                }
            }
        }
    }

    public void handlePartHealth() {
        if (((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(TURRET_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() > 0.95 * (double)this.getTurretMaxHealth()) {
            this.f_19804_.m_135381_(TURRET_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(L_WHEEL_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() > 0.95 * (double)this.getWheelMaxHealth()) {
            this.f_19804_.m_135381_(L_WHEEL_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(R_WHEEL_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() > 0.95 * (double)this.getWheelMaxHealth()) {
            this.f_19804_.m_135381_(R_WHEEL_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(ENGINE_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(ENGINE1_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(ENGINE_HEALTH)).floatValue() > 0.95 * (double)this.getEngineMaxHealth()) {
            this.f_19804_.m_135381_(ENGINE1_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(L_ENGINE_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(ENGINE2_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(L_ENGINE_HEALTH)).floatValue() > 0.95 * (double)this.getEngineMaxHealth()) {
            this.f_19804_.m_135381_(ENGINE2_DAMAGED, (Object)false);
        }
        this.f_19804_.m_135381_(TURRET_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() + 0.0025f * this.getTurretMaxHealth()), (float)this.getTurretMaxHealth())));
        this.f_19804_.m_135381_(L_WHEEL_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() + 0.0025f * this.getWheelMaxHealth()), (float)this.getWheelMaxHealth())));
        this.f_19804_.m_135381_(R_WHEEL_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() + 0.0025f * this.getWheelMaxHealth()), (float)this.getWheelMaxHealth())));
        this.f_19804_.m_135381_(ENGINE_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(ENGINE_HEALTH)).floatValue() + 0.0025f * this.getEngineMaxHealth()), (float)this.getEngineMaxHealth())));
        this.f_19804_.m_135381_(L_ENGINE_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(L_ENGINE_HEALTH)).floatValue() + 0.0025f * this.getEngineMaxHealth()), (float)this.getEngineMaxHealth())));
    }

    public void defaultPartDamageEffect(Vec3 pos, ServerLevel serverLevel) {
        ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 5, 0.25, 0.25, 0.25, 0.25, true);
        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 1.0, 0.5, 1.0, 0.01, true);
    }

    public void onTurretDamaged(Vec3 pos, ServerLevel serverLevel) {
        this.defaultPartDamageEffect(pos, serverLevel);
    }

    public void onLeftWheelDamaged(Vec3 pos, ServerLevel serverLevel) {
        this.defaultPartDamageEffect(pos, serverLevel);
    }

    public void onRightWheelDamaged(Vec3 pos, ServerLevel serverLevel) {
        this.defaultPartDamageEffect(pos, serverLevel);
    }

    public void onEngine1Damaged(Vec3 pos, ServerLevel serverLevel) {
        this.defaultPartDamageEffect(pos, serverLevel);
    }

    public void onEngine2Damaged(Vec3 pos, ServerLevel serverLevel) {
        this.defaultPartDamageEffect(pos, serverLevel);
    }

    public void clearArrow() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(0.0, 0.5, 0.0));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof AbstractArrow)) continue;
                entity.m_146870_();
            }
        }
    }

    public void lowHealthWarning() {
        ServerLevel serverLevel;
        Level level;
        if ((double)this.getHealth() <= 0.4 * (double)this.getMaxHealth() && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_(), 2, 0.35 * (double)this.m_20205_(), 0.15 * (double)this.m_20206_(), 0.35 * (double)this.m_20205_(), 0.01, true);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if ((double)this.getHealth() <= 0.25 * (double)this.getMaxHealth()) {
                this.playLowHealthParticle(serverLevel);
            }
            if ((double)this.getHealth() <= 0.15 * (double)this.getMaxHealth()) {
                this.playLowHealthParticle(serverLevel);
            }
        }
        if ((double)this.getHealth() <= 0.1 * (double)this.getMaxHealth()) {
            level = this.m_9236_();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_(), 2, 0.35 * (double)this.m_20205_(), 0.15 * (double)this.m_20206_(), 0.35 * (double)this.m_20205_(), 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_(), 2, 0.35 * (double)this.m_20205_(), 0.15 * (double)this.m_20206_(), 0.35 * (double)this.m_20205_(), 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)(0.85f * this.m_20206_()), this.m_20189_(), 4, 0.35 * (double)this.m_20205_(), 0.12 * (double)this.m_20206_(), 0.35 * (double)this.m_20205_(), 0.05, true);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.m_20185_(), this.m_20186_() + (double)(0.85f * this.m_20206_()), this.m_20189_(), 4, 0.1 * (double)this.m_20205_(), 0.05 * (double)this.m_20206_(), 0.1 * (double)this.m_20205_(), 0.4, true);
            }
            if (this.f_19797_ % 15 == 0) {
                this.m_9236_().m_5594_(null, this.m_20097_(), SoundEvents.f_11936_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (this.getHealth() < 0.1f * this.getMaxHealth() && this.f_19797_ % 13 == 0) {
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.NO_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (this.getHealth() >= 0.1f && this.getHealth() < 0.4f * this.getMaxHealth() && this.f_19797_ % 10 == 0) {
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.LOW_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void playLowHealthParticle(ServerLevel serverLevel) {
        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_(), 1, 0.35 * (double)this.m_20205_(), 0.15 * (double)this.m_20206_(), 0.35 * (double)this.m_20205_(), 0.01, true);
        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_(), 1, 0.35 * (double)this.m_20205_(), 0.15 * (double)this.m_20206_(), 0.35 * (double)this.m_20205_(), 0.01, true);
    }

    public void turretAngle(float ySpeed, float xSpeed) {
        Entity driver = this.m_146895_();
        if (driver != null) {
            float turretAngle = -Mth.m_14177_((float)(driver.m_6080_() - this.m_146908_()));
            float diffY = Mth.m_14177_((float)(turretAngle - this.getTurretYRot()));
            float diffX = Mth.m_14177_((float)(driver.m_146909_() - this.getTurretXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            if (((Boolean)this.f_19804_.m_135370_(TURRET_DAMAGED)).booleanValue()) {
                ySpeed *= 0.2f;
                xSpeed *= 0.2f;
            }
            float min = -ySpeed + (float)(this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue();
            float max = ySpeed + (float)(this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue();
            this.setTurretXRot(this.getTurretXRot() + Mth.m_14036_((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed));
            this.setTurretYRot(this.getTurretYRot() + Mth.m_14036_((float)(0.9f * diffY), (float)min, (float)max));
            this.turretYRotLock = Mth.m_14036_((float)(0.9f * diffY), (float)min, (float)max);
        } else {
            this.turretYRotLock = 0.0f;
        }
    }

    public void turretAutoAimFormVector(float ySpeed, float xSpeed, float minXAngle, float maxXAngle, Vec3 shootVec) {
        float diffY = (float)Mth.m_14175_((double)(-VehicleEntity.getYRotFromVector(shootVec) + VehicleEntity.getYRotFromVector(this.getBarrelVec(1.0f))));
        float diffX = (float)Mth.m_14175_((double)(-VehicleEntity.getXRotFromVector(shootVec) + VehicleEntity.getXRotFromVector(this.getBarrelVec(1.0f))));
        this.turretTurnSound(diffX, diffY, 0.95f);
        if (((Boolean)this.f_19804_.m_135370_(TURRET_DAMAGED)).booleanValue()) {
            ySpeed *= 0.2f;
            xSpeed *= 0.2f;
        }
        float min = -ySpeed + (float)(this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue();
        float max = ySpeed + (float)(this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue();
        this.setTurretXRot(Mth.m_14036_((float)(this.getTurretXRot() + Mth.m_14036_((float)(0.5f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)(-maxXAngle), (float)(-minXAngle)));
        this.setTurretYRot(this.getTurretYRot() - Mth.m_14036_((float)(0.5f * diffY), (float)min, (float)max));
        this.turretYRotLock = Mth.m_14036_((float)(0.9f * diffY), (float)min, (float)max);
    }

    public void passengerWeaponAutoAimFormVector(float ySpeed, float xSpeed, float minXAngle, float maxXAngle, Vec3 shootVec) {
        float diffY = (float)Mth.m_14175_((double)(-VehicleEntity.getYRotFromVector(shootVec) + VehicleEntity.getYRotFromVector(this.getGunnerVector(1.0f))));
        float diffX = (float)Mth.m_14175_((double)(-VehicleEntity.getXRotFromVector(shootVec) + VehicleEntity.getXRotFromVector(this.getGunnerVector(1.0f))));
        this.turretTurnSound(diffX, diffY, 0.95f);
        this.setGunXRot(Mth.m_14036_((float)(this.getGunXRot() + Mth.m_14036_((float)(0.5f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)(-maxXAngle), (float)(-minXAngle)));
        this.setGunYRot(this.getGunYRot() - Mth.m_14036_((float)(0.5f * diffY), (float)(-ySpeed), (float)ySpeed));
    }

    public void gunnerAngle(float ySpeed, float xSpeed) {
        Entity gunner = this.getNthEntity(1);
        float diffY = 0.0f;
        float diffX = 0.0f;
        float speed = 1.0f;
        if (gunner instanceof Player) {
            float gunAngle = -Mth.m_14177_((float)(gunner.m_6080_() - this.m_146908_()));
            diffY = Mth.m_14177_((float)(gunAngle - this.getGunYRot()));
            diffX = Mth.m_14177_((float)(gunner.m_146909_() - this.getGunXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            speed = 0.0f;
        }
        this.setGunXRot(this.getGunXRot() + Mth.m_14036_((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed));
        this.setGunYRot(this.getGunYRot() + Mth.m_14036_((float)(0.9f * diffY), (float)(-ySpeed), (float)ySpeed) + speed * this.turretYRotLock);
    }

    public void destroy() {
        Float radius;
        VehicleData data = this.data();
        if (data.get(VehicleProp.EXPLODE_PASSENGERS_ON_DESTROY).booleanValue()) {
            if (this.crash && data.get(VehicleProp.CRASH_PASSENGERS_ON_DESTROY).booleanValue()) {
                this.crashPassengers();
            } else {
                this.explodePassengers();
            }
        }
        if ((radius = data.get(VehicleProp.EXPLOSION_RADIUS)).floatValue() > 0.0f) {
            Float damage = data.get(VehicleProp.EXPLOSION_DAMAGE);
            ParticleTool.ParticleType particleType = data.get(VehicleProp.EXPLOSION_PARTICLE_TYPE);
            Boolean causeVanillaExplosion = data.get(VehicleProp.CAUSE_VANILLA_EXPLOSION);
            CustomExplosion.Builder explosion = this.createCustomExplosion().radius(radius.floatValue()).damage(damage.floatValue()).withParticleType(particleType);
            if (causeVanillaExplosion.booleanValue()) {
                explosion.causeVanillaExplosion();
            }
            if (!data.get(VehicleProp.EXPLOSION_DESTROY_BLOCK_ON_DESTROY).booleanValue()) {
                explosion.keepBlock();
            }
            explosion.explode();
        }
        this.m_146870_();
    }

    public CustomExplosion.Builder createCustomExplosion() {
        return new CustomExplosion.Builder(this).attacker(this.getAttacker());
    }

    protected Entity getAttacker() {
        return EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
    }

    protected void crashPassengers() {
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            Entity tempAttacker = living == this.getAttacker() ? null : this.getAttacker();
            living.m_6469_(ModDamageTypes.causeAirCrashDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeAirCrashDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeAirCrashDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeAirCrashDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeAirCrashDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
        }
    }

    protected void explodePassengers() {
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            Entity tempAttacker = living == this.getAttacker() ? null : this.getAttacker();
            living.m_6469_(ModDamageTypes.causeVehicleExplosionDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeVehicleExplosionDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeVehicleExplosionDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeVehicleExplosionDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
            living.f_19802_ = 0;
            living.m_6469_(ModDamageTypes.causeVehicleExplosionDamage(this.m_9236_().m_9598_(), null, tempAttacker), 2.1474836E9f);
        }
    }

    public void travel() {
    }

    public Matrix4f getVehicleYOffsetTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)this.rotateYOffset()), (double)(this.m_20186_() + (double)this.rotateYOffset())), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transformV = this.getVehicleYOffsetTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, -this.rotateYOffset(), 0.0f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        return transformV;
    }

    public float rotateYOffset() {
        return 0.0f;
    }

    public Matrix4f getVehicleFlatTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19855_, (double)this.m_20186_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public Matrix4f getVehicleHorizontalTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19855_, (double)this.m_20186_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        return transform;
    }

    public Matrix4f getTurretTransform(float ticks) {
        return this.getVehicleTransform(ticks);
    }

    public Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        return transform.transform(new Vector4f(x, y, z, 1.0f));
    }

    public static Quaternionf eulerToQuaternion(float yaw, float pitch, float roll) {
        double cy = org.joml.Math.cos((double)((double)yaw * 0.5 * 0.01745329238474369));
        double sy = org.joml.Math.sin((double)((double)yaw * 0.5 * 0.01745329238474369));
        double cp = org.joml.Math.cos((double)((double)pitch * 0.5 * 0.01745329238474369));
        double sp = org.joml.Math.sin((double)((double)pitch * 0.5 * 0.01745329238474369));
        double cr = org.joml.Math.cos((double)((double)roll * 0.5 * 0.01745329238474369));
        double sr = org.joml.Math.sin((double)((double)roll * 0.5 * 0.01745329238474369));
        Quaternionf q = new Quaternionf();
        q.w = (float)(cy * cp * cr + sy * sp * sr);
        q.x = (float)(cy * cp * sr - sy * sp * cr);
        q.y = (float)(sy * cp * sr + cy * sp * cr);
        q.z = (float)(sy * cp * cr - cy * sp * sr);
        return q;
    }

    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.m_20185_() + (this.x - this.m_20185_()) / (double)this.interpolationSteps;
        double interpolatedY = this.m_20186_() + (this.y - this.m_20186_()) / (double)this.interpolationSteps;
        double interpolatedZ = this.m_20189_() + (this.z - this.m_20189_()) / (double)this.interpolationSteps;
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_6034_(interpolatedX, interpolatedY, interpolatedZ);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        --this.interpolationSteps;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    public static double calculateAngle(Vec3 move, Vec3 view) {
        move = move.m_82542_(1.0, 0.0, 1.0).m_82541_();
        view = view.m_82542_(1.0, 0.0, 1.0).m_82541_();
        return VectorTool.calculateAngle(move, view);
    }

    protected Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        double offset = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 1.75;
        float yaw = this.m_146908_() + 90.0f;
        float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)));
        float n = org.joml.Math.max((float)org.joml.Math.abs((float)x), (float)org.joml.Math.abs((float)z));
        return new Vec3((double)x * offset / (double)n, 0.0, (double)z * offset / (double)n);
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        int index = this.getTagSeatIndex((Entity)passenger);
        if (index < 0) {
            return super.m_7688_(passenger);
        }
        return this.getDismountLocationForIndex(passenger, index);
    }

    @NotNull
    public Vec3 getDismountLocationForIndex(LivingEntity passenger, int index) {
        Vec3 vec3d = this.getDismountOffset(this.m_20205_() * Mth.f_13994_, passenger.m_20205_() * Mth.f_13994_);
        double ox = this.m_20185_() - vec3d.f_82479_;
        double oz = this.m_20189_() + vec3d.f_82481_;
        BlockPos exitPos = new BlockPos((int)ox, (int)this.m_20186_(), (int)oz);
        BlockPos floorPos = exitPos.m_7495_();
        if (!this.m_9236_().m_46801_(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.m_9236_().m_45573_(exitPos);
            if (DismountHelper.m_38439_((double)exitHeight)) {
                list.add(new Vec3(ox, (double)exitPos.m_123342_() + exitHeight, oz));
            }
            if (DismountHelper.m_38439_((double)(floorHeight = this.m_9236_().m_45573_(floorPos)))) {
                list.add(new Vec3(ox, (double)floorPos.m_123342_() + floorHeight, oz));
            }
            for (Pose entityPose : passenger.m_7431_()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.m_20124_(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    @NotNull
    public Vec3 getDismountMovement(LivingEntity passenger, int index) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean allowEjection() {
        return false;
    }

    public void removeSeatIndexTag(Entity entity) {
        entity.getPersistentData().m_128473_(TAG_SEAT_INDEX);
    }

    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/gun_icon/default_icon.png");
    }

    public boolean allowFreeCam() {
        return this.data().get(VehicleProp.ALLOW_FREE_CAM);
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public Vec3 getNewEyePos(float pPartialTicks) {
        return this.m_146892_();
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        return this.m_20171_(this.getBarrelXRot(pPartialTicks), this.getBarrelYRot(pPartialTicks));
    }

    public Vec3 getGunnerVector(float pPartialTicks) {
        return this.m_20252_(pPartialTicks);
    }

    public float getBarrelXRot(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)(this.turretXRotO - this.f_19860_), (float)(this.getTurretXRot() - this.m_146909_()));
    }

    public float getBarrelYRot(float pPartialTick) {
        return -Mth.m_14179_((float)pPartialTick, (float)(this.turretYRotO - this.f_19859_), (float)(this.getTurretYRot() - this.m_146908_()));
    }

    public Vec3 getGunVector(float pPartialTicks) {
        return this.m_20171_(this.getGunXRot(pPartialTicks), this.getGunYRot(pPartialTicks));
    }

    public float getGunXRot(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)(this.gunXRotO - this.f_19860_), (float)(this.getGunXRot() - this.m_146909_()));
    }

    public float getGunYRot(float pPartialTick) {
        return -Mth.m_14179_((float)pPartialTick, (float)(this.gunYRotO - this.f_19859_), (float)(this.getGunYRot() - this.m_146908_()));
    }

    public float turretYRotO() {
        return this.turretYRotO;
    }

    public float turretYRot() {
        return this.turretYRot;
    }

    public float turretXRotO() {
        return this.turretXRotO;
    }

    public float turretXRot() {
        return this.turretXRot;
    }

    public Vec3 getBarrelVec(float ticks) {
        return this.getBarrelVector(ticks);
    }

    public Vec3 getGunVec(float ticks) {
        return this.getGunVector(ticks);
    }

    public float getTurretYRot() {
        return this.turretYRot;
    }

    public float getTurretYaw(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.turretYRotO, (float)this.getTurretYRot());
    }

    public void setTurretYRot(float pTurretYRot) {
        this.turretYRot = pTurretYRot;
    }

    public float getTurretXRot() {
        return this.turretXRot;
    }

    public void setTurretXRot(float pTurretXRot) {
        this.turretXRot = pTurretXRot;
    }

    public float getTurretPitch(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.turretXRotO, (float)this.getTurretXRot());
    }

    public float getGunYRot() {
        return this.gunYRot;
    }

    public void setGunYRot(float pGunYRot) {
        this.gunYRot = pGunYRot;
    }

    public float getGunXRot() {
        return this.gunXRot;
    }

    public void setGunXRot(float pGunXRot) {
        this.gunXRot = pGunXRot;
    }

    public Vec3 driverZoomPos(float ticks) {
        return this.m_146892_();
    }

    public double getMouseSensitivity() {
        return 0.1;
    }

    public double getMouseSpeedX() {
        return 0.4;
    }

    public double getMouseSpeedY() {
        return 0.4;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getMass() {
        return this.data().get(VehicleProp.MASS).floatValue();
    }

    public void m_20256_(Vec3 pDeltaMovement) {
        Vec3 acceleration;
        Vec3 currentMomentum = this.m_20184_();
        double currentSpeedSq = currentMomentum.m_82556_();
        double newSpeedSq = pDeltaMovement.m_82556_();
        if (newSpeedSq > currentSpeedSq && (acceleration = pDeltaMovement.m_82546_(currentMomentum)).m_82556_() > 8.0) {
            Vec3 limitedAcceleration = acceleration.m_82541_().m_82490_(0.125);
            Vec3 finalMomentum = currentMomentum.m_82549_(limitedAcceleration);
            super.m_20256_(finalMomentum);
            return;
        }
        super.m_20256_(pDeltaMovement);
    }

    public void m_246865_(Vec3 pAddend) {
        double length = pAddend.m_82553_();
        if (length > 0.1) {
            pAddend = pAddend.m_82490_(0.1 / length);
        }
        super.m_246865_(pAddend);
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return original;
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return null;
    }

    public boolean isEnclosed(int index) {
        return this.hidePassenger(index);
    }

    public boolean isEnclosed(Entity passenger) {
        return this.isEnclosed(this.getSeatIndex(passenger));
    }

    public boolean hidePassenger(int index) {
        return false;
    }

    public boolean hidePassenger(Entity passenger) {
        return this.hidePassenger(this.getSeatIndex(passenger));
    }

    @Nullable
    public ItemStack m_142340_() {
        if (!this.getRetrieveItems().isEmpty()) {
            return this.getRetrieveItems().get(0);
        }
        return ContainerBlockItem.createInstance(this.m_6095_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        VehicleEntity vehicleEntity = this;
        if (!(vehicleEntity instanceof WeaponVehicleEntity)) {
            return;
        }
        WeaponVehicleEntity weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity);
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        float minWH = org.joml.Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        ResourceLocation texture = Mod.loc(switch (weaponVehicle.getWeaponIndex(0)) {
            case 0 -> "textures/screens/land/lav_cannon_cross.png";
            case 1 -> "textures/screens/land/lav_gun_cross.png";
            case 2 -> "textures/screens/land/lav_missile_cross.png";
            default -> "";
        });
        if (texture.m_135815_().isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.preciseBlit(guiGraphics, texture, centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && this.hasEnergyStorage()) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.hasContainer()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.getCapability(cap, null);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.hasContainer()) {
            this.itemHandler.invalidate();
        }
        if (this.hasEnergyStorage()) {
            this.energy.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        if (this.hasContainer()) {
            this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
        }
        if (this.hasEnergyStorage()) {
            this.energy = LazyOptional.of(() -> new VehicleEnergyStorage(this));
        }
    }

    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(ContainerBlockItem.createInstance(this));
    }
}

