/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.damage;

import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModify;
import com.atsuishio.superbwarfare.tools.FormatTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class DamageModifier {
    private final List<DamageModify> immuneList = new ArrayList<DamageModify>();
    private final List<DamageModify> reduceList = new ArrayList<DamageModify>();
    private final List<DamageModify> multiplyList = new ArrayList<DamageModify>();
    private final List<BiFunction<DamageSource, Float, Float>> customList = new ArrayList<BiFunction<DamageSource, Float, Float>>();

    public static DamageModifier createDefaultModifier() {
        return new DamageModifier().immuneTo(EntityType.f_20486_).immuneTo(EntityType.f_20476_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268671_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268585_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268722_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268482_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268493_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268641_);
    }

    public DamageModifier immuneTo() {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f));
        return this;
    }

    public DamageModifier immuneTo(TagKey<DamageType> sourceTagKey) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, sourceTagKey));
        return this;
    }

    public DamageModifier immuneTo(ResourceKey<DamageType> sourceKey) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, sourceKey));
        return this;
    }

    public DamageModifier immuneTo(Function<DamageSource, Boolean> condition) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, condition));
        return this;
    }

    public DamageModifier immuneTo(String entityId) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, entityId));
        return this;
    }

    public DamageModifier immuneTo(EntityType<?> type) {
        return this.immuneTo(EntityType.m_20613_(type).toString());
    }

    public DamageModifier reduce(float value) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value));
        return this;
    }

    public DamageModifier reduce(float value, TagKey<DamageType> sourceTagKey) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, sourceTagKey));
        return this;
    }

    public DamageModifier reduce(float value, ResourceKey<DamageType> sourceKey) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, sourceKey));
        return this;
    }

    public DamageModifier reduce(float value, Function<DamageSource, Boolean> condition) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, condition));
        return this;
    }

    public DamageModifier reduce(float value, String entityId) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, entityId));
        return this;
    }

    public DamageModifier reduce(float value, EntityType<?> type) {
        return this.reduce(value, EntityType.m_20613_(type).toString());
    }

    public DamageModifier multiply(float value) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value));
        return this;
    }

    public DamageModifier multiply(float value, TagKey<DamageType> sourceTagKey) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, sourceTagKey));
        return this;
    }

    public DamageModifier multiply(float value, ResourceKey<DamageType> sourceKey) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, sourceKey));
        return this;
    }

    public DamageModifier multiply(float value, Function<DamageSource, Boolean> condition) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, condition));
        return this;
    }

    public DamageModifier multiply(float value, String entityId) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, entityId));
        return this;
    }

    public DamageModifier multiply(float value, EntityType<?> type) {
        return this.multiply(value, EntityType.m_20613_(type).toString());
    }

    public DamageModifier custom(BiFunction<DamageSource, Float, Float> damageModifyFunction) {
        this.customList.add(damageModifyFunction);
        return this;
    }

    public DamageModifier addAll(List<DamageModify> list) {
        for (DamageModify damageModify : list) {
            switch (damageModify.type) {
                case IMMUNITY: {
                    this.immuneList.add(damageModify);
                    break;
                }
                case REDUCE: {
                    this.reduceList.add(damageModify);
                    break;
                }
                case MULTIPLY: {
                    this.multiplyList.add(damageModify);
                }
            }
        }
        return this;
    }

    public List<DamageModify> toList() {
        ArrayList<DamageModify> list = new ArrayList<DamageModify>();
        list.addAll(this.immuneList);
        list.addAll(this.reduceList);
        list.addAll(this.multiplyList);
        return list;
    }

    public List<DamageModify> match(DamageSource source) {
        return this.toList().stream().filter(m -> m.match(source)).toList();
    }

    public List<ModifyResult> matchResult(DamageSource source, float damage) {
        List<DamageModify> matchList = this.match(source);
        ArrayList<ModifyResult> list = new ArrayList<ModifyResult>();
        for (DamageModify damageModify : matchList) {
            damage = damageModify.compute(damage);
            list.add(new ModifyResult(damageModify, damage));
            if (!(damage <= 0.0f)) continue;
            return list;
        }
        for (BiFunction biFunction : this.customList) {
            damage = ((Float)biFunction.apply(source, Float.valueOf(damage))).floatValue();
            list.add(new ModifyResult(null, damage));
            if (!(damage <= 0.0f)) continue;
            break;
        }
        return list;
    }

    public float compute(DamageSource source, float damage) {
        List<DamageModify> matchList = this.match(source);
        for (DamageModify damageModify : matchList) {
            damage = damageModify.compute(damage);
            if (!(damage <= 0.0f)) continue;
            return 0.0f;
        }
        for (BiFunction biFunction : this.customList) {
            damage = ((Float)biFunction.apply(source, Float.valueOf(damage))).floatValue();
            if (!(damage <= 0.0f)) continue;
            return 0.0f;
        }
        return damage;
    }

    public record ModifyResult(@Nullable DamageModify modify, float damage) {
        public MutableComponent getDamageInfo() {
            int color;
            if (this.modify == null) {
                return Component.m_237115_((String)"tips.superbwarfare.modify_result.function").m_130938_(style -> style.m_178520_(14810987)).m_7220_((Component)Component.m_237113_((String)(" " + FormatTool.format2D(this.damage))).m_130940_(ChatFormatting.WHITE));
            }
            String sourceString = switch (this.modify.sourceType) {
                default -> throw new IncompatibleClassChangeError();
                case DamageModify.SourceType.TAG_KEY -> {
                    color = 16750718;
                    yield this.modify.sourceTagKey.f_203868_();
                }
                case DamageModify.SourceType.ENTITY_TAG -> {
                    color = 16765054;
                    yield this.modify.entityTag.f_203868_();
                }
                case DamageModify.SourceType.FUNCTION -> {
                    color = 14810987;
                    yield "";
                }
                case DamageModify.SourceType.ENTITY_ID -> {
                    color = 7071487;
                    yield this.modify.entityId;
                }
                case DamageModify.SourceType.RESOURCE_KEY -> {
                    color = 7043839;
                    yield this.modify.sourceKey.m_135782_();
                }
                case DamageModify.SourceType.ALL -> {
                    color = 16739295;
                    yield "";
                }
            };
            MutableComponent typeString = switch (this.modify.type) {
                default -> throw new IncompatibleClassChangeError();
                case DamageModify.ModifyType.IMMUNITY -> Component.m_237113_((String)" 0").m_130940_(ChatFormatting.GRAY);
                case DamageModify.ModifyType.REDUCE -> Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)("" + this.modify.value)).m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(" = " + FormatTool.format2D(this.damage))).m_130940_(ChatFormatting.WHITE));
                case DamageModify.ModifyType.MULTIPLY -> Component.m_237113_((String)" * ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)("" + this.modify.value)).m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(" = " + FormatTool.format2D(this.damage))).m_130940_(ChatFormatting.WHITE));
                case DamageModify.ModifyType.INVALID -> Component.m_237113_((String)"INVALID!").m_130940_(ChatFormatting.RED);
            };
            MutableComponent component = Component.m_237110_((String)("tips.superbwarfare.modify_result." + this.modify.sourceType.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{sourceString}).m_130938_(style -> style.m_178520_(color));
            return component.m_7220_((Component)typeString);
        }
    }
}

