/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.capability.energy.ItemEnergyProvider;
import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class BatteryItem
extends Item {
    private final Supplier<Integer> energyCapacity;
    public int maxEnergy;

    public BatteryItem(int maxEnergy, Item.Properties properties) {
        super(properties.m_41487_(1));
        this.maxEnergy = maxEnergy;
        this.energyCapacity = () -> maxEnergy;
    }

    public boolean m_142522_(ItemStack pStack) {
        return pStack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) != this.maxEnergy;
    }

    public int m_142158_(ItemStack pStack) {
        Integer energy = pStack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        return Math.round((float)energy.intValue() * 13.0f / (float)this.maxEnergy);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack, this.energyCapacity.get());
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return 0xFFFF00;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new CellImageComponent(pStack));
    }

    public ItemStack makeFullEnergyStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> e.receiveEnergy(this.maxEnergy, false));
        return stack;
    }
}

