/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.LaserCapability;
import com.atsuishio.superbwarfare.capability.LaserHandler;
import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.entity.projectile.LaserEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.network.message.send.LaserShootMessage;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BeamTest
extends Item {
    public BeamTest() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_9236_().f_46443_) {
            player.m_5496_((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_1P.get(), 1.0f, 1.0f);
        } else {
            player.m_5496_((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_3P.get(), 2.0f, 1.0f);
        }
        player.getCapability(ModCapabilities.LASER_CAPABILITY).ifPresent(capability -> {
            player.m_6672_(hand);
            if (!level.f_46443_) {
                double px = player.m_20185_();
                double py = player.m_20186_() + (double)(player.m_20206_() * 0.6f);
                double pz = player.m_20189_();
                float yHeadRotAngle = (float)Math.toRadians(player.f_20885_ + 90.0f);
                float xHeadRotAngle = (float)(-Math.toRadians(player.m_146909_()));
                LaserEntity laserEntity = new LaserEntity(player.m_9236_(), (LivingEntity)player, px, py, pz, yHeadRotAngle, xHeadRotAngle, 6000);
                capability.init(new LaserHandler((LivingEntity)player, laserEntity));
                capability.start();
            }
        });
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(ModCapabilities.LASER_CAPABILITY).ifPresent(LaserCapability.ILaserCapability::stop);
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Item item = stack.m_41720_();
            if (item instanceof BeamTest) {
                BeamTest beamTest = (BeamTest)item;
                BeamTest.stopGunChargeSound(serverPlayer, beamTest);
            }
        }
        super.m_5551_(stack, level, livingEntity, timeCharged);
    }

    private static void stopGunChargeSound(ServerPlayer player, BeamTest beamTest) {
        beamTest.getChargeSound().forEach(sound -> {
            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(sound.m_11660_(), SoundSource.PLAYERS);
            Vec3 center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
            for (ServerPlayer serverPlayer : player.m_9236_().m_6443_(ServerPlayer.class, new AABB(center, center).m_82400_(48.0), e -> true)) {
                serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        });
    }

    public Set<SoundEvent> getChargeSound() {
        return Set.of((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_1P.get(), (SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_3P.get());
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.getCapability(ModCapabilities.LASER_CAPABILITY).ifPresent(LaserCapability.ILaserCapability::stop);
            player.m_36335_().m_41524_(pStack.m_41720_(), 20);
            if (player.m_9236_().m_5776_()) {
                BeamTest.beamShoot(player);
                player.m_5496_((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_BOOM_1P.get(), 1.0f, 1.0f);
            }
            if (!player.m_9236_().f_46443_) {
                player.m_5496_((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_BOOM_3P.get(), 4.0f, 1.0f);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShakeClientMessage(10.0, 10.0, 30.0, serverPlayer.m_20185_(), serverPlayer.m_20188_(), serverPlayer.m_20189_()));
            }
        }
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public static void beamShoot(Player player) {
        Player player_;
        boolean canAttack;
        Entity lookingEntity = TraceTool.laserfindLookingEntity((Entity)player, 512.0);
        if (lookingEntity == null) {
            return;
        }
        boolean bl = canAttack = lookingEntity != player && (!(lookingEntity instanceof Player) || !(player_ = (Player)lookingEntity).m_7500_() && !player_.m_5833_()) && (!player.m_7307_(lookingEntity) || lookingEntity.m_5647_() == null || lookingEntity.m_5647_().m_5758_().equals("TDM"));
        if (canAttack) {
            Mod.PACKET_HANDLER.sendToServer((Object)new LaserShootMessage(45.0, lookingEntity.m_20148_(), TraceTool.laserHeadshot));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 11;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        TooltipTool.addDevelopingText(pTooltipComponents);
    }
}

