/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.HandGrenadeEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.DispenserLaunchable;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HandGrenade
extends Item
implements DispenserLaunchable {
    public HandGrenade() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.GRENADE_PULL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!worldIn.f_46443_ && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int usingTime = this.m_8105_(stack) - timeLeft;
            if (usingTime > 3) {
                player.m_36335_().m_41524_(stack.m_41720_(), 25);
                float power = Math.min((float)usingTime / 10.0f, 1.5f);
                HandGrenadeEntity handGrenade = new HandGrenadeEntity((LivingEntity)player, worldIn, 100 - usingTime);
                handGrenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power, 0.0f);
                worldIn.m_7967_((Entity)handGrenade);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.f_46443_) {
            Player player;
            HandGrenadeEntity handGrenade = new HandGrenadeEntity(pLivingEntity, pLevel, 100);
            new CustomExplosion.Builder((Entity)handGrenade).attacker((Entity)pLivingEntity).damage(((Integer)ExplosionConfig.M67_GRENADE_EXPLOSION_DAMAGE.get()).intValue()).radius(((Integer)ExplosionConfig.M67_GRENADE_EXPLOSION_RADIUS.get()).intValue()).causeVanillaExplosion().damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
            if (pLivingEntity instanceof Player) {
                player = (Player)pLivingEntity;
                player.m_36335_().m_41524_(pStack.m_41720_(), 25);
            }
            if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).m_7500_()) {
                pStack.m_41774_(1);
            }
        }
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 100;
    }

    @Override
    public DispenseItemBehavior getLaunchBehavior() {
        return new AbstractProjectileDispenseBehavior(){

            @ParametersAreNonnullByDefault
            @NotNull
            protected Projectile m_6895_(Level pLevel, Position pPosition, ItemStack pStack) {
                return new HandGrenadeEntity((EntityType<? extends HandGrenadeEntity>)((EntityType)ModEntities.HAND_GRENADE.get()), pPosition.m_7096_(), pPosition.m_7098_(), pPosition.m_7094_(), pLevel);
            }

            protected void m_6823_(@NotNull BlockSource pSource) {
                pSource.m_7727_().m_5594_(null, pSource.m_7961_(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        };
    }
}

