/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.ammo;

import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.FormatTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmmoBox
extends Item {
    private static final List<String> ammoTypeList = AmmoBox.generateAmmoTypeList();

    public AmmoBox() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        CompoundTag tag = stack.m_41784_();
        player.m_36335_().m_41524_((Item)this, 10);
        String type = tag.m_128461_("Type").isEmpty() ? "All" : tag.m_128461_("Type");
        PlayerVariable.modify((Entity)player, cap -> {
            Ammo[] types;
            Ammo[] ammoArray;
            if (type.equals("All") || tag.m_128471_("IsDrop")) {
                ammoArray = Ammo.values();
            } else {
                Ammo[] ammoArray2 = new Ammo[1];
                ammoArray = ammoArray2;
                ammoArray2[0] = Ammo.getType(type);
            }
            for (Ammo ammoType : types = ammoArray) {
                if (ammoType == null) {
                    return;
                }
                if (player.m_6047_() && !tag.m_128471_("IsDrop")) {
                    ammoType.add(tag, ammoType.get((PlayerVariable)cap));
                    ammoType.set((PlayerVariable)cap, 0);
                    continue;
                }
                ammoType.add((PlayerVariable)cap, ammoType.get(tag));
                ammoType.set(tag, 0);
            }
            if (!level.m_5776_()) {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (tag.m_128471_("IsDrop")) {
                stack.m_41774_(1);
            }
        });
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private static List<String> generateAmmoTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("All");
        for (Ammo ammoType : Ammo.values()) {
            list.add(ammoType.serializationName);
        }
        return list;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_6047_()) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128471_("IsDrop")) {
                return false;
            }
            int index = Math.max(0, ammoTypeList.indexOf(tag.m_128461_("Type")));
            String typeString = ammoTypeList.get((index + 1) % ammoTypeList.size());
            tag.m_128359_("Type", typeString);
            entity.m_5496_((SoundEvent)ModSounds.FIRE_RATE.get(), 1.0f, 1.0f);
            Ammo type = Ammo.getType(typeString);
            if (type == null) {
                player.m_5661_((Component)Component.m_237115_((String)"des.superbwarfare.ammo_box.type.all").m_130940_(ChatFormatting.WHITE), true);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)("des.superbwarfare.ammo_box.type." + type.name)).m_130940_(type.color), true);
        }
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        Ammo type = Ammo.getType(stack.m_41784_().m_128461_("Type"));
        tooltip.add((Component)Component.m_237115_((String)"des.superbwarfare.ammo_box").m_130940_(ChatFormatting.GRAY));
        for (Ammo ammo : Ammo.values()) {
            tooltip.add((Component)Component.m_237115_((String)("des.superbwarfare.ammo_box." + ammo.name)).m_130940_(ammo.color).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(FormatTool.format0D(ammo.get(stack)) + (type != ammo ? " " : " \u2190-"))).m_130940_(ChatFormatting.BOLD)));
        }
    }
}

