/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.handgun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.renderer.gun.TracheliumItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Trachelium
extends GunItem {
    public Trachelium() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.TRACHELIUM_RELOAD_EMPTY.get());
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return TracheliumItemRenderer::new;
    }

    private PlayState fireAnimPredicate(AnimationState<Trachelium> event) {
        boolean grip;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
        }
        boolean stock = GunData.from((ItemStack)stack).attachment.get(AttachmentType.STOCK) == 2;
        boolean bl = grip = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP) > 0 || GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE) > 0;
        if (stock) {
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
    }

    private PlayState idlePredicate(AnimationState<Trachelium> event) {
        boolean grip;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
        }
        boolean stock = GunData.from((ItemStack)stack).attachment.get(AttachmentType.STOCK) == 2;
        boolean bl = grip = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP) > 0 || GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE) > 0;
        if (GunData.from((ItemStack)stack).bolt.actionTimer.get() > 0) {
            if (stock) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action_stock_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action_stock"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            if (stock) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload_stock_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload_stock"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload"));
        }
        if (stock) {
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
    }

    private PlayState editPredicate(AnimationState<Trachelium> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
        }
        if (ClientEventHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController fireAnimController = new AnimationController((GeoAnimatable)this, "fireAnimController", 0, this::fireAnimPredicate);
        data.add(new AnimationController[]{fireAnimController});
        AnimationController idlePredicate = new AnimationController((GeoAnimatable)this, "idlePredicate", 3, this::idlePredicate);
        data.add(new AnimationController[]{idlePredicate});
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        data.add(new AnimationController[]{editController});
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237119_());
        list.add((Component)Component.m_237115_((String)"des.superbwarfare.trachelium_1").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        list.add((Component)Component.m_237115_((String)"des.superbwarfare.trachelium_2").m_130940_(ChatFormatting.GRAY));
        TooltipTool.addHideText(list, (Component)Component.m_237119_());
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.trachelium_3").m_130940_(ChatFormatting.WHITE));
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.trachelium_4").m_130948_(Style.f_131099_.m_178520_(0xF4F0FF)));
    }

    @Override
    public int[] getValidStocks() {
        return new int[]{0, 2};
    }

    @Override
    public int[] getValidScopes() {
        return new int[]{0, 1, 2};
    }

    @Override
    public boolean canSwitchScope(ItemStack stack) {
        return GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE) == 2;
    }

    private boolean useSpecialAttributes(ItemStack stack) {
        int scopeType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE);
        int gripType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP);
        return scopeType > 0 || gripType > 0;
    }

    @Override
    public double getCustomDamage(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 3.0;
        }
        return super.getCustomDamage(stack);
    }

    @Override
    public double getCustomZoom(ItemStack stack) {
        int scopeType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE);
        return scopeType == 2 ? (stack.m_41784_().m_128471_("ScopeAlt") ? 0.0 : 2.75) : 0.0;
    }

    @Override
    public double getCustomVelocity(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 15.0;
        }
        return super.getCustomVelocity(stack);
    }

    @Override
    public double getCustomHeadshot(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 0.5;
        }
        return super.getCustomHeadshot(stack);
    }

    @Override
    public double getCustomBypassArmor(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 0.1;
        }
        return super.getCustomBypassArmor(stack);
    }

    @Override
    public ResourceLocation getGunIcon(ItemStack stack) {
        return Mod.loc("textures/gun_icon/trachelium_icon.png");
    }

    @Override
    public boolean hasCustomBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomScope(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomStock(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEditAttachments(ItemStack stack) {
        return true;
    }
}

