/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.rifle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.Qbz191ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.GunsTool;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Qbz191Item
extends GunItem {
    public Qbz191Item() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return Qbz191ItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<Qbz191Item> event) {
        boolean grip;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.qbz_191.idle"));
        }
        boolean drum = GunData.from((ItemStack)stack).attachment.get(AttachmentType.MAGAZINE) == 2;
        boolean bl = grip = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP) == 1;
        if (GunData.from((ItemStack)stack).reload.empty()) {
            if (drum) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_empty_drum_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_empty_drum"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_empty_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_empty"));
        }
        if (GunData.from((ItemStack)stack).reload.normal()) {
            if (drum) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_normal_drum_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_normal_drum"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_normal_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.reload_normal"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.qbz_191.idle_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.qbz_191.idle"));
    }

    private PlayState editPredicate(AnimationState<Qbz191Item> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.qbz_191.idle"));
        }
        if (ClientEventHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.qbz_191.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.qbz_191.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        data.add(new AnimationController[]{editController});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        int gripType;
        super.m_6883_(stack, world, entity, slot, selected);
        int magType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.MAGAZINE);
        if (magType == 1) {
            CompoundTag tag = GunData.from(stack).attachment();
            tag.m_128405_("Magazine", 2);
        }
        if ((gripType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP)) == 3) {
            CompoundTag tag = GunData.from(stack).attachment();
            tag.m_128405_("Grip", 0);
        }
    }

    @Override
    public int[] getValidMagazines() {
        return new int[]{0, 2};
    }

    @Override
    public int[] getValidGrips() {
        return new int[]{0, 1, 2};
    }

    @Override
    public int getCustomMagazine(ItemStack stack) {
        int magType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.MAGAZINE);
        return magType == 2 ? 45 : 0;
    }

    @Override
    public double getCustomZoom(ItemStack stack) {
        int scopeType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE);
        return switch (scopeType) {
            case 2 -> 1.75;
            case 3 -> GunsTool.getGunDoubleTag(stack, "CustomZoom");
            default -> 0.0;
        };
    }

    @Override
    public boolean canAdjustZoom(ItemStack stack) {
        return GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE) == 3;
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.QBZ_191_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.QBZ_191_RELOAD_NORMAL.get());
    }

    @Override
    public ResourceLocation getGunIcon(ItemStack stack) {
        return Mod.loc("textures/gun_icon/qbz_191_icon.png");
    }

    @Override
    public boolean isOpenBolt(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasBulletInBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomMagazine(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomScope(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomStock(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEjectShell(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasBipod(ItemStack stack) {
        return GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP) == 1;
    }

    @Override
    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
        super.addReloadTimeBehavior(behaviors);
        behaviors.put(14, data -> data.holdOpen.set(false));
    }

    @Override
    public boolean canEditAttachments(ItemStack stack) {
        return true;
    }
}

