/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Shadow
    @Final
    private Minecraft f_104888_;
    @Shadow
    private ClientLevel f_104889_;

    @Inject(method={"handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void vehicleEntityUpdate(ClientboundSetPassengersPacket pPacket, CallbackInfo ci) {
        PacketUtils.m_131363_((Packet)pPacket, (PacketListener)((ClientPacketListener)this), (BlockableEventLoop)this.f_104888_);
        Entity entity = this.f_104889_.m_6815_(pPacket.m_133286_());
        if (!(entity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        ci.cancel();
        LocalPlayer player = this.f_104888_.f_91074_;
        assert (player != null);
        boolean hasIndirectPassenger = entity.m_20367_((Entity)player);
        entity.m_20153_();
        int[] passengers = pPacket.m_133283_();
        vehicle.entityIndexOverride = e -> {
            for (int i = 0; i < passengers.length; ++i) {
                if (passengers[i] != e.m_19879_()) continue;
                return i;
            }
            return -1;
        };
        for (int i : passengers) {
            Entity passenger;
            if (i == -1 || (passenger = this.f_104889_.m_6815_(i)) == null) continue;
            passenger.m_7998_(entity, true);
            if (passenger != player && !hasIndirectPassenger) continue;
            MutableComponent component = Component.m_237110_((String)"mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.m_90863_()});
            if (vehicle.allowEjection()) {
                component = Component.m_237110_((String)"tips.superbwarfare.mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.m_90863_()});
            }
            this.f_104888_.f_91065_.m_93063_((Component)component, false);
            this.f_104888_.m_240477_().m_168785_((Component)component);
        }
        vehicle.entityIndexOverride = null;
    }
}

