/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientMotionSyncMessage {
    public final int id;
    public final float x;
    public final float y;
    public final float z;

    public ClientMotionSyncMessage(Entity entity) {
        this(entity.m_19879_(), entity.m_20184_());
    }

    public ClientMotionSyncMessage(int id, Vec3 motion) {
        this.id = id;
        this.x = (float)motion.f_82479_;
        this.y = (float)motion.f_82480_;
        this.z = (float)motion.f_82481_;
    }

    public static void encode(ClientMotionSyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.id);
        buffer.writeFloat(message.x);
        buffer.writeFloat(message.y);
        buffer.writeFloat(message.z);
    }

    public static ClientMotionSyncMessage decode(FriendlyByteBuf buffer) {
        int id = buffer.m_130242_();
        double x = buffer.readFloat();
        double y = buffer.readFloat();
        double z = buffer.readFloat();
        return new ClientMotionSyncMessage(id, new Vec3(x, y, z));
    }

    public static void handler(ClientMotionSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientMotionSyncMessage.lambda$handler$1(message, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handler$1(ClientMotionSyncMessage message, Supplier ctx) {
        return () -> ClientMotionSyncMessage.lambda$handler$0(message, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handler$0(ClientMotionSyncMessage message, Supplier ctx) {
        ClientPacketHandler.handleClientSyncMotion(message, ctx);
    }
}

