/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.network.ClientPacketHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ContainerDataMessage {
    private final int containerId;
    private final List<Pair> data;

    public ContainerDataMessage(int containerId, List<Pair> data) {
        this.containerId = containerId;
        this.data = data;
    }

    public static ContainerDataMessage decode(FriendlyByteBuf buf) {
        return new ContainerDataMessage(buf.readUnsignedByte(), buf.m_236845_(byteBuf -> new Pair(byteBuf.readShort(), byteBuf.readLong())));
    }

    public static void encode(ContainerDataMessage message, FriendlyByteBuf buf) {
        buf.writeByte(message.containerId);
        buf.m_236828_(message.data, (byteBuf, p) -> p.write((FriendlyByteBuf)byteBuf));
    }

    public static void handler(ContainerDataMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ContainerDataMessage.lambda$handler$3(message, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handler$3(ContainerDataMessage message, Supplier ctx) {
        return () -> ContainerDataMessage.lambda$handler$2(message, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handler$2(ContainerDataMessage message, Supplier ctx) {
        ClientPacketHandler.handleContainerDataMessage(message.containerId, message.data, ctx);
    }

    public static class Pair {
        public int id;
        public long data;

        public Pair(int id, long data) {
            this.id = id;
            this.data = data;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeShort(this.id);
            buf.writeLong(this.data);
        }
    }
}

